      program kdatset
      use dfport
      implicit real*8 (a-h,o-z)
      character*60 modname,fnmodel,fngfdat
      character*80 line
      character*80 linput
      character*10 molcode
      dimension wl(99999),iz(10)
      character*80 linedir
      character*120 line120
      logical loexist,logfcor
      open (unit=1,status='scratch')
      write(6,*) 'title of the model atmosphere? (<=60 chars)'
      read(5,'(a)') linput
      write(1,'(a)') linput
      read(linput,'(a60)') modname
      write(6,*) 'file name of the model atmosphere ? (<=60 chars)'
      read(5,'(a)') linput
      write(1,'(a)') linput
      read(linput,'(a60)') fnmodel
      write(6,*) 'ifmol? [molecule on (1) or off (0)]?'
      read(5,'(a)') linput
      write(1,'(a)') linput
      read(linput,*) ifmol
      write(6,*) 'file name of the gf value data ? (<=60 chars)'
      read(5,'(a)') linput
      write(1,'(a)') linput
      read(linput,'(a60)') fngfdat
      open (unit=8,file=fngfdat)
      rewind 8
      ic=0
      wamin=1.e30
      wamax=1.e-30
      do i=1,99999
      read(8,*,end=19) cdum,wl(i)
      if(wl(i).le.0.) go to 19
      ic=ic+1
      if(wl(i).gt.wamax) wamax=wl(i)
      if(wl(i).lt.wamin) wamin=wl(i)
      end do
 19   continue
      nc=ic
      write(6,20) nc,wamin,wamax
 20   format('The gf value file contains',i5,' lines',
     &' from ',f9.3,' (A) to ',f9.3,' (A)')
      write(6,21)
 21   format('wlamin, wlamax ? ', 
     & '(integers, |wlamax-wlamin| < 100 A )')
      read(5,'(a)') linput
      write(1,'(a)') linput
      read(linput,*) wlamin,wlamax
      open (unit=9,file='selgf.out')
      rewind 9
      rewind 8
      inum=0
      do i=1,999999

      read(8,'(a)',end=59) line120
      read(line120,*) code,wla,expot,gflog,gammar,gammas,gammaw
      if(wla.lt.wlamin.or.wla.gt.wlamax) cycle

      logfcor=.false.
      dgfl=0.
      if(scan(line120,'@')*scan(line120,'&').ne.0) then
        logfcor=.true.
        iat=index(line120,'@')
        ish=index(line120,'&')
        read(line120(iat+1:ish-1),*) dgfl
      end if
      if(logfcor) gflog=gflog+dgfl

      dlgamr=0.
      if (gammar.gt.90..and.gammar.lt.110.) then
      dlgamr=gammar-100.
      gammar=0.
      end if

      dlgams=0.
      if (gammas.gt.90..and.gammas.lt.110.) then
      dlgams=gammas-100.
      gammas=0.
      end if

      dlgamw=0.
      if (gammaw.gt.90..and.gammaw.lt.110.) then
      dlgamw=gammaw-100.
      gammaw=0.
      end if

      write(9,'(f9.2,f10.3,f8.3,f8.3,3f7.2)')
     % code,wla,expot,gflog,gammar,gammas,gammaw
      inum=inum+1
      end do
   59 num=inum
      close (8)
      close (9)
      write(6,*) 
     % 'For how many elements you vary abundances (=<10) ?'
      read(5,'(a)') linput
      write(1,'(a)') linput
      read(linput,*) nv
      write(6,'(''OK, then input the atomic numbers for '',i2,
     %'' elements '')') nv
      read(5,'(a)') linput
      write(1,'(a)') linput
      read(linput,*) (iz(m),m=1,nv)
      inquire(file='kapfiles.lst',exist=loexist)
      if(.not.loexist) then
        open (unit=10,file='kapfiles.lst')
        if(ifmol.eq.1) then
          call getenv("SPT_DIR",linedir)
          call lablen(linedir,80,nsdir,nedir)
          write(10,'(a)') 'f  2  '//linedir(nsdir:nedir)//'\molec.dat'
        end if
        write(10,'(a)') 'f  5  kinput.in'
        write(10,'(a)') 'f  6  koutput.out'
        write(10,'(a)') 'f  9  selgf.out'
        write(10,'(a)') 'f 13'
        write(10,'(a)') 'f 14  prof.out'
        write(10,'(a)') 'f 15  eta.out'
        write(10,'(a)') 'u 30  kapsave.tmp'
        write(10,'(a)') 'u 40'
        close (10)
      end if
      open (unit=11,file='kinput.in')
      if(ifmol.eq.1) write(11,'(a)') 'MOLE'
      write(11,'(a)') 'VTUR'
      write(11,'(a)') '    1 2.00'
      write(11,'(a)') 'LCAL'
      write(11,'(a)') '    1    0'
      write(11,'(i10)') num
      write(11,'(a)') 'SYNT'
      write(11,'(a)') modname
      write(11,'(i5)') 1
      write(11,'(2f10.3)') wlamin,wlamax
      write(11,'(i10)') int((wlamax-wlamin)/0.01+1.5)
      write(11,'(i10)') int((wlamax-wlamin)/1.+0.5)
      write(11,'(2i10)') 1,num
      write(11,'(i4)') nv
      write(11,'(20i4)') (iz(m),m=1,nv)
      write(11,'(a)') 'END'
      open (unit=7,file=fnmodel)
      rewind 7
      do i=1,9999
      read(7,'(a)',end=333) line
      write(11,'(a)') line
      if(line(1:5).eq.'BEGIN') go to 333
      end do
 333  close(7)
      write(11,'(a)') 'END'
      write(11,'(a)') 'STOP'
      close(11)
c     now copies the content of temporary file #1 to ksetin.bak
      open (unit=2,file='ksetin.bak')
      rewind 1
      do k=1,99999
      read(1,'(a)',end=555) linput
      write(2,'(a)') linput
      end do
  555 close(2)
      close(1)
      stop
      end

      subroutine lablen(label,nlen,ns,ne)
      implicit real*8 (a-h,o-z)
      character*(*) label
      do n=nlen,1,-1
      if((label(n:n).ne.' ').and.(label(n:n).ne.'')) exit
      end do
      ne=n
      do n=1,nlen
      if((label(n:n).ne.' ').and.(label(n:n).ne.'')) exit
      end do
      ns=n
      return
      end

