c
c     Compiled in windows 7
c     fitsio subroutine and functions are commented out since they are not used
c
C     MODE=1...ROTATION    MODE=2...GAUSSIAN
C     VR(KM/S)=V1,EPS=V2   VH(KM/S)=V1,VF(KM/S)=V2
C     IF VH<0 , THEN ABS(VH) IS REGARDED AS FWHM. THEREFORE VH IS
C     CALCULATED AS ABS(VH)/(2*SQRT(DLOG(2))).
C     IF VF=0 , THEN VF IS AUTOMATICALLY SET AS VF=5*VH
C
C     INSTRUMENTAL PROFILE IS ASSUMED TO BE THE GAUSSIAN FUNCTION
C     BETWEEN -5*VHEM(KM/S) AND +5*VHEM(KM/S), WHERE VHEM IS THE
C     DISPLACEMENT (IN KM/S) OF THE E**(-1) POINT FROM THE LINE CENTER
C     (I.E. GAUSSIAN FUNCTION IS WRITTEN AS F(V)=CONST*E(-(V/VHEM)**2) )
C
c     obs.spectrum in the form of wla,flux in one line (97 Nov 9)
c     r0 is the control parameter (ifii=1 for r0>0, otherwise ifii=0)
c     (1998 May 24)
c     Now "ifbeta" has become a dummy parameter; namely, calculations are
c     always performed only in the beta-variable mode 
c     [If you prefer doing with beta=0, then comment out the line
c     before "write(60,35)".]
c     This is due to the unclarified effect of becoming ifbeta=0
c     (even if ifbeta=1 is specified at first) after the input process 
c     of observational spectra (2001 December 5)
c
      PROGRAM MPFIT
c--------------------------
      USE DFLIB
      USE DFPORT
c--------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
      EXTERNAL MJDATA,MHDATA
      PARAMETER (ME=1+6,MG=20,MA=ME+MG,MP=5,MM=MA+MP,MD=9999)
      PARAMETER (MVV=500,MRR=50,ML=2500)
      PARAMETER (MW=10001,mexr=99)
      parameter (mcoh=05)
      DIMENSION TYYP(MD),TYYM(MD),XT(MM),YT(MM)
      DIMENSION DYYDK(MD,MM),A(MM,MM),B(MM),DEL(MM)
      DIMENSION CABMAX(MA)
      COMMON/XVPASS/XV(MM),DXV(MM),TXV(MM)
      COMMON/NXY/ND,XX(MD),YY(MD),TYY(MD),TYCON(MD),mask(md)
      COMMON/ABL/NAB,IFAB(MA),IZE(MA),ABLG0(MA),DABLG(MA),NGF,NUMG(MG)
      COMMON/VTS/IFVTS,VTS0,DVTS
      COMMON/VMA/IFVMA,VMA0,DVMA
      COMMON/ROT/IFROT,VROT0,DVROT,ELIMD
      COMMON/DWN/IFDWN,DWNM0,DDWNM
      common/dxn/ifdxn,dxnm0,ddxnm
      common/iodine/r0,ifii,nnl,wstd(mw),fii(mw),fcomb(mw)
      COMMON/REF/CHAR(MM),MODE(MM),IFL(MM),LFI(MA),NUM(MP)
      COMMON/FFDATA/NVV,NRR,VV(0:MVV),RR(0:MRR),FF(0:MRR,0:MVV),
     #TFF(0:MVV)
      COMMON/DAMP/NDAMP,NND(ML),IND(ML)
      CHARACTER*80 LABMAC
      CHARACTER*72 LABEL
      CHARACTER*4 CHAR
      CHARACTER*4 CHT(MA)
      dimension wlaex1(mexr),wlaex2(mexr),xinc(md)
      COMMON/WLBAND/WLAMIN,WLAMAX
      REAL*8 WLAMIN,WLAMAX
      DATA PI/3.141592653589793238/
      character*60 fnopen,fname60
      integer*2 status
      integer*4 stat05(12),stat55(12)
      character*1 ch
      logical loexist,loopen
      character*60 fnobspec
      common/obspass/fnobspec
      common/wrange/wmne,wmxe,jbl,jbr,lolimit
      logical lolimit
      common/dvhem/dv,vhem
c
c---------------------------------------------------------------
      common/betpas/iterat,ys,beta
      common/iparm/kip,ap(-mcoh:+mcoh)
c
      type (qwinfo) winfo
      data if99/0/
c
      integer*2 narg1
      character*80 buf
      logical mstatus
c     menu editing
c
      mstatus=deletemenuqq(6,1)
      mstatus=deletemenuqq(6,1)
      mstatus=aboutboxqq('MPFIT (version 02.02.06) by Y. Takeda')
c

      narg1=1
      call getarg(narg1,buf)
      niter=1
      read(buf,*,err=101,end=101) niter
      go to 102
  101 write(*,*) 'No argument... niter=1 is assumed.'
  102 continue
      iter1=1
      iter2=niter
c
c     sets the size of the frame window maximum
      winfo.type=qwin$max
      status=setwsizeqq(qwin$framewindow,winfo)
c
      istatus=focusqq(0)
      call clearscreen($gclearscreen)
      call graphicsmode()
      call wsizeset(0)
c---------------------------------------------------------------
c
c      write(*,*) 'Input the name of the file including fileopen data'
c      read(*,'(64A)') fnopen
c     open (unit=1,file=fnopen)
      open (unit=1,file='mpffiles.lst')
      rewind 1
      call fileopen
      inquire(file='fornext.in',exist=loexist)
      iu5=5
      if(.not.loexist) go to 309
c&&&&&
      ir05=fstat(05,stat05)
      inquire(55,opened=loopen)
      if(.not.loopen) open (unit=55,file='fornext.in')
      ir55=fstat(55,stat55)
      if(stat05(10).gt.stat55(10)) go to 309
c      write(*,'('' minput.in:'',i10)') stat05(10)
c      write(*,'(''fornext.in:'',i10)') stat55(10)
      write(*,*)
     &'Original input file "minput.in" is older than "fornext.in"'
      write(*,*)
     &'(new input file made from solution of the previous iteration)'
      write(*,*)
     &'Do you use this "fornext.in" as input data of this job?'
      write(*,*) '(i.e., continue the previous iteration run '//
     &'succeeding the solution?)'
      ch=' '
      do while(ch.ne.'y'.and.ch.ne.'n')
      write(*,
     & '('' If so, key "y" (otherwise "n" for using minput.in)--> '',$)'
     & )
      ch=getcharqq()
      write(*,'(a)') ch
      end do
      if(ch.eq.'y') then
      write(*,*) ' Using "fornext.in" as input data ...'
      iu5=55
      else
      write(*,*) ' Using "minput.in" as usual ...'
      iu5=5
      end if
c&&&&&
  309 continue
      REWIND iu5
      READ(iu5,14) LABEL
   14 FORMAT(A72)
      WRITE(6,914) LABEL
  914 FORMAT(1H ,3X,A72)
c     idum1 and idum2 are nearly dummy for the case of minput.in
c     (but idum1<0 requests theoretical spectra written to file 70)
      READ(iu5,15) IDUM1,IDUM2,DV,IFBETA,r0
   15 FORMAT(2I4,F6.2,I4,f6.2)
c
      if(iu5.eq.55) then
      read(label,'(68x,i4)') itpre
      iter2=itpre+niter
      iter1=itpre+1
      write(6,*)  'succeeding previous iteration:'
      write(6,*) 'iter1=',iter1,'  iter2=',iter2
      write(6,*)
      end if
c
      ifii=0
      if(r0.gt.0.) ifii=1
      WRITE(6,915) ITER1,ITER2,DV,IFBETA,r0,ifii
  915 FORMAT(1H ,3X,'ITER1:',I3,3X,'ITER2:',I3,3X,'DV:',F6.2,3X,
     %'IFBETA:',I2,3x,'r0:',f6.2,3x,'ifii:',i2)
      READ(iu5,20) WLAMIN,WLAMAX,VHEM,OWLADD
   20 FORMAT(2F10.2,F10.4,F10.2)
      WRITE(6,920) WLAMIN,WLAMAX,VHEM,OWLADD
  920 FORMAT(1H ,3X,'WLAMIN(A):',F8.2,3X,'WLAMAX(A):',F8.2,3X,
     %'VHEM(KM/S):',F8.4,3X,'OWLADD:',F8.2)
      IF(VHEM.LT.0.) THEN
      WRITE(6,*) 'CHECK VHEM]'
      CALL EXIT
      END IF
      IF(VHEM.GT.0..AND.INT(VHEM/DV).LT.5) THEN
      WRITE(6,*) 'VHEM/DV<5] MAKE DV SMALLER]'
      CALL EXIT
      END IF
C++++
      IF(IDUM1.LT.0) THEN
      DLA=FLOAT(IABS(IDUM1))/100.
      ND=INT((WLAMAX-WLAMIN)/DLA+1.5)
      DO 8950 J=1,ND
      XX(J)=WLAMIN+DLA*FLOAT(J-1)
 8950 XX(J)=XX(J)/10.
      GO TO 8960
      END IF
C++++
      n9=9
      inquire(n9,opened=loopen)
      if(loopen) close (n9)

       call checkfit(fnobspec,ifbl,norder)
       if(norder.ge.0) then
       write(*,*) 'FITS FILES ARE NOT SUPPORTED IN THIS MPFIT VERSION!'
       stop
c             call fitsread(n9,fnobspec,ifbl,norder, npt, tyyp, tyym)
       else
             call sread(n9,fnobspec, npt, tyyp, tyym)
       end if
       icnt=0
       do i=1,npt
        if(tyyp(i).lt.wlamin.or.tyyp(i).gt.wlamax) cycle
        icnt=icnt+1
        xx(icnt)=tyyp(i)
        yy(icnt)=tyym(i)
       end do
       nd=icnt
       if(owladd.ne.0.) then
        do j=1,nd
                xx(j)=xx(j)+owladd
        end do
       end if
      DO 10 J=1,ND
      XX(J)=XX(J)/10.
      YY(J)=DLOG10(YY(J))
   10 CONTINUE
 8960 CONTINUE
      READ(iu5,40) NAB,NGF
   40 FORMAT(I2,I3)
      WRITE(6,940) NAB,NGF
  940 FORMAT(1H ,3X,'NAB:',I2,2X,'NGF:',I3)
      DO 45 I=1,NAB
      READ(iu5,50) IFAB(I),IZE(I),CHT(I),ABLG0(I),DABLG(I),CABMAX(I)
   50 FORMAT(I2,I3,1X,A4,2F7.3,F6.2)
      WRITE(6,943) IFAB(I),IZE(I),CHT(I),ABLG0(I),DABLG(I),CABMAX(I)
  943 FORMAT(1H ,3X,I2,I3,1X,A4,1X,2F7.3,F6.2)
   45 CONTINUE
      DO 1045 I=NAB+1,NAB+NGF
      READ(iu5,50) IFAB(I),IZE(I),CHT(I),ABLG0(I),DABLG(I),CABMAX(I)
      WRITE(6,943) IFAB(I),IZE(I),CHT(I),ABLG0(I),DABLG(I),CABMAX(I)
      NUMG(I-NAB)=IZE(I)
 1045 CONTINUE
      READ(iu5,43) IFVTS,VTS0,DVTS,CVTMAX
   43 FORMAT(I2,2F7.2,F6.1)
      WRITE(6,950) IFVTS,'VTUR',VTS0,DVTS,CVTMAX
  950 FORMAT(1H ,3X,I2,1X,A4,1X,2F7.2,F6.1)
      READ(iu5,44) IFVMA,VMA0,DVMA,CVMMAX
   44 FORMAT(I2,2F7.2,F6.1)
      WRITE(6,944) IFVMA,'VMAC',VMA0,DVMA,CVMMAX
  944 FORMAT(1H ,3X,I2,1X,A4,1X,2F7.2,F6.1)
      READ(iu5,51) IFROT,VROT0,DVROT,CVRMAX,ELIMD
   51 FORMAT(I2,2F7.2,F6.1,F6.3)
      WRITE(6,951) IFROT,'VROT',VROT0,DVROT,CVRMAX,ELIMD
  951 FORMAT(1H ,3X,I2,1X,A4,1X,2F7.2,F6.1,3X,'(ELIMD:',F6.3,')')
      READ(iu5,52) IFDWN,DWNM0,DDWNM,CDWMAX
   52 FORMAT(I2,2F7.4,F6.3)
      WRITE(6,952) IFDWN,'DWNM',DWNM0,DDWNM,CDWMAX
  952 FORMAT(1H ,3X,I2,1X,A4,1X,2F7.4,F6.3)
      kip=0
      do i=1,nab
      if(cht(i).eq.'<ip>'.or.cht(i).eq.'<IP>') kip=kip+1
      end do
      if(mod(kip,2).ne.0) then
      write(*,*) 'why not even ? --> kip=',kip
      stop
      end if
      if(kip/2.gt.mcoh) then
      write(*,*) 'kip/2 > mcoh ! : --> ',kip/2,mcoh
      stop
      end if
      if(ifii.eq.1) then
        if(cht(1).ne.'<II>'.and.cht(1).ne.'<ii>') then
            write(6,*) 'check cht(1)'
            call exit
        end if
        if(r0.le.0.) then
            write(6,*) 'check r0'
            call exit
        end if
        READ(iu5,53) IFDXN,DXNM0,DDXNM,CDXMAX
   53   FORMAT(I2,2F7.4,F6.3)
        WRITE(6,3953) IFDXN,'DXNM',DXNM0,DDXNM,CDXMAX
 3953   FORMAT(1H ,3X,I2,1X,A4,1X,2F7.4,F6.3)
      end if
      N=0
      DO 48 L=1,NAB
   48 N=N+IFAB(L)
      DO 1048 L=NAB+1,NAB+NGF
 1048 N=N+IFAB(L)
      N=N+IFVTS+IFVMA+IFROT+IFDWN
      if(ifii.eq.1) n=n+ifdxn
      WRITE(6,953) N
  953 FORMAT(1H ,3X,'<<< N:',I2,' >>>')
C
      DO 83 IL=1,ML
   83 IND(IL)=0
      READ(iu5,65) NDAMP,nexr
      WRITE(6,965) NDAMP,nexr
      IF(NDAMP.LE.0) GO TO 82
      READ(iu5,65) (NND(II),II=1,NDAMP)
   65 FORMAT(20I4)
      WRITE(6,965) (NND(II),II=1,NDAMP)
  965 FORMAT(1H ,3X,20I4)
 1965 FORMAT(20I4)
      DO 84 II=1,NDAMP
c       IF(NND(II).LT.1.OR.NND(II).GT.ML) THEN
       IF(NND(II).GT.ML) THEN
       WRITE(6,*) 'NND CHECK ]'
       CALL EXIT
       END IF
       if(nnd(ii).le.0) go to 84
       IND(NND(II))=II
   84 CONTINUE
   82 CONTINUE
      do j=1,md
      mask(j)=1
      end do
      if(nexr.le.0) go to 782
      do m=1,nexr
        read(iu5,'(2f8.2)') wlaex1(m),wlaex2(m)
        write(6,'(1h ,2f8.2)') wlaex1(m),wlaex2(m)
      end do
      do j=1,nd
      xxa=xx(j)*10.
        do m=1,nexr
          if(xxa.ge.wlaex1(m).and.xxa.lt.wlaex2(m)) mask(j)=0
        end do
      end do
  782 continue
      if(loex) close(iu5)
C
      inquire(60,name=fname60)
      close(60)
      if(iu5.eq.5) then
      open (unit=60,form='formatted',file=fname60,access='sequential')
      else
      open (unit=60,form='formatted',file=fname60,access='append')
      end if
C|||||||||||||||||||||||||||||||||
c     forced into beta mode
      ifbeta=1
C|||||||||||||||||||||||||||||||||
      WRITE(60,35)
   35 FORMAT('-------------------- INPUT DATA -----------------------')
      WRITE(60,'(A72)') LABEL
      WRITE(60,15)ITER1,ITER2,DV,IFBETA,r0
      WRITE(60,20)WLAMIN,WLAMAX,VHEM,OWLADD
      WRITE(60,40)NAB,NGF
      IF(NAB.GT.0) THEN
      DO I=1,NAB
      WRITE(60,50)IFAB(I),IZE(I),CHT(I),ABLG0(I),DABLG(I),CABMAX(I)
      END DO
      END IF
      IF(NGF.GT.0) THEN
      DO I=NAB+1,NAB+NGF
      WRITE(60,50)IFAB(I),IZE(I),CHT(I),ABLG0(I),DABLG(I),CABMAX(I)
      END DO
      END IF
      WRITE(60,43)IFVTS,VTS0,DVTS,CVTMAX
      WRITE(60,44)IFVMA,VMA0,DVMA,CVMMAX
      WRITE(60,51)IFROT,VROT0,DVROT,CVRMAX,ELIMD
      WRITE(60,52)IFDWN,DWNM0,DDWNM,CDWMAX
      IF(IFDXN.EQ.1) THEN
      WRITE(60,53)IFDXN,DXNM0,DDXNM,CDXMAX
      END IF
      WRITE(60,65) NDAMP,nexr
      IF(NDAMP.GT.0) THEN
      WRITE(60,65) (NND(II),II=1,NDAMP)
      END IF
      if(nexr.gt.0) then
      do m=1,nexr
        write(60,'(2f8.2)') wlaex1(m),wlaex2(m)
      end do
      end if
      WRITE(60,36)
   36 FORMAT('-------------------------------------------------------')
      IF(N.GT.MM) THEN
      WRITE(6,*) 'N=',N,'  IS LARGER THAN MM]'
      CALL EXIT
      END IF
      IF(VMA0.EQ.0.) THEN
       IF(IFVMA.NE.0) THEN
       WRITE(6,*) 'WHY NOT IFVMA=0 IN THIS CASE OF VMA0=0 ?'
       CALL EXIT
       END IF
      GO TO 121
      END IF
C
C     READ MACROTURB+ROTATION BROADENING FUNCTION FROM FILE 3
C
      inquire(3,opened=loopen)
      if(.not.loopen) go to 121
      REWIND 3
      READ(3,21) ZT,ZR,AT,AR,EPSLIM,DRM,LABMAC
   21 FORMAT(6F6.3,4X,A80)
      READ(3,22) NVV
   22 FORMAT(I4)
      READ(3,23) (VV(M),M=0,NVV)
   23 FORMAT(20F6.3)
      READ(3,22) NRR
      READ(3,23) (RR(J),J=0,NRR)
      IF(NVV.NE.MVV.OR.NRR.NE.MRR) THEN
      WRITE(6,*) 'NVV<>MVV OR NRR<>MRR ]'
      CALL EXIT
      END IF
      DO 24 M=0,NVV
      READ(3,21)
      READ(3,25) (FF(J,M),J=0,NRR)
   25 FORMAT(10E12.5)
   24 CONTINUE
      WRITE(6,*) '# # # # # # FILE 3  INFORMATION # # # # # #'
      WRITE(6,16) LABMAC
   16 FORMAT(1H ,'LABMAC:',A80)
      WRITE(6,17) ZT,ZR,AT,AR,DRM
   17 FORMAT(1H ,'ZT,ZR,AT,AR,DRM:',5F6.3)
      WRITE(6,18) EPSLIM
   18 FORMAT(1H ,'EPSLIM:',F6.3)
      IF(ABS(EPSLIM-ELIMD).GT.0.01) THEN
      WRITE(6,*) 'EPSLIM NOT COMPATIBLE WITH ELIMD] IS IT OK?'
      END IF
      WRITE(6,*) '# # # # # # # # # # # # # # # # # # # # #'
C
  121 CONTINUE
      DO 120 I=1,MA
  120 LFI(I)=0
      DO 125 L=1,MM
      IFL(L)=0
  125 MODE(L)=0
      LL=0
      DO 59 I=1,NAB
      IF(IFAB(I).EQ.1) THEN
      LL=LL+1
      MODE(LL)=-IZE(I)
      IF(IZE(I).LT.0) MODE(LL)=-100-IABS(IZE(I))
      CHAR(LL)=CHT(I)
      IFL(LL)=I
      LFI(I)=LL
      END IF
   59 CONTINUE
      DO 1059 I=NAB+1,NAB+NGF
      IF(IFAB(I).EQ.1) THEN
      LL=LL+1
      MODE(LL)=1000+IZE(I)
      IF(IZE(I).LT.0) MODE(LL)=1100+IABS(IZE(I))
      CHAR(LL)=CHT(I)
      IFL(LL)=I
      LFI(I)=LL
      END IF
 1059 CONTINUE
      IF(IFVTS.EQ.1) THEN
      LL=LL+1
      MODE(LL)=1
      CHAR(LL)='VTUR'
      NUM(1)=LL
      END IF
      IF(IFVMA.EQ.1) THEN
      LL=LL+1
      MODE(LL)=2
      CHAR(LL)='VMAC'
      NUM(2)=LL
      END IF
      IF(IFROT.EQ.1) THEN
      LL=LL+1
      MODE(LL)=3
      CHAR(LL)='VROT'
      NUM(3)=LL
      END IF
      IF(IFDWN.EQ.1) THEN
      LL=LL+1
      MODE(LL)=4
      CHAR(LL)='DWNM'
      NUM(4)=LL
      END IF
      if(ifii.eq.1.and.ifdxn.eq.1) then
      ll=ll+1
      mode(ll)=5
      char(ll)='DXNM'
      num(5)=ll
      end if
      IF(N.NE.LL) THEN
      WRITE(6,*) 'N=',N,'  LL=',LL
      CALL EXIT
      END IF
      DO 230 L=1,N
      IF(MODE(L).LT.0) THEN
      I=IFL(L)
      XV(L)=ABLG0(I)
      DXV(L)=DABLG(I)
      END IF
      IF(MODE(L).GT.1000) THEN
      I=IFL(L)
      XV(L)=ABLG0(I)
      DXV(L)=DABLG(I)
      END IF
      IF(MODE(L).EQ.1) THEN
      XV(L)=VTS0
      DXV(L)=DVTS
      END IF
      IF(MODE(L).EQ.2) THEN
      XV(L)=VMA0
      DXV(L)=DVMA
      END IF
      IF(MODE(L).EQ.3) THEN
      XV(L)=VROT0
      DXV(L)=DVROT
      END IF
      IF(MODE(L).EQ.4) THEN
      XV(L)=DWNM0
      DXV(L)=DDWNM
      END IF
      if(ifii.eq.1.and.mode(l).eq.5) then
      xv(l)=dxnm0
      dxv(l)=ddxnm
      end if
  230 CONTINUE
      ITERAT=ITER1-1
    1 CONTINUE
      ITERAT=ITERAT+1
      WRITE(6,880) ITERAT
  880 FORMAT(1H ///'############################## ITERAT=',I2,
     #' ##############################'/)
c
      WRITE(*,881) ITERAT
  881 FORMAT('############################## Iteration',I2,
     #' ##############################')
c
      WRITE(60,1880) ITERAT
 1880 FORMAT(' ITERAT#',I2)
C++++
      IF (IDUM1.LT.0) THEN
      DO 8305 L=1,N
 8305 TXV(L)=XV(L)
      CALL CONVOL
c      REWIND 70
c      WRITE(70,8307) LABEL
c 8307 FORMAT('WLA-FLUXES',4X,A72)
c      WRITE(70,8308) ND
c 8308 FORMAT(I4)
c      WRITE(70,8309) (XX(J)*10.,EXP10(TYY(J)),J=1,ND)
c 8309 FORMAT(5(0PF12.5,1PE12.5))
c      WRITE(70,8310) (INT(EXP10(TYY(J)-TYCON(J))*1.E5+0.5),J=1,ND)
c 8310 FORMAT(20I6)
      rewind 70
c      write(70,'(a72)') label
c      write(70,'(i4)') nd
      if(dwnm0.ne.0.) then
      do j=1,nd
      xx(j)=xx(j)-dwnm0
      end do
      end if
      do j=1,nd
       write(70,'(0pf10.4,2x,0pf10.5,2x,1pe12.5)')
     # xx(j)*10.,exp10(tyy(j)-tycon(j)),exp10(tyy(j))
      end do
      WRITE(6,*) 'EXIT CALL (IDUM1<0) AFTER SPECTRA-OUTPUT TO FILE 70'
      CALL EXIT
      END IF
C++++
      DO 300 K=1,N
      DO 305 L=1,N
  305 TXV(L)=XV(L)
      TXV(K)=XV(K)+DXV(K)
      CALL CONVOL
      DO 310 J=1,ND
  310 TYYP(J)=TYY(J)
      TXV(K)=XV(K)-DXV(K)
      CALL CONVOL
      DO 320 J=1,ND
  320 TYYM(J)=TYY(J)
      DO 330 J=1,ND
  330 DYYDK(J,K)=(TYYP(J)-TYYM(J))/(2.*DXV(K))
  300 CONTINUE
      DO 335 L=1,N
  335 TXV(L)=XV(L)
      CALL CONVOL
c     calculation of ndt
      ncou=0
      do j=1,nd
      ncou=ncou+mask(j)
      end do
      ndt=ncou
      IF(IFBETA.EQ.0) THEN
C     FOR THE CASE OF CONSTANT C
      BETA=0.
      SUM=0.
      DO 340 J=1,ND
  340 SUM=SUM+mask(j)*(YY(J)-TYY(J))
      YS=SUM/FLOAT(ndt)
      SUMSQ=0.
      DO 345 J=1,ND
  345 SUMSQ=SUMSQ+mask(j)*(YY(J)-TYY(J)-YS)**2
      SIG=SQRT(SUMSQ/FLOAT(ndt))
      DO 400 L=1,N
      B(L)=0.
      DO 400 K=1,N
  400 A(L,K)=0.
      DO 500 L=1,N
      SB=0.
      SDYL=0.
      DO 510 J=1,ND
      SB=SB+mask(j)*(YY(J)-TYY(J)-YS)*DYYDK(J,L)
  510 SDYL=SDYL+mask(j)*DYYDK(J,L)
      B(L)=SB
      DO 520 K=1,N
      SA=0.
      SDYK=0.
      DO 530 J=1,ND
      SA=SA+mask(j)*DYYDK(J,L)*DYYDK(J,K)
  530 SDYK=SDYK+mask(j)*DYYDK(J,K)
      A(L,K)=SA-SDYK*SDYL/FLOAT(ndt)
  520 CONTINUE
  500 CONTINUE
      ELSE
C     FOR THE CASE OF LINEARLY WAVELENGTH-DEPENDENT C (GRADIENT BETA)
      SUMA=0.
      SUMB=0.
      SUMR=0.
      SUMS=0.
      DO 600 J=1,ND
      SUMA=SUMA+mask(j)*(XX(J)-XX(1))
      SUMB=SUMB+mask(j)*(XX(J)-XX(1))**2
      SUMR=SUMR+mask(j)*(YY(J)-TYY(J))
      SUMS=SUMS+mask(j)*(XX(J)-XX(1))*(YY(J)-TYY(J))
  600 CONTINUE
      AT=SUMA
      BT=SUMB
      RT=SUMR
      ST=SUMS
      DT=FLOAT(ndt)*BT-AT**2
      YS=(BT*RT-AT*ST)/DT
      BETA=(FLOAT(ndt)*ST-AT*RT)/DT
      SUMSQ=0.
      DO 610 J=1,ND
  610 SUMSQ=SUMSQ+mask(j)*(YY(J)-TYY(J)-YS-BETA*(XX(J)-XX(1)))**2
      SIG=SQRT(SUMSQ/FLOAT(ndt))
      DO 620 L=1,N
      XT(L)=0.
      YT(L)=0.
      B(L)=0.
      DO 620 K=1,N
  620 A(L,K)=0.
      DO 630 L=1,N
      SB=0.
      SXL=0.
      SYL=0.
      DO 640 J=1,ND
      SB=SB+mask(j)*(YY(J)-TYY(J)-YS-BETA*(XX(J)-XX(1)))*DYYDK(J,L)
      SXL=SXL+mask(j)*DYYDK(J,L)
  640 SYL=SYL+mask(j)*DYYDK(J,L)*(XX(J)-XX(1))
      B(L)=SB
      XT(L)=SXL
      YT(L)=SYL
  630 CONTINUE
      DO 650 L=1,N
      DO 650 K=1,N
      SZLK=0.
      DO 660 J=1,ND
  660 SZLK=SZLK+mask(j)*DYYDK(J,L)*DYYDK(J,K)
      A(L,K)=SZLK+(AT*XT(L)*YT(K)-BT*XT(L)*XT(K)
     %            +AT*YT(L)*XT(K)-FLOAT(ndt)*YT(L)*YT(K))/DT
  650 CONTINUE
      END IF
      xx1=xx(1)
      if(mask(1).eq.0) xx1=-xx(1)
      WRITE(60,1450) ND,xx1
 1450 FORMAT(I4,F12.5)
      DO 1400 J=1,ND
 1400 WRITE(6,1500) XX(J),YY(J),TYY(J)+YS+BETA*(XX(J)-XX(1)),
     &TYY(J)-TYCON(J),(DYYDK(J,L),L=1,N)
c
c      DO 1401 J=1,ND
c 1401 WRITE(*,1500) XX(J),YY(J),TYY(J)+YS+BETA*(XX(J)-XX(1)),
c     &TYY(J)-TYCON(J),(DYYDK(J,L),L=1,N)
c
 1500 FORMAT(1H ,F10.4,2X,2F10.4,2X,'(',F8.4,')',5X,10F8.4)
c     calculation of xx(j)-xx(1) (substituted to xinc)
      do j=1,nd
      xinc(j)=xx(j)-xx(1)
      if(mask(j).eq.0) xinc(j)=-xinc(j)
      end do
      WRITE(60,1550) (xinc(j),j=1,nd)
 1550 FORMAT(10F8.5)
      WRITE(60,1560) (YY(J),J=1,ND)
      WRITE(60,1560) (TYY(J)+YS+BETA*(XX(J)-XX(1)),J=1,ND)
      WRITE(60,1560) (TYY(J)-TYCON(J),J=1,ND)
 1560 FORMAT(10F8.4)
      CALL MATINV(A,N,MM)
      DO 560 K=1,N
      SUM=0.
      DO 570 M=1,N
  570 SUM=SUM+A(K,M)*B(M)
      DEL(K)=SUM
  560 CONTINUE
      WRITE(60,1450) N
      DO 800 K=1,N
C....
      IF(MODE(K).LT.0) THEN
      CHGMAX=CABMAX(IFL(K))
      ELSE
      IF(MODE(K).EQ.1) CHGMAX=CVTMAX
      IF(MODE(K).EQ.2) CHGMAX=CVMMAX
      IF(MODE(K).EQ.3) CHGMAX=CVRMAX
      IF(MODE(K).EQ.4) CHGMAX=CDWMAX
      END IF
      CHG=DEL(K)
      CHG=MAX(-CHGMAX,CHG)
      CHG=MIN(+CHGMAX,CHG)
C....
  714 FORMAT(1H ,3X,I2,2X,A4,2X,'X(CUR)=',F10.4,2X,'DX(T)=',F10.4,
     \2X,'(DX(A)=',F10.4,')',2X,'X(NEW)=',F10.4)
  716 FORMAT(1H ,3X,I2,2X,A4,2X,'X(CUR)=',F10.6,2X,'DX(T)=',F10.6,
     \2X,'(DX(A)=',F10.6,')',2X,'X(NEW)=',F10.6)
 1714 FORMAT(1H ,3X,I2,2X,A4,2X,'X(CUR)=',F10.4,
     \2X,'(DX(A)=',F10.4,')',2X,'X(NEW)=',F10.4)
 1716 FORMAT(1H ,3X,I2,2X,A4,2X,'X(CUR)=',F10.6,
     \2X,'(DX(A)=',F10.6,')',2X,'X(NEW)=',F10.6)
  724 FORMAT(I2,2X,A4,2X,2F10.4,2X,'(',F8.4,')',F10.4)
  726 FORMAT(I2,2X,A4,2X,2F10.6,2X,'(',F8.6,')',F10.6)
      IF(K.LT.N-IFDXN) THEN
      WRITE(6,714) K,CHAR(K),XV(K),DEL(K),CHG,XV(K)+CHG
      WRITE(*,1714) K,CHAR(K),XV(K),CHG,XV(K)+CHG
      WRITE(60,724) K,CHAR(K),XV(K),DEL(K),CHG,XV(K)+CHG
      ELSE
      WRITE(6,716) K,CHAR(K),XV(K),DEL(K),CHG,XV(K)+CHG
      WRITE(*,1716) K,CHAR(K),XV(K),CHG,XV(K)+CHG
      WRITE(60,726) K,CHAR(K),XV(K),DEL(K),CHG,XV(K)+CHG
      END IF
      XV(K)=XV(K)+CHG
  800 CONTINUE
      WRITE(6,390) YS,SIG,BETA
      WRITE(*,390) YS,SIG,BETA
  390 FORMAT(1H ,5X,'YS=',F10.4,5X,'SIG=',F10.6,5X,'BETA=',1PE12.5)
c      WRITE(*,*)
      WRITE(*,'(''Iteration '',I2,'' has been completed.'')') ITERAT
      WRITE(60,1390) YS,SIG,BETA
 1390 FORMAT(F10.4,F10.6,5X,1PE12.5)
c!!!!! now write the current solution out to fornext.in !!!!!
c!!!!! which has the same format as that of minput.in   !!!!!
      OPEN (UNIT=55,FILE='fornext.in')
      REWIND 55
      WRITE(55,'(A68,I4)') LABEL(1:68),ITERAT
      WRITE(55,15)ITER1,ITER2,DV,IFBETA,r0
      WRITE(55,20)WLAMIN,WLAMAX,VHEM,OWLADD
      WRITE(55,40)NAB,NGF
      IF(NAB.GT.0) THEN
      K=0
      DO I=1,NAB
        IF(IFAB(I).EQ.1) THEN
          K=K+1
          SOL=XV(K)
        ELSE
          SOL=ABLG0(I)
        END IF
      WRITE(55,50)IFAB(I),IZE(I),CHT(I),SOL,DABLG(I),CABMAX(I)
      END DO
      END IF
      IF(NGF.GT.0) THEN
      DO I=NAB+1,NAB+NGF
        IF(IFAB(I).EQ.1) THEN
          K=K+1
          SOL=XV(K)
        ELSE
          SOL=ABLG0(I)
        END IF
      WRITE(55,50)IFAB(I),IZE(I),CHT(I),SOL,DABLG(I),CABMAX(I)
      END DO
      END IF
C
      IF(IFVTS.EQ.1) THEN
      K=K+1
      SOL=XV(K)
      ELSE
      SOL=VTS0
      END IF
      WRITE(55,43)IFVTS,SOL,DVTS,CVTMAX
C
      IF(IFVMA.EQ.1) THEN
      K=K+1
      SOL=XV(K)
      ELSE
      SOL=VMA0
      END IF
      WRITE(55,44)IFVMA,SOL,DVMA,CVMMAX
C
      IF(IFROT.EQ.1) THEN
      K=K+1
      SOL=XV(K)
      ELSE
      SOL=VROT0
      END IF
      WRITE(55,51)IFROT,SOL,DVROT,CVRMAX,ELIMD
C
      IF(IFDWN.EQ.1) THEN
      K=K+1
      SOL=XV(K)
      ELSE
      SOL=DWNM0
      END IF
      WRITE(55,52)IFDWN,SOL,DDWNM,CDWMAX
C
      IF(IFDXN.EQ.1) THEN
      K=K+1
      SOL=XV(K)
      WRITE(55,53)IFDXN,SOL,DDXNM,CDXMAX
      END IF
      IF(K.NE.N) THEN
      WRITE(6,*) 'K=',K,'     N=',N
      STOP
      END IF
C
      WRITE(55,65) NDAMP,nexr
      IF(NDAMP.GT.0) THEN
      WRITE(55,65) (NND(II),II=1,NDAMP)
      END IF
      if(nexr.gt.0) then
      do m=1,nexr
        write(55,'(2f8.2)') wlaex1(m),wlaex2(m)
      end do
      end if
      CLOSE (55)
c!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
c
c----- showing spectrum ----
c
c     opens the grahic window (99)
      if(if99.eq.0) then
        open (unit=99,file='USER')
        if99=1
      end if
c
      call showfit
c---------------------------
      IF(ITERAT.LT.ITER2) GO TO 1
      write (*,*) 'press enter to close graphic window:'
      read(*,'(a)') ch
c      ch=getcharqq()
      write(*,*) 'ending now ...'
      close (99)
  999 STOP
      END
      FUNCTION EXP10(X)
      IMPLICIT REAL*8 (A-H,O-Z)
      EXP10=EXP(X*2.30258509299405D0)
      RETURN
      END
      SUBROUTINE CONVOL
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MW=10001,MW1=MW-1,MC=60,MF=60000,MH=5000)
      PARAMETER (ME=1+6,MG=20,MA=ME+MG,MP=5,MM=MA+MP,MD=9999)
      PARAMETER (MVV=500,MRR=50)
      parameter (mcoh=05)
      DIMENSION G(-MH:+MH),W(-MH:+MH),TVV(0:MH)
      COMMON/TEMP/DVA(MW1),VA(MW),FA(MW),VB(MF),WLNB(MF),FB(MF),FG(MF)
      COMMON/FLUSS/NLAM,WLTH(MW),FLAM(MW),NCON,WVCON(MC),FCON(MC)
      REAL*8 WLTH,WVCON
      COMMON/XVPASS/XV(MM),DXV(MM),TXV(MM)
      COMMON/NXY/ND,XX(MD),YY(MD),TYY(MD),TYCON(MD)
      COMMON/ABL/NAB,IFAB(MA),IZE(MA),ABLG0(MA),DABLG(MA),NGF,NUMG(MG)
      COMMON/VTS/IFVTS,VTS0,DVTS
      COMMON/VMA/IFVMA,VMA0,DVMA
      COMMON/ROT/IFROT,VROT0,DVROT,ELIMD
      COMMON/DWN/IFDWN,DWNM0,DDWNM
      common/dxn/ifdxn,dxnm0,ddxnm
      common/iodine/r0,ifii,nnl,wstd(mw),fii(mw),fcomb(mw)
      COMMON/REF/CHAR(MM),MODE(MM),IFL(MM),LFI(MA),NUM(MP)
      COMMON/FFDATA/NVV,NRR,VV(0:MVV),RR(0:MRR),FF(0:MRR,0:MVV),
     #TFF(0:MVV)
      common/dwpass/tdwnm
      common/dvhem/dv,vhem
      common/iparm/kip,ap(-mcoh:+mcoh)
      CHARACTER*4 CHAR
      COMMON/WLBAND/WLAMIN,WLAMAX
      REAL*8 WLAMIN,WLAMAX,WLN1,WLN2
      DIMENSION TABLG(MA),TDGFL(MG)
      dimension wtemp(mw),ftemp(mw),fiimap(mf)
      DATA PI/3.141592653589793238/
      logical loopen
      DO 800 I=1,NAB
      IF(IFAB(I).EQ.1) THEN
      L=LFI(I)
      TABLG(I)=TXV(L)
      ELSE
      TABLG(I)=ABLG0(I)
      END IF
  800 CONTINUE
      DO 1800 J=1,NGF
      IF(IFAB(NAB+J).EQ.1) THEN
      L=LFI(NAB+J)
      TDGFL(J)=TXV(L)
      ELSE
      TDGFL(J)=ABLG0(NAB+J)
      END IF
 1800 CONTINUE
      IF(IFVTS.EQ.1) THEN
      TVTS=TXV(NUM(1))
      ELSE
      TVTS=VTS0
      END IF
      CALL SYNTH(NAB,IZE,TABLG,TVTS,NGF,NUMG,TDGFL)
      WLN1=WLTH(1)
      WLN2=WLTH(NLAM)
c      IF(WLN1.GT.WLAMIN/10..OR.WLN2.LT.WLAMAX/10.) THEN
      IF(WLN1.GT.(WLAMIN/10.-dwnm0).OR.WLN2.LT.(WLAMAX/10.-dwnm0)) THEN
      WRITE(6,*) 'WLTH(1)=',WLN1,'   WLTH(NLAM)=',WLN2
      WRITE(6,*) 'CHECK WLAMIN AND WLAMAX]'
      CALL EXIT
      END IF
Ciodine
cii
      if(ifii.eq.1) then
      WXN1=WSTD(1)
      WXN2=WSTD(NNL)
      DIFA=ABS(WXN1-WLAMIN/10.)
      DIFB=ABS(WXN2-WLAMAX/10.)
      DIFT=MIN(DIFA,DIFB)
        IF(DIFT.LT.DLNDOP) THEN
        WRITE(6,*) 'TOO SMALL MARGIN] WIDEN IT ] '
        WRITE(6,*) 'DIFT=',DIFT,'  DLNDOP=',DLNDOP
c       CALL EXIT
        END IF
c evaluate tdwnm
        IF(IFDWN.EQ.1) THEN
        TDWNM=TXV(NUM(4))
        ELSE
        TDWNM=DWNM0
        END IF
c evaluate tdxnm
        if(ifdxn.eq.1) then
        tdxnm=txv(num(5))
        else
        tdxnm=dxnm0
        end if
c
        idum=map1(wstd+tdxnm-tdwnm,fii,nnl,wlth,fiimap,nlam)
        do 812 k=1,nlam
  812   ftemp(k)=flam(k)*fiimap(k)
      else
        tdxnm=0.
        do k=1,nlam
        wtemp(k)=wlth(k)
        ftemp(k)=flam(k)
        end do
      end if
cii
Ciodine
C*
      NLAM1=NLAM-1
      DO 200 K=1,NLAM1
  200 DVA(K)=299792.5*(WLTH(K+1)-WLTH(K))/(0.5*(WLTH(K+1)+WLTH(K)))
      VA(1)=0.
      DO 210 K=1,NLAM1
  210 VA(K+1)=VA(K)+DVA(K)
      NA=NLAM
      DO 215 K=1,NA
  215 FA(K)=ftemp(K)
      NB=INT(VA(NLAM)/DV)
      IF(NB.GT.MF) THEN
      WRITE(6,*) 'NB=',NB,'   MF=',MF
      CALL EXIT
      END IF
      VB(1)=0.
      WLNB(1)=WLTH(1)
      DO 220 L=2,NB
      VB(L)=FLOAT(L-1)*DV
      WLNB(L)=WLNB(L-1)*(1.+DV/299792.5)
  220 CONTINUE
C*
      IDUM=MAP1(VA,FA,NA,VB,FB,NB)
      IF(IFVMA.EQ.1) THEN
      TVMAC=TXV(NUM(2))
      ELSE
      TVMAC=VMA0
      END IF
      IF(TVMAC.LT.VV(0)) THEN
      WRITE(6,*) 'TVMAC=',TVMAC,' <0]'
      CALL EXIT
      END IF
      IF(IFROT.EQ.1) THEN
      TVROT=TXV(NUM(3))
      ELSE
      TVROT=VROT0
      END IF
      IF(TVMAC.EQ.0.) GO TO 229
      RTM=TVROT/TVMAC
      IF(RTM.LT.RR(0).OR.RTM.GT.RR(NRR)) THEN
      WRITE(6,*) 'RTM=',RTM,' OUTSIDE RANGE]'
      CALL EXIT
      END IF
  229 CONTINUE
C     CHECK MARGIN
      DIF1=ABS(WLN1-WLAMIN/10.)
      DIF2=ABS(WLN2-WLAMAX/10.)
      DIFM=MIN(DIF1,DIF2)
      DLNDOP=WLN2*SQRT(TVTS**2+TVROT**2+TVMAC**2)/2.997925E5
      IF(DIFM.LT.DLNDOP) THEN
      WRITE(6,*) 'TOO SMALL MARGIN] WIDEN IT ] '
      WRITE(6,*) 'DIFM=',DIFM,'  DLNDOP=',DLNDOP
c      CALL EXIT
      END IF
C
      IF(TVMAC.EQ.0.) THEN
       IF(IFVMA.NE.0) THEN
       WRITE(6,*) 'WHY NOT IFVMA=0 IN THIS CASE OF TVMAC=0?'
       CALL EXIT
       END IF
c     for pure rotation  (because of tvmac = 0)
      WRITE(6,*) 'MODC IS SET TO 1 BECAUSE OF TVMAC=0'
      WRITE(6,*) 'NAMELY, PURE ROTATION WITH NO MACROTURBULENCE'
      MODC=1
      else
c     taking macroturbulence into account (because of tvmac <> 0)
       inquire(3,opened=loopen)
       if(loopen) then
c     radial-tangential macro (inclusion of rotation)
      WRITE(6,*) 'MODC IS SET TO 3 BECAUSE OF TVMAC<>0 & #3 OPENED'
      WRITE(6,*) 'NAMELY, R-T MACROTURBULENCE WITH ROTATION'
       modc=3
       else
c     pure Gaussian macroturbulence
      WRITE(6,*) 'MODC IS SET TO 2 BECAUSE OF TVMAC<>0 & #3 NOT-OPENED'
      WRITE(6,*) 'NAMELY, PURE G-MACROTURBULENCE WITH NO ROTATION'
       modc=2
        if(tvrot.ne.0.) then
        write(6,*) 'why not tvrot=0 in this case of  modc=2 ???'
        stop
        end if
       end if
      END IF
      IF(MODC.EQ.0) THEN
C     WRITE(6,*) 'MODC=0 ... NO CONVOLUTION'
C     GO TO 555
      WRITE(6,*) 'MODC=0 NOT ALLOWED IN THIS VERSION]'
      CALL EXIT
      END IF
      GO TO (101,102,103),MODC
  101 CONTINUE
      WRITE(6,6)
    6 FORMAT(1H ,5X,'MODC=1... PURE ROTATION')
      V1=TVROT
      V2=ELIMD
      VR=V1
      EPS=V2
      WRITE(6,359) EPS
  359 FORMAT(1H ,'EPS HAS BEEN SET TO ',F6.3,' (THE VALUE OF ELIMD)')
      WRITE(6,8) VR,EPS,DV
    8 FORMAT(1H ,5X,'VR=',F7.2,5X,'EPS=',F6.3,5X,'DV=',F6.3)
      NH=INT(VR/DV)
      IF(NH.GT.MH) THEN
      WRITE(6,*) 'NH=',NH,'  MH=',MH
      CALL EXIT
      END IF
      DO 10 I=0,+NH
      X=1.-(DV*FLOAT(I)/VR)**2
      G(I)=(2.*(1.-EPS)*SQRT(X)+PI/2.*EPS*X)/
     #(PI*(1.-EPS/3.))/VR
      G(-I)=G(I)
   10 CONTINUE
      GO TO 90
  102 CONTINUE
c     WRITE(6,*) 'MODEC=2 NOT ALLOWED IN THIS VERSION]'
c     CALL EXIT
      V1=TVMAC
      V2=V1*5.
      VH=V1
      VF=V2
      WRITE(6,7)
    7 FORMAT(1H ,5X,'MODC=2...PURE GAUSSIAN')
c     IF(VH.LT.0.) THEN
c     VH=ABS(VH)/(2.*SQRT(DLOG(2.)))
c     WRITE(6,*) 'INPUT !VH! WAS REGARDED AS FWHM AND HAS BEEN ',
c    &'CONVERTED TO THE REQUIRED VH-VALUE BY DIVIDING BY 2SQRT(LN2)'
c     END IF
      IF(VF.EQ.0.) THEN
      WRITE(6,*) 'VF IS SET TO VH*5'
      VF=VH*5.
      END IF
      WRITE(6,9) VH,VF,DV
    9 FORMAT(1H ,5X,'VH=',F7.2,5X,'VF=',F7.2,5X,'DV=',F6.3)
      NH=INT(VF/DV)
      IF(NH.GT.MH) THEN
      WRITE(6,*) 'NH=',NH,'  MH=',MH
      CALL EXIT
      END IF
      DO 51 I=0,+NH
      Y=DV*FLOAT(I)/VH
      G(I)=EXP(-Y**2)/(VH*SQRT(PI))
      G(-I)=G(I)
   51 CONTINUE
      GO TO 90
  103 CONTINUE
      V1=TVMAC
      V2=V1*5.
      VH=V1
      VF=V2
      WRITE(6,17) TVROT,TVMAC,RTM
   17 FORMAT(1H ,5X,'MODC=3...VROT+VMAC',3X,'TVROT=',F6.2,3X,
     \'TVMAC=',F6.2,3X,'RTM=',F6.4)
      WRITE(6,19) VH,VF,DV
   19 FORMAT(1H ,5X,'VH=',F7.2,5X,'VF=',F7.2,5X,'DV=',F6.3)
      NH=INT(VF/DV)
      IF(NH.GT.MH) THEN
      WRITE(6,*) 'NH=',NH,'  MH=',MH
      CALL EXIT
      END IF
      DO 80 M=0,NVV
      IDUM=MAP1(RR(0),FF(0,M),NRR+1,RTM,TFF(M),1)
   80 CONTINUE
      DO 81 I=0,NH
   81 TVV(I)=DV*FLOAT(I)/VH
      IDUM=MAP1(VV(0),TFF(0),NVV+1,TVV(0),G(0),NH+1)
      DO 82 I=1,NH
   82 G(-I)=G(I)
      DO 83 I=-NH,+NH
   83 G(I)=G(I)/VH
   90 CONTINUE
      W(-NH)=1./3.
      W(+NH)=1./3.
      DO 30 IP=1,2*NH-1
      JC=MOD(IP,2)
      IF(JC.EQ.1) W(IP-NH)=4./3.
      IF(JC.EQ.0) W(IP-NH)=2./3.
   30 CONTINUE
      SUM=0.
      DO 40 I=-NH,+NH
   40 SUM=SUM+W(I)*G(I)*DV
      WRITE(6,41) SUM
   41 FORMAT(1H ,5X,'SUMCHK=',F9.4)
  555 CONTINUE
      DO 250 L=1,NB
C     IF(L-NH.LT.1) THEN
C     FG(L)=FB(1)
C     GO TO 250
C     END IF
C     IF(L+NH.GT.NB) THEN
C     FG(L)=FB(NB)
C     GO TO 250
C     END IF
      SUM=0.
      DO 260 I=-NH,+NH
      LPI=L+I
      LPI=MAX0(1,LPI)
      LPI=MIN0(NB,LPI)
  260 SUM=SUM+W(I)*FB(LPI)*G(I)*DV
      FG(L)=SUM
  250 CONTINUE
C
      IF(VHEM.EQ.0.) THEN
      WRITE(6,*) 'INSTRUMENTAL BROADENING IS NEGLECTED (VHEM=0)'
      GO TO 1270
      END IF
C     INTEGRATION RANGE IS FROM -5*VHEM TO +5*VHEM
      NZ=INT(VHEM*5./DV)
      WRITE(6,*) '$$$ NZ=',NZ,' $$$'
      IF(NZ.GT.MH) THEN
      WRITE(6,*) 'NZ=',NZ,'  MH=',MH
      CALL EXIT
      END IF
c     for simple gaussian IP
      if(kip.eq.0) then
      DO 1280 I=1,NZ
      TZ=DV*FLOAT(I)
      G(I)=EXP(-(TZ/VHEM)**2)/(1.7724539*VHEM)
      G(-I)=G(I)
 1280 CONTINUE
      G(0)=1./(1.7724539*VHEM)
      go to 4988
      end if
c     for multiple gaussian IP
      ncoh=kip/2
      do j=-ncoh,+ncoh
      ap(j)=0.
      end do
      do j=-ncoh,-1
      ap(j)=tablg(j+ncoh+ifii+1)
      end do
      ap(0)=1.
      do j=1,ncoh
      ap(j)=tablg(j+ncoh+ifii)
      end do
      do 9270 i=-nz,+nz
 9270 g(i)=0.
      do 9280 i=-nz,+nz
      tz=dv*float(i)
      do 9281 k=-ncoh,+ncoh
      if(ap(k).eq.0.) go to 9281
      arg=(tz-float(k)*1.)**2
      g(i)=g(i)+ap(k)*dexp(-arg)
 9281 continue
 9280 continue
 4988 continue
      W(-NZ)=1./3.
      W(+NZ)=1./3.
      DO 1030 IP=1,2*NZ-1
      JC=MOD(IP,2)
      IF(JC.EQ.1) W(IP-NZ)=4./3.
      IF(JC.EQ.0) W(IP-NZ)=2./3.
 1030 CONTINUE
      SUMI=0.
      DO 1040 I=-NZ,+NZ
 1040 SUMI=SUMI+W(I)*G(I)*DV
      WRITE(6,1041) SUMI
 1041 FORMAT(1H ,5X,'SUMI(INSTRUMENTAL)=',F9.4)
      DO 1043 I=-NZ,+NZ
 1043 W(I)=W(I)/SUMI
      WRITE(6,*) 'WEIGHTS (FOR I.B.) HAVE BEEN DEVIDED BY SUMI'
      DO 1290 L=1,NB
 1290 FB(L)=FG(L)
      DO 1250 L=1,NB
C     IF(L-NZ.LT.1) THEN
C     FG(L)=FB(1)
C     GO TO 1250
C     END IF
C     IF(L+NZ.GT.NB) THEN
C     FG(L)=FB(NB)
C     GO TO 1250
C     END IF
      SUMF=0.
      DO 1260 I=-NZ,+NZ
      LPI=L+I
      LPI=MAX0(1,LPI)
      LPI=MIN0(NB,LPI)
 1260 SUMF=SUMF+W(I)*FB(LPI)*G(I)*DV
      FG(L)=SUMF
 1250 CONTINUE
      WRITE(6,*) 'MULTI-GAUSS INSTRUMENTAL PROFILE HAS BEEN CONVOLVED'
CI***
 1270 CONTINUE
      IF(IFDWN.EQ.1) THEN
      TDWNM=TXV(NUM(4))
      ELSE
      TDWNM=DWNM0
      END IF
      DO 255 L=1,NB
  255 VB(L)=WLNB(L)+TDWNM
      IDUM=MAP1(VB,FG,NB,XX,TYY,ND)
      DO 256 J=1,ND
  256 TYY(J)=DLOG10(TYY(J))
      IDUM=MAP1(WVCON,FCON,NCON,XX,TYCON,ND)
      DO 257 J=1,ND
  257 TYCON(J)=DLOG10(TYCON(J))
      RETURN
      END
      SUBROUTINE SYNTH(NAB,IZE,TABLG,TVTS,NGF,NUMG,TDGFL)
      IMPLICIT REAL*8 (A-H,O-Z)
      PARAMETER (MW=10001,MC=60,ML=2500)
      PARAMETER (ME=1+6,MG=20,MA=ME+MG,MP=5,MM=MA+MP,MD=9999)
      parameter (mx=99)
      parameter (mcoh=05)
      EXTERNAL MJDATA,MHDATA
      DIMENSION TABLG(MA),IZE(MA),XAB0(MA),XAB(MA),XFAC(MA),ITL(-99:99)
      DIMENSION NUMG(MG),TDGFL(MG)
      DIMENSION ICD(20),SABCO(mx,MW),TABCO(mx,MW)
      COMMON/TEMP/TSL(mx,MW),DUM0(mx),DUM1(mx),DUM2(mx),DUM3(mx)
      COMMON/FLUSS/NLAM,WLTH(MW),FLAM(MW),NCON,WVCON(MC),FCON(MC)
      REAL*8 SSTWV,EENWV,DELTA,WLTH,DELC,WVCON,WL,WLDP,DMW
      COMMON/DAMP/NDAMP,NND(ML),IND(ML)
      CHARACTER*4 CT
      CHARACTER*80 LABTMP
      DIMENSION SL(mx,ML),LINE0(mx,ML),DOPWAV(mx,ML),ADAMP(mx,ML)
      REAL*8 LINE0
      DIMENSION IJEL(ML),KLEL(ML),WL(ML),EXPOT(ML),GFLOG(ML)
      DIMENSION EHVK1(mx,MC),STI1(mx,MC),BN1(mx,MC)
      DIMENSION SCON1(mx,MC),ACON1(mx,MC),SIGMA1(mx,MC)
      DIMENSION T(mx),XABUND(99)
      common/pasmas/atmass(99)
      dimension ijm(ml),iza(8),amas(ma)
      character*2 elm
      COMMON /FREQ/FREQ,FREQLG,EHVKT(mx),STIM(mx),BNU(mx)
      COMMON /ABTOT/ABTOT(mx),ALPHA(mx)
      COMMON /MUS/ANGLE(20),SURFI(20),NMU
      COMMON /OPTOT/ACONT(mx),SCONT(mx),ALINE(mx),SLINE(mx),SIGMAC(mx),
     1              SIGMAL(mx)
      COMMON /RHOX/RHOX(mx),NRHOX
      COMMON /TAUSHJ/TAUNU(mx),SNU(mx),HNU(mx),JNU(mx),JMINS(mx)
      REAL*8 JNU,JMINS
      common/iodine/r0,ifii,nnl,wstd(mw),fii(mw),fcomb(mw)
      common/iparm/kip,ap(-mcoh:+mcoh)
      DATA ITEMP1/0/
      CHARACTER*4 LABSYN(20)
C     EXP10(X)=EXP(X*2.30258509299405E0)
      WRITE(6,108) (TABLG(I),I=1,NAB)
  108 FORMAT(1H ,3X,'TABLG:',10F8.4)
      WRITE(6,107) (TDGFL(I),I=1,NGF)
  107 FORMAT(1H ,3X,'TDGFL:',10F8.4)
ctakedatemp
c      IF(ITEMP1.GT.0) GO TO 200
ctakedatemp
      REWIND 30
      READ(30,865) LABTMP
c      READ(30) (LABSYN(I),I=1,20)
  865 FORMAT(A80)
      READ(30,6808) TEFF,GLOG,XSCALE,VTSBAC
c      READ(30) TEFF,GLOG,XSCALE,VTSBAC
 6808 FORMAT(F8.1,F7.3,F9.5,F6.2)
      READ(30,6840) (XABUND(IE),IE=1,99)
c      READ(30) (XABUND(IE),IE=1,99)
 6840 FORMAT(20F8.3)
C     CHANGES LOGARITHMIC XABUND INTO NORMAL SCALE
      DO 10 IE=1,99
   10 XABUND(IE)=EXP10(XABUND(IE))
      READ(30,871) (ATMASS(IE),IE=1,99)
c      READ(30) (ATMASS(IE),IE=1,99)
  871 FORMAT(10F12.3)
      READ(30,872) NRHOX
c      READ(30) NRHOX
  872 FORMAT(I4)
      READ(30,870) (RHOX(J),J=1,NRHOX)
c      READ(30) (RHOX(J),J=1,NRHOX)
  870 FORMAT(10E12.5)
      READ(30,873) (T(J),J=1,NRHOX)
c      READ(30) (T(J),J=1,NRHOX)
  873 FORMAT(10F12.1)
      READ(30,872) NELV
c      READ(30) NELV
      CALL NCHECK(NELV,NAB-ifii-kip,0)
      READ(30,860) (ICD(L),L=1,NELV)
c      READ(30) (ICD(L),L=1,NELV)
      DO 38 L=1,NELV
   38 CALL NCHECK(ICD(L),IZE(L+ifii+kip),L)
  860 FORMAT(30I4)
      READ(30,872) NLAM
      READ(30,872) NCON
      READ(30,6871) SSTWV,EENWV
 6871 format(2f12.4)
c      READ(30) NLAM
c      READ(30) NCON    
c      READ(30) SSTWV,EENWV
      DELTA=(EENWV-SSTWV)/FLOAT(NLAM-1)
      DO 20 K=1,NLAM
   20 WLTH(K)=SSTWV+DELTA*FLOAT(K-1)
      DELC=(EENWV-SSTWV)/FLOAT(NCON)
      DO 21 I=1,NCON
   21 WVCON(I)=SSTWV+0.5*DELC+DELC*FLOAT(I-1)
      NN=0
    1 READ(30,855) CT
  855 FORMAT(A4)
      IF(CT.NE.'####') GO TO 80
c    1 READ(30) NSEP
c      IF(NSEP.LT.0) GO TO 80
      NN=NN+1
      IF(NN.GT.ML) THEN
      WRITE(6,*) NN,'>ML ]'
      CALL EXIT
      END IF
      READ(30,6874) ijm(NN),KLEL(NN),WL(NN),EXPOT(NN),GFLOG(NN)
 6874 FORMAT(2I5,F12.4,F9.3,F8.3)                                        
      READ(30,6870) (SL(J,NN),J=1,NRHOX)
      READ(30,6870) (LINE0(J,NN),J=1,NRHOX)
      READ(30,6870) (DOPWAV(J,NN),J=1,NRHOX)
      READ(30,6870) (ADAMP(J,NN),J=1,NRHOX)
 6870 format(10e24.16)                              
c      READ(30) ijm(NN),KLEL(NN),WL(NN),EXPOT(NN),GFLOG(NN)
c      READ(30) (SL(J,NN),J=1,NRHOX)
c      READ(30) (LINE0(J,NN),J=1,NRHOX)
c      READ(30) (DOPWAV(J,NN),J=1,NRHOX)
c      READ(30) (ADAMP(J,NN),J=1,NRHOX)
      if(ijm(nn).gt.0) then
        ijel(nn)=ijm(nn)
      else
        ijel(nn)=int(codeinv(ijm(nn))+0.5)
      end if
c%%
      IF(IND(NN).GT.0) THEN
       code00=dfloat(ijel(nn)*100+klel(nn))/100.
       wla00=wl(nn)*10.
       REWIND 34
       do ii=1,ndamp
         READ(34,868,end=3409) CODE1,WLA1,EXPOT1,GFLOG1,codetemp
         if(code1.eq.0.) code1=codetemp
         READ(34,869) NRHOX1
         IF(NRHOX1.NE.NRHOX) THEN
         WRITE(6,*) 'CHECK DEPTH POINT ]'
         CALL EXIT
         END IF
         READ(34,890) (DUM0(J),J=1,NRHOX1)
         READ(34,890) (DUM1(J),J=1,NRHOX1)
cc         READ(34,890) (DUM2(J),J=1,NRHOX1)
cc         READ(34,890) (DUM3(J),J=1,NRHOX1)
  868    FORMAT(1X,F5.2,F9.3,2F7.3,2x,f8.2)
  869    FORMAT(I4)
  890    FORMAT(10E12.5)
         if(ind(nn).eq.ii) go to 3410
       end do
 3409    write(6,*) 'Not found at nn=',nn,' ind(nn)=',ind(nn)
         write(6,'(''line is :'',f8.2,f10.2)') code00,wla00
         stop
 3410  continue
       WRITE(6,876) NN
  876  FORMAT(1H ,3X,'DATA #',I3,' WILL BE REPLACED BY THE NEWLY READ.')
       WRITE(6,877) FLOAT(IJEL(NN)*100+KLEL(NN))/100.,WL(NN),
     \ EXPOT(NN),GFLOG(NN)
  877  FORMAT(1H ,'OLD:',3X,'CODE=',F8.2,3X,'WLN=',F8.3,3X,
     # 'EXPOT=',F6.3,3X,'GFLOG=',F7.3)
       WRITE(6,878) CODE1,WLA1/10.,EXPOT1,GFLOG1
  878  FORMAT(1H ,'NEW:',3X,'CODE=',F8.2,3X,'WLN=',F8.3,3X,
     # 'EXPOT=',F6.3,3X,'GFLOG=',F7.3)
       WRITE(6,*) 'INCLUDED NLTE RATIOS ARE AS FOLLOWS.'
       WRITE(6,1870) (DUM0(J),J=1,NRHOX)
 1870  FORMAT(1H ,' SL : ',1P10E12.5)
       WRITE(6,1871) (DUM1(J),J=1,NRHOX)
 1871  FORMAT(1H ,'LIN0: ',1P10E12.5)
cc       WRITE(6,1872) (DUM2(J)/DOPWAV(J,NN),J=1,NRHOX)
cc 1872  FORMAT(1H ,'DOPW: ',1P10E12.5)
cc       WRITE(6,1873) (DUM3(J)/ADAMP(J,NN),J=1,NRHOX)
cc 1873  FORMAT(1H ,'ADMP: ',1P10E12.5)
       DO 880 J=1,NRHOX
       SL(J,NN)=SL(J,NN)*DUM0(J)
       LINE0(J,NN)=LINE0(J,NN)*DUM1(J)
cc       DOPWAV(J,NN)=DUM2(J)
cc       ADAMP(J,NN)=DUM3(J)
  880  CONTINUE
       WRITE(6,*) '* * * DATA HAVE BEEN REPLACED * * *'
      END IF
c%%
      GO TO 1
   80 CONTINUE
      NL=NN
      READ(30,872) NCON
c      READ(30) NCON
      DO 100 II=1,NCON
      READ(30,872) JJDUM
      READ(30,6891) (EHVK1(J,II),STI1(J,II),BN1(J,II),SCON1(J,II),
     #ACON1(J,II),SIGMA1(J,II),J=1,NRHOX)
 6891 format(6e24.16)
c      READ(30) JJDUM
c      READ(30) (EHVK1(J,II),STI1(J,II),BN1(J,II),SCON1(J,II),
c     #ACON1(J,II),SIGMA1(J,II),J=1,NRHOX)
  100 CONTINUE
      READ(30,899)
  899 FORMAT(120X)
      DO 110 K=1,NLAM
      READ(30,899)
      READ(30,6870) (SABCO(J,K),J=1,NRHOX)
c      READ(30) KDUM,WLTHDM
c      READ(30) (SABCO(J,K),J=1,NRHOX)
  110 CONTINUE
      ITEMP1=ITEMP1+1
  200 CONTINUE
      DO 205 I=-99,99
  205 ITL(I)=0
      ABCOR=DLOG10((XABUND(1)+XABUND(2))/XABUND(1))
      DO 210 L=1+ifii,NAB
      if(ize(l).lt.0) then
        ijelt=int(codeinv(ize(l))+0.5)
        call calzam(ijelt,elm,tatmas,mola,iza)
        xabmul=1.
        do m=1,mola
          xabmul=xabmul*xabund(iza(m))
        end do
        xfac(l)=exp10(tablg(l))
        xab0(l)=xabmul*xfac(l)
        itl(ize(l))=l
        amas(l)=tatmas
        go to 210
      end if
      XAB0(L)=EXP10(TABLG(L)-12.00-ABCOR)
      XFAC(L)=XAB(L)/XABUND(IZE(L))
      ITL(IZE(L))=L
      amas(l)=atmass(ize(l))
  210 CONTINUE
      DO 220 K=1,NLAM
      DO 220 J=1,NRHOX
      TSL(J,K)=0.
  220 TABCO(J,K)=0.
      DO 310 NN=1,NL
      L=ITL(ijm(NN))
      if(l.le.0) then
        write(*,*) 'Check ITL !'
        call exit
      end if
C
      DO 1600 I=1,NGF
      IF(NUMG(I).EQ.NN) THEN
      FACMUL=EXP10(TDGFL(I))
      XAB(L)=XAB0(L)*FACMUL
      WRITE(6,1620) NN,FACMUL,TDGFL(I)
 1620 FORMAT(1H ,3X,'XABL FOR NO.',I2,' HAVE BEEN MULTIPLIED',
     %' BY THE FACTER ',1PE10.3,' CORRESPONDING TO THE DGFL VALUE OF ',
     %0PF6.3)
      GO TO 1601
      END IF
 1600 CONTINUE
      XAB(L)=XAB0(L)
 1601 CONTINUE
C
      WLDP=WL(NN)
      KCT=(WLDP-SSTWV)/DELC+1.00D0
      KCT=MAX0(1,KCT)
      KCT=MIN0(NCON,KCT)
      ETACRT=1.0E-5
      DO 320 J=1,NRHOX
      ETA0=XAB(L)*LINE0(J,NN)/ACON1(J,KCT)
      IF(ETA0.LT.ETACRT) GO TO 320
      DOPCOR=SQRT(1.0+60.1391*amas(l)*TVTS**2/T(J))
      ETA1=ETA0/DOPCOR
      DMW=1.0E-3*DOPWAV(J,NN)*SQRT(ETA0*ADAMP(J,NN)/ETACRT*.56419)
      MK1=(WLDP-SSTWV-DMW)/DELTA
      MK2=(WLDP-SSTWV+DMW)/DELTA
      KMN=MAX0(MK1,1)
      KMN=MIN0(KMN,NLAM)
      KMX=MIN0(MK2+1,NLAM)
      KMX=MAX0(KMX,1)
      DO 330 K=KMN,KMX
C     DO 330 K=1,NLAM
      V=ABS(WLTH(K)-WLDP)*1.E3/(DOPWAV(J,NN)*DOPCOR)
      XDUM=XAB(L)*(LINE0(J,NN)/DOPCOR)*VOIGT(V,ADAMP(J,NN))
      TABCO(J,K)=TABCO(J,K)+XDUM
      TSL(J,K)=TSL(J,K)+XDUM*SL(J,NN)
  330 CONTINUE
  320 CONTINUE
  310 CONTINUE
      DO 350 K=1,NLAM
      KC=(WLTH(K)-SSTWV)/DELC+1.000D0
      KC=MAX0(1,KC)
      KC=MIN0(NCON,KC)
      DO 360 J=1,NRHOX
      EHVKT(J)=EHVK1(J,KC)
      STIM(J)=STI1(J,KC)
      BNU(J)=BN1(J,KC)
      SCONT(J)=SCON1(J,KC)
      ACONT(J)=ACON1(J,KC)
      SIGMAC(J)=SIGMA1(J,KC)
C     SLINE(J)=BNU(J)
      ALINE(J)=SABCO(J,K)+TABCO(J,K)
      IF(ALINE(J).GT.0.) THEN
      SLINE(J)=(SABCO(J,K)*BNU(J)+TSL(J,K))/ALINE(J)
      ELSE
      SLINE(J)=BNU(J)
      END IF
  360 CONTINUE
      FREQ=2.997925E17/WLTH(K)
      FREQLG=DLOG(FREQ)
      IFSCAT=1
      IFSURF=1
      CALL JOSH(IFSCAT,IFSURF)
      FLAM(K)=4.*HNU(1)*2.997925E10/(WLTH(K)*1.E-7)**2*1.E-7
  350 CONTINUE
C     COMPUTE CONTINUUM FLUXES
      DO 400 II=1,NCON
      DO 410 J=1,NRHOX
      EHVKT(J)=EHVK1(J,II)
      STIM(J)=STI1(J,II)
      BNU(J)=BN1(J,II)
      SCONT(J)=SCON1(J,II)
      ACONT(J)=ACON1(J,II)
      SIGMAC(J)=SIGMA1(J,II)
      SLINE(J)=BNU(J)
      ALINE(J)=0.
  410 CONTINUE
      FREQ=2.997925E17/WVCON(II)
      FREQLG=DLOG(FREQ)
      IFSCAT=1
      IFSURF=1
      CALL JOSH(IFSCAT,IFSURF)
      FCON(II)=4.*HNU(1)*2.997925E10/(WVCON(II)*1.E-7)**2*1.E-7
  400 CONTINUE
c
      if(ifii.eq.1) then
      rewind 29
      nnl=0
      fmax=-1.d60
      do 290 k=1,999999
      read(29,*,end=2999) wlat,fdat
      wstd(k)=wlat/10.
      fii(k)=fdat
      if(fdat.gt.fmax) fmax=fdat
      nnl=nnl+1
  290 continue
 2999 continue
      do 291 k=1,nnl
  291 fii(k)=1.-fii(k)/fmax
      efac=exp10(tablg(1))
      do 1350 k=1,nnl
      if(fii(k).eq.0.) then
      fii(k)=1.
      go to 1350
      end if
      rinv=1./r0+(1./fii(k)-1./r0)*(1./efac)
      fii(k)=1.-1./rinv
      if(fii(k).lt.0.) fii(k)=0.
      if(fii(k).gt.1.) fii(k)=1.
 1350 continue
      end if
c
      RETURN
      END


      SUBROUTINE NCHECK(N1,N2,IRT)
      IMPLICIT REAL*8 (A-H,O-Z)
      IF(N1.NE.N2) THEN
      WRITE(6,*) 'NCHECK ERROR DETECTED AT IRT=',IRT
      WRITE(6,*) N1,'<>',N2,']'
      CALL EXIT
      END IF
      RETURN
      END
      subroutine showfit
      USE DFLIB
      implicit real*8 (a-h,o-z)
      parameter (MD=9999)
      common/nxy/nd,xx(md),yy(md),tyy(md),tycon(md),mask(md)
      common/betpas/iterat,ys,beta
      common/xymm/xmin,xmax,ymin,ymax
      common/spec/np,txs(md),tyo(md),tyt(md),msk(md)
      common/dwpass/tdwnm
      integer*2 status
      type (qwinfo) winfo
      np=nd
      xmin=+1.e30
      xmax=-1.e30
      ymin=+1.e30
      ymax=-1.e30
      do i=1,np
        msk(i)=mask(i)
c        txs(i)=xx(i)*10.
        txs(i)=(xx(i)-tdwnm)*10.
        tyo(i)=exp10(yy(i))
        tyt(i)=exp10(tyy(i)+ys+beta*(xx(i)-xx(1)))
        if(txs(i).lt.xmin) xmin=txs(i)
        if(txs(i).gt.xmax) xmax=txs(i)
        if(tyo(i).lt.ymin) ymin=tyo(i)
        if(tyt(i).lt.ymin) ymin=tyt(i)
        if(tyo(i).gt.ymax) ymax=tyo(i)
        if(tyt(i).gt.ymax) ymax=tyt(i)
      end do
c
c      setting the size of theframe window maximum
c      winfo.type=qwin$max
c      status=setwsizeqq(qwin$framewindow,winfo)
c
      status=focusqq(99)
      call clearscreen($gclearscreen)
      call graphicsmode()
      call wsizeset(99)
      call drawframe()
      return
      end
      SUBROUTINE graphicsmode()
      USE DFLIB
      LOGICAL             statusmode
      TYPE (windowconfig) myscreen
      common/myscr/myscreen
      integer*2 status
!
!     Set the screen to the best resolution and maximum number of 
!     available colors.
      myscreen.numxpixels   = 640
      myscreen.numypixels   = 480
      myscreen.numtextcols  = -1
      myscreen.numtextrows  = -1
      myscreen.numcolors    = -1
      myscreen.fontsize     = -1
      myscreen.title        = " "C
      statusmode = SETWINDOWCONFIG(myscreen)
      IF(.NOT. statusmode) statusmode = SETWINDOWCONFIG(myscreen)
      status = GETWINDOWCONFIG( myscreen )
      end

      SUBROUTINE wsizeset(iu)
      USE DFLIB
      integer*4 status
      logical*4 statusmode
      type (windowconfig) wc
      type (qwinfo) winfo
      status=setactiveqq(iu)
      statusmode=getwindowconfig(wc)
      winfo.type=qwin$set
      winfo.h=wc.numtextrows
      winfo.w=wc.numtextcols
      status=setwsizeqq(iu,winfo)
      return
      end

      SUBROUTINE drawframe()
      USE DFLIB
      implicit real*8 (a-h,o-z)
      parameter (MD=9999)
      common/spec/np,txs(md),tyo(md),tyt(md),msk(md)
      dimension sc(4)
      data sc/1.,2.,2.5,5./
      character*80 xlabel,ylabel
      integer*4 status
      type (fontinfo) font
      integer*2 index,numfonts
      integer*2 xwidth,yheight,cols,rows
      logical*4 statusmode
      character*16 grnum,fmt
      type (wxycoord) xy
      type(windowconfig) myscreen
      common/myscr/myscreen
      common/xymm/xmin,xmax,ymin,ymax
      common/betpas/iterat,ys,beta
      character*40 labite
      write(labite,'(9hIteration,i3)') iterat
      statusmode=getwindowconfig(myscreen)
      xwidth =myscreen.numxpixels
      yheight=myscreen.numypixels
      cols   =myscreen.numtextcols
      rows   =myscreen.numtextrows
      ngtx = 6
      ngty = 8
      xlmargin = 0.2
      xrmargin = 0.2
      ytmargin = 0.2
      ydmargin = 0.2
      tickpx=10.
      xlabel = 'Laboratory wavelength (A)'
      ylabel = 'Spectral intensity'
      xx = (xmax - xmin) / dfloat(ngtx)
      k = Int(dlog10(xx)) - 2
      do while (1)
        do m = 1, 4
        cmxcur = sc(m) * 10.**k
        If (xx.le.cmxcur) Then
        kx = k
        cmx = cmxcur
        xstart = (Int(xmin / cmx) + 1) * cmx
        mx=m
        goto 101
        end if
        end do
       k = k + 1
      end do
  101 continue
      yy = (ymax - ymin) / dfloat(ngty)
      k = Int(dlog10(yy)) - 2
      do while (1)
        do m = 1, 4
        cmycur = sc(m) * 10.**k
        If (yy.le.cmycur) then
        ky = k
        cmy = cmycur
        ystart = (Int(ymin / cmy) + 1) * cmy
        my=m
        goto 102
        end if
        end do
       k = k + 1
      end do
  102 continue
      wx1=xmin-(xmax-xmin)*xlmargin
      wy1=ymax+(ymax-ymin)*ytmargin
      wx2=xmax+(xmax-xmin)*xrmargin
      wy2=ymin-(ymax-ymin)*ydmargin
      dx = abs(wx2-wx1)/xwidth
      dy = abs(wy2-wy1)/yheight
      status=setwindow(.true.,wx1,wy1,wx2,wy2)
      oldcolor = SETCOLORRGB( #FFFFFF )  ! full white
c     drawing the frame
      status=RECTANGLE_W( $GBORDER, xmin,ymin,xmax,ymax)
c     setting font
      numfonts=initializefonts()
      index=setfont('t''Helv''h18w09')
      index=getfontinfo(font)
c     ticks in X-axis
c     select format
      call fmtset(kx,mx,fmt)
c
      do ri= xstart, xmax, cmx
      write(grnum,fmt) ri
      call lablen(grnum,16,ns,ne)
      xcur = ri - font.avgwidth*(ne-ns+1+0.1)*dx / 2.
      ycur = ymin - font.pixheight*0.2*dy
      call moveto_w(xcur,ycur,xy)
      call outgtext(grnum(ns:ne))
      call moveto_w(ri,ymin,xy)
      status=lineto_w(ri,ymin+tickpx*dy)
      call moveto_w(ri,ymax,xy)
      status=lineto_w(ri,ymax-tickpx*dy)
      end do
c
c     ticks in Y-axis
c     select format
      call fmtset(ky,my,fmt)
      xcmin=xmax
      do rj = ystart, ymax, cmy
      write(grnum,fmt) rj
      call lablen(grnum,16,ns,ne)
      xcur = xmin - font.avgwidth*(ne-ns+1.1)*dx
      if(xcur.lt.xcmin) xcmin=xcur
      ycur = rj + font.pixheight*dy/2.
      call moveto_w(xcur,ycur,xy)
      call outgtext(grnum(ns:ne))
      call moveto_w(xmin,rj,xy)
      status=lineto_w(xmin+tickpx*dx,rj)
      call moveto_w(xmax,rj,xy)
      status=lineto_w(xmax-tickpx*dx,rj)
      end do
c     writing title
      call lablen(labite,40,ns,ne)
      xcur = 0.5 * (xmin + xmax) - 0.5 * font.avgwidth*(ne-ns+1)*dx
c      xcur=xmin
      ycur = ymax + font.pixheight*dy*3.0
      call moveto_w(xcur,ycur,xy)
      call outgtext (labite(ns:ne))
c     writing x-label
      call lablen(xlabel,80,ns,ne)
      xcur = 0.5 * (xmin + xmax) - 0.5 * font.avgwidth*(ne-ns+1)*dx
      ycur = ymin - font.pixheight*dy*1.2
      call moveto_w(xcur,ycur,xy)
      call outgtext (xlabel(ns:ne))
c     writing y-label
      call lablen(ylabel,80,ns,ne)
      xcur = xcmin-font.pixheight*dx*1.1
      ycur= 0.5*(ymin+ymax)-0.5*font.avgwidth*(ne-ns+1.1)*dy
      call moveto_w(xcur,ycur,xy)
      call setgtextrotation(900)
      call outgtext (ylabel(ns:ne))
      call setgtextrotation(0)
c     now about to draw the theoretical spectrum 
      call range(txs,np,xmin,xmax,n1,n2)
      call moveto_w(txs(n1),tyt(n1),xy)
      do n=n1+1,n2
        if(msk(n-1).eq.1.and.msk(n).eq.1) then
          status=setcolorrgb(#FFFFFF)
        else
          status=setcolorrgb(#FF0000)
        end if
      status=lineto_w(txs(n),tyt(n))
      end do
c     now about to plot and draw the observed spectrum
      status=setcolorrgb(#00FFFF)
      call moveto_w(txs(n1),tyo(n1),xy)
      do n=n1+1,n2
        if(msk(n-1).eq.1.and.msk(n).eq.1) then
          status=setcolorrgb(#00FFFF)
        else
          status=setcolorrgb(#FF0000)
        end if
      status=lineto_w(txs(n),tyo(n))
      end do
      call polset(12,3,dx,dy)
      do n=n1,n2
        if(msk(n).eq.1) then
          status=setcolorrgb(#00FFFF)
        else
          status=setcolorrgb(#FF0000)
        end if
      call polplot(txs(n),tyo(n))
      end do
      status=setcolorrgb(#FFFFFF)
      return
      end

      subroutine lablen(label,nlen,ns,ne)
      character*(*) label
      do n=nlen,1,-1
      if(label(n:n).ne.' ') exit
      end do
      ne=n
      do n=1,nlen
      if(label(n:n).ne.' ') exit
      end do
      ns=n
      return
      end
      subroutine fmtset(k,m,fmt)
      character*16 fmt
      i=-k
      if (m.eq.3) i=i+1
      i=max0(0,i)
      if (i.le.0) then
      fmt='(f10.0)'
      else if (i.eq.1) then
      fmt='(f10.1)'
      else if (i.eq.2) then
      fmt='(f10.2)'
      else if (i.eq.3) then
      fmt='(f10.3)'
      else if (i.eq.4) then
      fmt='(f10.4)'
      else if (i.eq.5) then
      fmt='(f10.5)'
      end if
      return
      end
      subroutine range(x,n,xmin,xmax,n1,n2)
      implicit real*8 (a-h,o-z)
      dimension x(n)
      do m=1,n
      if(x(m).ge.xmin) go to 10
      end do
   10 n1=m
      do m=n,1,-1
      if(x(m).le.xmax) go to 20
      end do
   20 n2=m
      if(n1.ge.n2) then
      write(6,*) 'check the range!'
      stop
      end if
      return
      end
      subroutine polset(npoly,khwpix,dx,dy)
      implicit real*8 (a-h,o-z)
      common/polpas/npl,xpl(50),ypl(50)
      data pi/3.141592653589793/
      if(npoly.gt.50) then
        write(*,*) npoly, ' is too large for npl!'
        call exit(1)
      end if
      npl=npoly
      do i=1,npl
        theta=2.*pi*(i-1)/dfloat(npl)
        xpl(i)=sin(theta)*dx*khwpix
        ypl(i)=cos(theta)*dy*khwpix
      end do
      return
      end
      subroutine polplot(x,y)
      USE DFLIB
      implicit real*8 (a-h,o-z)
      type (wxycoord) xy
      integer*4 status
      common/polpas/npl,xpl(50),ypl(50)
      call moveto_w(x+xpl(1),y+ypl(1),xy)
      do i=2,npl
        status=lineto_w(x+xpl(i),y+ypl(i))
      end do
      status=lineto_w(x+xpl(1),y+ypl(1))
      return
      end

      FUNCTION VOIGT(V,A)
      IMPLICIT REAL*8 (A-H,O-Z)
C     FUNCTION H(A,V)
C     FROM ERIC PEYTREMANN
      LOGICAL Q
      VV=V*V
      Q=A.LT.0.2
      IF(Q.AND.V.GT.5.)GOTO 1
      IF(.NOT.Q.AND.(A.GT.1.4.OR.A+V.GT.3.2))GOTO 2
      HO=EXP(-VV)
      H2=(1.-2.*VV)*HO
      IF(V.GT.2.4)GOTO 3
      IF(V.GT.1.3)GOTO 4
      H1=(.42139*VV-2.34358*V+3.28868)*VV-.15517*V-1.1247
    5 IF(Q)GOTO 6
      HH1=H1+HO*1.12838
      HH2=H2+HH1*1.12838-HO
      HH3=(1.-H2)*.37613-HH1*.66667*VV+HH2*1.12838
      HH4=(3.*HH3-HH1)*.37613+HO*.66667*VV*VV
C     H=((((HH4*A+HH3)*A+HH2)*A+HH1)*A+HO)*(((-.122727278*A+.532770573)*
      VOIGT=
     A  ((((HH4*A+HH3)*A+HH2)*A+HH1)*A+HO)*(((-.122727278*A+.532770573)*
     1A-.96284325)*A+.979895032)
      RETURN
    1 VOIGT=((2.12/VV+.8463)/VV+.5642)*A/VV
C   1 H=((2.12/VV+.8463)/VV+.5642)*A/VV
      RETURN
    2 AA=A*A
      U=(AA+VV)*1.4142
      UU=U*U
C     H=((((AA-10.*VV)*AA*3.+15.*VV*VV)/UU+3.*VV-AA)/UU+1.)*A*.79788/U
      VOIGT=
     A  ((((AA-10.*VV)*AA*3.+15.*VV*VV)/UU+3.*VV-AA)/UU+1.)*A*.79788/U
      RETURN
    3 H1=((-.0032783*VV+.0429913*V-.188326)*VV+.278712*V+.55415)/(VV-1.5
     1)
      GOTO 5
    4 H1=(-.220416*VV+1.989196*V-6.61487)*VV+9.39456*V-4.4848
      GOTO 5
    6 VOIGT=(H2*A+H1)*A+HO
C   6 H=(H2*A+H1)*A+HO
      RETURN
      END
      SUBROUTINE MATINV(A,N,NR)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(NR,NR)
C     ******************************************************************
C     INVERSION OF THE MATRIX A IN PLACE.
C     LU DECOMPOSITION , STARTING WITH L
C     ******************************************************************
      IF(N.EQ.1) GO TO 25
      DO 5 I = 2, N
         IM1 = I - 1
         DO 2 J = 1, IM1
            JM1 = J - 1
            DIV=A(J,J)
            SUM = 0.0E0
            IF(JM1 .LT. 1 ) GO TO 2
            DO 1 L = 1, JM1
    1       SUM = SUM + A(I,L)*A(L,J)
    2       A(I,J)=(A(I,J)-SUM)/DIV
         DO 4 J = I,N
            SUM = 0.0E0
            DO 3 L = 1, IM1
    3       SUM = SUM + A(I,L)*A(L,J)
            A(I,J) = A(I,J) - SUM
    4    CONTINUE
    5 CONTINUE
C     ******************************************************************
C     INVERSION OF L
C     ******************************************************************
      DO 13 II = 2, N
         I = N + 2 - II
         IM1 = I - 1
         IF(IM1.LT.1) GO TO 13
         DO 12 JJ = 1, IM1
            J = I - JJ
            JP1 = J + 1
            SUM = 0.0E0
            IF(JP1.GT.IM1) GO TO 12
            DO 11 K = JP1, IM1
   11       SUM = SUM + A(I,K)*A(K,J)
   12       A(I,J) = - A(I,J) - SUM
   13 CONTINUE
C     ******************************************************************
C     U INVERSION
C     ******************************************************************
      DO 17 II = 1, N
         I = N + 1 - II
         DIV=A(I,I)
         IP1 = I + 1
         IF(IP1.GT.N) GO TO 17
         DO 16 JJ = IP1, N
            J = N + IP1 - JJ
            SUM = 0.0E0
            DO 15 K = IP1, J
   15       SUM = SUM + A(I,K)*A(K,J)
            A(I,J)=-SUM/DIV
   16    CONTINUE
   17 A(I,I) = 1.0E0/A(I,I)
C     ******************************************************************
C     MULTIPLICATION OF U INVERSE AND L INVERSE
C     ******************************************************************
      DO 24 I = 1, N
         DO 23 J = 1, N
           K0= MAX0(I,J)
            IF(K0.EQ.J) GO TO 22
            SUM = 0.0E0
   20       DO 21 K = K0, N
   21       SUM = SUM + A(I,K)*A(K,J)
            GO TO 23
   22       SUM = A(I,K0)
            IF(K0.EQ.N) GO TO 23
            K0 = K0 + 1
            GO TO 20
   23    A(I,J) = SUM
   24 CONTINUE
      RETURN
   25 A(1,1)= 1.0E0/A(1,1)
      RETURN
      END

      subroutine checkfit(fnobspec,ifbl,norder)
      implicit real*8 (a-h,o-z)
      character*60 fnobspec
      common/wrange/wmne,wmxe,jbl,jbr,lolimit
      logical lolimit
c     norder is returned
c     norder=-999  this is not a fits-formatted file (treated as text file)
c     norder=0     single-spectrum fits-formatted file
c     norder>0     multi-spectra fits-formatted file --> 'norder' selected
c     ifbl is returned
c     |ifbl| indicates the column number of '[' character
c     ifbl>0 ---> [order,wavelength-points]
c     ifbl<0 ---> [wavelength-points,order]
c

c      ifpfit =scan(fnobspec,'.fit')
      call lablen(fnobspec,60,ns,ne)
      do i=ns,ne-3
      if(fnobspec(i:i+3).eq.'.fit') go to 76
      end do
      ifpfit=0
      go to 77
   76 ifpfit=i
   77 continue

      ifbl=scan(fnobspec,'[')
      ifbr=scan(fnobspec,']')
      ifcomma=scan(fnobspec,',')
      ifstar=scan(fnobspec,'*')
c#
      wmne=0.
      wmxe=1.e30
      lolimit=.false.
      if(ifbl*ifbr.ne.0.and.ifstar.eq.0) then
      lolimit=.true.
      jbl=ifbl
      jbr=ifbr
      read(fnobspec(jbl+1:jbr-1),*) wmne,wmxe
      end if
c#
c
      if(ifpfit.eq.0) then
      norder=-999
      ifbl=0
      return
      end if

      if(ifbl*ifbr*ifcomma*ifstar.eq.0) then
      norder=0
      return
      end if
c
      if(ifcomma.lt.ifstar) then
      read(fnobspec(ifbl+1:ifcomma-1),*) norder
      ifbl=+iabs(ifbl)
      else
      read(fnobspec(ifcomma+1:ifbr-1),*) norder
      ifbl=-iabs(ifbl)
      end if
      return
      end

C      subroutine fitsread(nn,fnamet,ifbl,norder,nptsel,wlasel,specsel)
C      implicit real*8 (a-h,o-z)
C      parameter (md=9999)
Cc#
C      common/wrange/wmne,wmxe,jbl,jbr,lolimit
C      logical lolimit
C      dimension wlasel(md),specsel(md)
C      real*8,dimension(:),allocatable :: wla,spec
C      real*4,dimension(:),allocatable :: buffer
C      character*60 fnamet,fname
Cc#
C      integer status,unit,readwrite,blocksize,naxes(2),nfound
C      integer group,firstpix,nbuffer,npixels,i
C      integer npoint,npt,norder
C      real*4 nullval
C      logical anynull,loexist
C      character filename*80
C      character comment*80,ctype1*8
C      real*4 crval1,cdelt1
C      character word8*8,fmt*80,waxmap*80,segment(999)*80,string*255
C      dimension ns(999),ne(999)
C      if(ifbl.eq.0) then
C      fname=fnamet
C      else
C      fname=fnamet(1:iabs(ifbl)-1)
C      end if
C      inquire(file=fname,exist=loexist)
C      if(.not.loexist) then
C      write(*,*) 'specified spectrum file does not exist!'
C      stop
C      end if
Cc      write(*,'(a)') fname
C      naxes(1)=0
C      naxes(2)=0
Cc 1    status=0
Cc
CcC     Get an unused Logical Unit Number to use to open the FITS file
Cc 2    call ftgiou(unit,status)
Cc
CC     open the FITS file
C      unit=nn
C      readwrite=0
C 3    call ftopen(unit,fname,readwrite,blocksize,status)
C
CC     determine the size of the image
C      if(norder.eq.0) ndim=1
C      if(norder.gt.0) ndim=2
C 4    call ftgknj(unit,'NAXIS',1,ndim,naxes,nfound,status)
Cc      write(*,*) 'naxes(1)=',naxes(1)
Cc      write(*,*) 'naxes(2)=',naxes(2)
Cc      write(*,*) 'nfound  =',nfound
C
CC     check that it found NAXIS1 keyword
C 5    if (norder.eq.0.and.nfound .ne. 1)then
C          print *,'failed! Why not one dimension for norder=0?'
C          stop
C       end if
C      if (norder.gt.0.and.nfound .ne. 2)then
C          print *,'failed! Why not two dimension for norder>0?'
C          stop
C       end if
C      call ftgkys(unit,'CTYPE1  ',ctype1,comment,status)
C
Cccc   LINEAR
Cc>>
Cc>>      if(ctype1.ne.'LINEAR  '.and.ctype1.ne.'LAMBDA  '
Cc>>     & .and.ctype1.ne.'WAVELENG'.and.ctype1.ne.'        ') go to 1001
C      if(ctype1.eq.'MULTISPE') go to 1001
Cc>>
Cc      write(*,'(''CTYPE1:'',a8)') ctype1
Cc      write(*,*) 'ctype1 match! OK!'
C      call ftgkye(unit,'CRVAL1  ',crval1,comment,status)
Cc      write(*,'(''CRVAL1:'',f8.2)') crval1
C      call ftgkye(unit,'CDELT1  ',cdelt1,comment,status)
Cc      write(*,'(''CDELT1:'',f8.5)') cdelt1
C      w0=crval1
C      dw=cdelt1
C      npoint=naxes(1)
C      allocate(wla(npoint))
C      allocate(spec(npoint))
C      do k=1,npoint
C      wla(k)=w0+(k-1)*dw
C      end do
C      npt=npoint
C      go to 1003
C 1001 continue
C   
Cccc   MULTISPE
C      if (ctype1.ne.'MULTISPE') go to 1002
C      if(norder.eq.0) then
C        call ftgkys(unit,'WAXMAP01',waxmap,comment,status)
C        read(waxmap,*) idum,idum,idum,iposm
C        ipos=iposm+1
C      else
C        ipos=norder
C      end if
C      do i=1,999
C        if(i.le.9) then
C        fmt='(''WAT2_00'',i1)'
C        else if (i.le.99) then
C        fmt='(''WAT2_0'',i2)'
C        else if (i.le.999) then
C        fmt='(''WAT2_'',i3)'
C        end if
C        write(word8,fmt) i
C        call ftgkys(unit,word8,segment(i),comment,status)
C        if(status.ne.0) exit
C        call lablen(segment(i),80,ns(i),ne(i))
C        if(segment(i)(1:1).eq.' ') ns(i)=ns(i)-1
C        if(segment(i)(68:68).eq.' ') ne(i)=ne(i)+1
C      end do
C      numstr=i-1
C      ic=0
C      do i=1,numstr
C        do 43 n=ns(i),ne(i)
C        if(segment(i)(n:n).ne.'"') go to 43
C        ic=ic+1
C        if(ic.eq.2*ipos-1) then
C          ii1=i
C          n1=n
C        end if
C        if(ic.eq.2*ipos) then
C          ii2=i
C          n2=n
C        go to 44
C        end if
C   43   continue
C      end do
C   44 continue
C      iii=ii2-ii1+1
C      if(iii.eq.1) then
C      string=segment(ii1)(n1:n2)
C      else if (iii.eq.2) then
C      string=segment(ii1)(n1:ne(ii1))//segment(ii2)(ns(ii2):n2)
C      else if (iii.eq.3) then
C      iim=ii1+1
C      string=segment(ii1)(n1:ne(ii1))//
C     & segment(iim)(ns(iim):ne(iim))//
C     & segment(ii2)(ns(ii2):n2)
C      end if
C      call lablen(string,255,nt1,nt2)
C      read(string(nt1+1:nt2-1),*) iord,iduma,idumb,crval1,cdelt1,
C     & npdum,voc,apb1,apb2
C        if(iord.ne.ipos) then
C        write(*,*) 'iord=',iord,'  ipos=',ipos
Cc        stop
C        end if
Cc      write(*,'(''CRVAL1:'',f8.2)') crval1
Cc      write(*,'(''CDELT1:'',f8.5)') cdelt1
C      w0=crval1
C      dw=cdelt1
C      if(ifbl.gt.0) then
C      write(*,*) 'ifbl should be <0'
C      write(*,*) 'transpose row/column as [wavelength-points,order]'
C      stop
C      end if
C      npoint=naxes(1)
Cc      write(*,*) 'npoint=',npoint
C      allocate(wla(npoint))
C      allocate(spec(npoint))
C      do k=1,npoint
C      wla(k)=w0+(k-1)*dw
C      wla(k)=wla(k)*(1.-voc)
C      end do
C      npt=npoint
C      go to 1003
C 1002 continue
Cccc   OTHERS
C      write(*,'(''CTYPE1:'',a8)') ctype1
C      write(*,*) 'ctype1 unmatch! I cannot read this fits file!'
C      stop
C 1003 continue
C
CC     initialize variables
C      if(norder.lt.0) npixels=naxes(1)
C      if(norder.eq.0) npixels=naxes(1)
C      if(norder.gt.0) npixels=naxes(1)*naxes(2)
C      allocate(buffer(npixels))
C
C      group=1
C      firstpix=1
C      nullval=-999
C      ncount=0
C
Cc      write(*,*) 'npixels=',npixels
C      do while (npixels .gt. 0)
CC         read all pixels at a time 
C           nbuffer=npixels     
Cc 6        call ftgpve(unit,group,firstpix,nbuffer,nullval,
Cc     &            buffer,anynull,status)
C  6        call ftgpfe(unit,group,firstpix,nbuffer,
C     &            buffer,flagvals,anynull,status)
C
CC         increment pointers and loop back to read the next group of pixels
C          npixels=npixels-nbuffer
C          firstpix=firstpix+nbuffer
C      end do
C      if(norder.le.0) then
Cc     for one-D spec
C        do k=1,npt
C          spec(k)=buffer(k)
C        end do
C      else
Cc     for two-D spec
C        nskip=(norder-1)*npt
C        do k=1,npt
C          spec(k)=buffer(nskip+k)
C        end do
C      end if
CC     select out spectrum data
Cc    
C      nct=0
C      do k=1,npt
C      if(wla(k).lt.wmne) cycle
C      if(wla(k).gt.wmxe) exit
C      nct=nct+1
C          if(nct.gt.md) then
C                write(*,*) 'too large obspec points! --> cut at md=',md
C                nct=md
C                go to 79
C          end if
C      wlasel(nct)=wla(k)
C      specsel(nct)=spec(k)
C      end do
C   79 continue
C      nptsel=nct
Cc
CC     close the file and free the unit number
C 7    call ftclos(unit, status)
C      call ftfiou(unit, status)
Cc     Now deallocating wla,spec,buffer
C      deallocate(wla)
C      deallocate(spec)
C      deallocate(buffer)
C      return
C      end

      subroutine sread(nn,fnamet,nptsel,wlasel,specsel)
      implicit real*8 (a-h,o-z)
      parameter (md=9999)
      common/wrange/wmne,wmxe,jbl,jbr,lolimit
      logical lolimit
      dimension wlasel(md),specsel(md)
      character*80 line
      character*60 fname,fnamet
      character*1 ch
      logical lofmt,loexist
      character*60 fmt
      real*8,dimension(:),allocatable :: wla,spec
      fname=fnamet
      if(lolimit) fname=fnamet(1:jbl-1)
      inquire(file=fname,exist=loexist)
      if(.not.loexist) then
      write(*,*) 'specified spectrum file does not exist!'
      stop
      end if
      open (unit=nn,file=fname)
c     line counting
      nline=0
      do j=1,9999999
      read(nn,'(a)',end=1999) line
      nline=nline+1
      end do
 1999 continue
      allocate(wla(nline))
      allocate(spec(nline))

c     check if fmt exists at thre first line
      rewind nn
      read(nn,'(a)') line
      call lablen(line,80,ns,ne)
      lofmt=.false.
      if(line(ns:ns+4).eq.'%fmt=') then
      lofmt=.true.
      read(line(ns+5:ne),*) fmt
      end if
c
      rewind nn
      n=0
      do i=1,99999
        read(nn,'(a)',end=33) line
        do k=1,80
        if(line(k:k).ne.' ') go to 48
        end do
        go to 49
   48   ks=k
        ch=line(ks:ks)
        if(ifnum(ch).eq.1) then
          n=n+1
          if(lofmt) then
            read(line,fmt) wla(n),spec(n)
          else
            read(line,*) wla(n),spec(n)
          end if
        end if
   49 continue
      end do
   33 continue
      close (nn)
      if(n.eq.0) then
        write(6,*) 'Check the spectrum file!'
        stop
      end if
      npt=n
      nct=0
      do j=1,npt
      if(wla(j).lt.wmne) cycle
      if(wla(j).gt.wmxe) exit
      nct=nct+1
        if(nct.gt.md) then
          write(*,*) 'too large obspec points! --> cut at md=',md
          nct=md
          go to 79
        end if
      wlasel(nct)=wla(j)
      specsel(nct)=spec(j)
      end do
   79 continue
      nptsel=nct
c     Now deallocating wla & spec
      deallocate(wla)
      deallocate(spec)
      return
      end


      function ifnum(ch)
      character*1 ch,num(10)
      data num/'1','2','3','4','5','6','7','8','9','0'/
      do 100 i=1,10
      if(ch.eq.num(i)) go to 99
  100 continue
      ifnum=0
      return
   99 ifnum=1
      return
      end

      function codeinv(ijm)
      implicit real*8 (a-h,o-z)
      dimension cm(68)
      data cm/
     a 100.00,101.00,101.01,106.00,106.01,107.00,108.00,108.01,
     b 109.00,112.00,113.00,114.00,114.01,116.00,117.00,600.00,
     c 606.00,607.00,607.01,608.00,613.00,614.00,616.00,707.00,
     d 707.01,708.00,708.01,712.00,713.00,714.00,716.00,800.00,
     e 808.00,808.01,812.00,813.00,814.00,816.00,820.00,822.00,
     f 826.00,900.00,1216.00,1300.00,1316.00,1416.00,1600.00,1616.00,
     g 1620.00,1626.00,1700.00,2600.00,10100.00,10106.00,10107.00,
     h 10108.00,10116.00,10606.00,10607.00,10608.00,10708.00,
     i 10800.00,10808.00,60600.00,60700.00,60808.00,70700.00,
     j 80800.00/
      if(ijm.ge.0.or.ijm.lt.-68) then
        write(*,*) 'ijm=',ijm,' --> invalid!'
        call exit
      end if
      codeinv=cm(iabs(ijm))
      return
      end function

      subroutine calzam(ijel,elm,tatmas,mola,iza)
      IMPLICIT REAL*8 (A-H,O-Z)
      common/pasmas/atmass(99)
      character*2 elem(99)
      DATA ELEM/   'H ', 'He',
     1 'Li', 'Be', 'B ', 'C ', 'N ', 'O ', 'F ', 'Ne', 'Na', 'Mg',
     2 'Al', 'Si', 'P ', 'S ', 'Cl', 'Ar', 'K ', 'Ca', 'Sc', 'Ti',
     3 'V ', 'Cr', 'Mn', 'Fe', 'Co', 'Ni', 'Cu', 'Zn', 'Ga', 'Ge',
     4 'As', 'Se', 'Br', 'Kr', 'Rb', 'Sr', 'Y ', 'Zr', 'Nb', 'Mo',
     5 'Tc', 'Ru', 'Rh', 'Pd', 'Ag', 'Cd', 'In', 'Sn', 'Sb', 'Te',
     6 'I ', 'Xe', 'Cs', 'Ba', 'La', 'Ce', 'Pr', 'Nd', 'Pm', 'Sm',
     7 'Eu', 'Gd', 'Tb', 'Dy', 'Ho', 'Er', 'Tm', 'Yb', 'Lu', 'Hf',
     8 'Ta', 'W ', 'Re', 'Os', 'Ir', 'Pt', 'Au', 'Hg', 'Tl', 'Pb',
     9 'Bi', 'Po', 'At', 'Rn', 'Fr', 'Ra', 'Ac', 'Th', 'Pa', 'U ',
     T 'Np', 'Pu', 'Am', 'Cm', 'Bk', 'Cf', 'Es'/
      dimension xcode(8),iza(8)
      DATA XCODE/1.E14,1.E12,1.E10,1.E8,1.E6,1.E4,1.E2,1.E0/
      character*2 elm
      character*1 eq(2)
      c=dfloat(ijel)
      do 11 ii=1,8
      if(c.ge.xcode(ii)) go to 12
   11 continue
      call exit
   12 continue
      ia=0
      am=0.
      do 13 i=ii,8
      id=c/xcode(i)
      am=am+atmass(id)
      ia=ia+1
      iza(ia)=id
      c=c-dfloat(id)*xcode(i)
   13 continue
      mola=ia
      tatmas=am
      if(mola.eq.1) elm=elem(iza(1))
      if(mola.eq.2) then
        do j=1,2
          if(iza(j).gt.0) then
            eq(j)=elem(iza(j))
          else
            eq(j)='-'
          end if
        end do
        elm=eq(1)//eq(2)
      end if
      if(mola.eq.3) elm='tt'
      if(mola.eq.4) elm='xx'
      return
      end
      SUBROUTINE ROSS(MODE,RCOWT)
      IMPLICIT REAL*8 (A-H,O-Z)
      parameter (mx=99)
      COMMON /ABROSS/ABROSS(mx),TAUROS(mx)
      COMMON /ABTOT/ABTOT(mx),ALPHA(mx)
      COMMON /FREQ/FREQ,FREQLG,EHVKT(mx),STIM(mx),BNU(mx)
      COMMON /RHOX/RHOX(mx),NRHOX
      COMMON /TEMP/T(mx),TKEV(mx),TK(mx),HKT(mx),TLOG(mx),ITEMP
      GO TO(10,20,30),MODE
   10 DO 11 J=1,NRHOX
   11 ABROSS(J)=0.
      RETURN
   20 DO 21 J=1,NRHOX
      DBDT=BNU(J)*FREQ*HKT(J)/T(J)/STIM(J)
   21 ABROSS(J)=ABROSS(J)+DBDT/ABTOT(J)*RCOWT
      RETURN
   30 DO 31 J=1,NRHOX
   31 ABROSS(J)=(4.*5.6697E-5/3.14159)*T(J)**3/ABROSS(J)
C     RHOX0=RHOX(1)
C     RHOX(1)=0.
C     CALL INTEG(RHOX,ABROSS,TAUROS,NRHOX)
C     RHOX(1)=RHOX0
C     TO FIX PROBLEM WITH TEMPERATURE DROP AT FIRST POINT
      ABROSS(1)=ABROSS(2)
      CALL INTEG(RHOX,ABROSS,TAUROS,NRHOX,ABROSS(1)*RHOX(1))
      TAUROS(1)=0.
      RETURN
      END
      SUBROUTINE DERIV(X,F,DFDX,N)
      IMPLICIT REAL*8 (A-H,O-Z)
C     ASSUMES THAT ANY ZERO IN X OCCURS AT A ENDPOINT
      DIMENSION X(N),F(N),DFDX(N)
      DFDX(1)=(F(2)-F(1))/(X(2)-X(1))
      N1=N-1
      DFDX(N)=(F(N)-F(N1))/(X(N)-X(N1))
      IF(N.EQ.2)RETURN
      S=ABS(X(2)-X(1))/(X(2)-X(1))
      DO 1 J=2,N1
      SCALE=MAX(ABS(F(J-1)),ABS(F(J)),ABS(F(J+1)))/ABS(X(J))
      IF(SCALE.EQ.0.)SCALE=1.
      D1=(F(J+1)-F(J))/(X(J+1)-X(J))/SCALE
      D=(F(J)-F(J-1))/(X(J)-X(J-1))/SCALE
      TAN1=D1/(S*SQRT(1.+D1**2)+1.)
      TAN=D/(S*SQRT(1.+D**2)+1.)
    1 DFDX(J)=(TAN1+TAN)/(1.-TAN1*TAN)*SCALE
      RETURN
      END
      SUBROUTINE INTEG(X,F,FINT,N,START)
C     SUBROUTINE INTEG(X,F,FINT,N)
      IMPLICIT REAL*8 (A-H,O-Z)
      parameter (mx=99)
      DIMENSION X(N),F(N),FINT(N)
      DIMENSION A(mx),B(mx),C(mx)
      CALL PARCOE(F,X,A,B,C,N)
      FINT(1)=START
C     FINT(1)=(A(1)+(B(1)/2.+C(1)/3.*X(1))*X(1))*X(1)
C     FINT(2)=(A(1)+(B(1)/2.+C(1)/3.*X(2))*X(2))*X(2)
C     IF(N.EQ.2)RETURN
      N1=N-1
C     DO 10 I=2,N1
      DO 10 I=1,N1
   10 FINT(I+1)=FINT(I)+(A(I)+B(I)/2.*(X(I+1)+X(I))+
     1C(I)/3.*((X(I+1)+X(I))*X(I+1)+X(I)*X(I)))*(X(I+1)-X(I))
      RETURN
      END
      SUBROUTINE PARCOE(F,X,A,B,C,N)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION F(N),X(N),A(N),B(N),C(N)
      C(1)=0.
      B(1)=(F(2)-F(1))/(X(2)-X(1))
      A(1)=F(1)-X(1)*B(1)
      N1=N-1
      C(N)=0.
      B(N)=(F(N)-F(N1))/(X(N)-X(N1))
      A(N)=F(N)-X(N)*B(N)
      IF(N.EQ.2)RETURN
      DO 1 J=2,N1
      J1=J-1
      D=(F(J)-F(J1))/(X(J)-X(J1))
      C(J)=F(J+1)/((X(J+1)-X(J))*(X(J+1)-X(J1)))-F(J)/((X(J)-X(J1))*
     1(X(J+1)-X(J)))+F(J1)/((X(J)-X(J1))*(X(J+1)-X(J1)))
      B(J)=D-(X(J)+X(J1))*C(J)
    1 A(J)=F(J1)-X(J1)*D+X(J)*X(J1)*C(J)
      C(2)=0.
      B(2)=(F(3)-F(2))/(X(3)-X(2))
      A(2)=F(2)-X(2)*B(2)
      C(3)=0.
      B(3)=(F(4)-F(3))/(X(4)-X(3))
      A(3)=F(3)-X(3)*B(3)
      DO 2 J=2,N1
      IF(C(J).EQ.0.)GO TO 2
      J1=J+1
      WT=ABS(C(J1))/(ABS(C(J1))+ABS(C(J)))
      A(J)=A(J1)+WT*(A(J)-A(J1))
      B(J)=B(J1)+WT*(B(J)-B(J1))
      C(J)=C(J1)+WT*(C(J)-C(J1))
    2 CONTINUE
      A(N1)=A(N)
      B(N1)=B(N)
      C(N1)=C(N)
      RETURN
      END
      FUNCTION MAP1(XOLD,FOLD,NOLD,XNEW,FNEW,NNEW)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION XOLD(NOLD),FOLD(NOLD),XNEW(NNEW),FNEW(NNEW)
      L=2
      LL=0
      DO 50 K=1,NNEW
   10 IF(XNEW(K).LT.XOLD(L))GO TO 20
      L=L+1
      IF(L.GT.NOLD)GO TO 30
      GO TO 10
   20 IF(L.EQ.LL)GO TO 50
      IF(L.EQ.2)GO TO 30
      IF(L.EQ.3)GO TO 30
      L1=L-1
      IF(L.GT.LL+1.OR.L.EQ.3)GO TO 21
      IF(L.GT.LL+1.OR.L.EQ.4)GO TO 21
      CBAC=CFOR
      BBAC=BFOR
      ABAC=AFOR
      IF(L.EQ.NOLD)GO TO 22
      GO TO 25
   21 L2=L-2
      D=(FOLD(L1)-FOLD(L2))/(XOLD(L1)-XOLD(L2))
      CBAC=FOLD(L)/((XOLD(L)-XOLD(L1))*(XOLD(L)-XOLD(L2)))+
     1(FOLD(L2)/(XOLD(L)-XOLD(L2))-FOLD(L1)/(XOLD(L)-XOLD(L1)))/
     2(XOLD(L1)-XOLD(L2))
      BBAC=D-(XOLD(L1)+XOLD(L2))*CBAC
      ABAC=FOLD(L2)-XOLD(L2)*D+XOLD(L1)*XOLD(L2)*CBAC
      IF(L.LT.NOLD)GO TO 25
   22 C=CBAC
      B=BBAC
      A=ABAC
      LL=L
      GO TO 50
   25 D=(FOLD(L)-FOLD(L1))/(XOLD(L)-XOLD(L1))
      CFOR=FOLD(L+1)/((XOLD(L+1)-XOLD(L))*(XOLD(L+1)-XOLD(L1)))+
     1(FOLD(L1)/(XOLD(L+1)-XOLD(L1))-FOLD(L)/(XOLD(L+1)-XOLD(L)))/
     2(XOLD(L)-XOLD(L1))
      BFOR=D-(XOLD(L)+XOLD(L1))*CFOR
      AFOR=FOLD(L1)-XOLD(L1)*D+XOLD(L)*XOLD(L1)*CFOR
      WT=0.
      IF(ABS(CFOR).NE.0.)WT=ABS(CFOR)/(ABS(CFOR)+ABS(CBAC))
      A=AFOR+WT*(ABAC-AFOR)
      B=BFOR+WT*(BBAC-BFOR)
      C=CFOR+WT*(CBAC-CFOR)
      LL=L
      GO TO 50
   30 IF(L.EQ.LL)GO TO 50
      L=AMIN0(NOLD,L)
      C=0.
      B=(FOLD(L)-FOLD(L-1))/(XOLD(L)-XOLD(L-1))
      A=FOLD(L)-XOLD(L)*B
      LL=L
   50 FNEW(K)=A+(B+C*XNEW(K))*XNEW(K)
      MAP1=LL-1
      RETURN
      END
      SUBROUTINE SOLVIT(A,N,B,IPIVOT)
      IMPLICIT REAL*8 (A-H,O-Z)
C     SOLVES LINEAR EQUATIONS
C     A IS A COMPLETELY FILLED N BY N ARRAY WHICH IS DESTROYED.
C     B IS THE RIGHT SIDE VECTOR OF LENGTH N AND RETURNS AS THE SOLUTION
C     IPIVOT IS A SCRATCH AREA OF LENGTH N.
      DIMENSION A(N),B(N),IPIVOT(N)
      EQUIVALENCE(AMAX,SWAP,PIVOT,T)
      DO 20 J=1,N
   20 IPIVOT(J)=0
      DO 550 I=1,N
      AMAX=0.
      DO 105 J=1,N
      IF(IPIVOT(J).EQ.1)GO TO 105
      JK=J-N
      DO 100 K=1,N
      JK=JK+N
      IF(IPIVOT(K).EQ.1)GO TO 100
      AA=ABS(A(JK))
      IF(AMAX.GE.AA)GO TO 100
      IROW=J
      ICOLUM=K
      AMAX=AA
  100 CONTINUE
  105 CONTINUE
      IPIVOT(ICOLUM)=IPIVOT(ICOLUM)+1
      IF(IROW.EQ.ICOLUM)GO TO 260
      IRL=IROW-N
      ICL=ICOLUM-N
      DO 200 L=1,N
      IRL=IRL+N
      SWAP=A(IRL)
      ICL=ICL+N
      A(IRL)=A(ICL)
  200 A(ICL)=SWAP
      SWAP=B(IROW)
      B(IROW)=B(ICOLUM)
      B(ICOLUM)=SWAP
  260 ICIC=ICOLUM*N+ICOLUM-N
      PIVOT=A(ICIC)
      A(ICIC)=1.
      ICL=ICOLUM-N
      DO 350 L=1,N
      ICL=ICL+N
  350 A(ICL)=A(ICL)/PIVOT
      B(ICOLUM)=B(ICOLUM)/PIVOT
      L1IC=ICOLUM*N-N
      DO 550 L1=1,N
      L1IC=L1IC+1
      IF(L1.EQ.ICOLUM)GO TO 550
      T=A(L1IC)
      A(L1IC)=0.
      L1L=L1-N
      ICL=ICOLUM-N
      DO 450 L=1,N
      L1L=L1L+N
      ICL=ICL+N
  450 A(L1L)=A(L1L)-A(ICL)*T
      B(L1)=B(L1)-B(ICOLUM)*T
  550 CONTINUE
      RETURN
      END
      FUNCTION EXPI(N,X)
      IMPLICIT REAL*8 (A-H,O-Z)
C     EXPONENTIAL INTEGRAL FOR POSITIVE ARGUMENTS AFTER CODY AND
C     THACHER, MATH. OF COMP.,22,641(1968)
      DATA X1/-1.E20/
      DATA A0,A1,A2,A3,A4,A5,B0,B1,B2,B3,B4/
     1-44178.5471728217,57721.7247139444,9938.31388962037,
     2 1842.11088668000,101.093806161906,5.03416184097568,
     3 76537.3323337614,32597.1881290275,6106.10794245759,
     4 635.419418378382,37.2298352833327/
      DATA C0,C1,C2,C3,C4,C5,C6,D1,D2,D3,D4,D5,D6/
     1 4.65627107975096E-7,
     2 .999979577051595,9.04161556946329,24.3784088791317,
     3 23.0192559391333,6.90522522784444,.430967839469389,
     4 10.0411643829054,32.4264210695138,41.2807841891424,
     5 20.4494785013794,3.31909213593302,.103400130404874/
      DATA E0,E1,E2,E3,E4,E5,E6,F1,F2,F3,F4,F5,F6/
     1-.999999999998447,-26.6271060431811,-241.055827097015,
     2-895.927957772937,-1298.85688746484,-545.374158883133,
     3-5.66575206533869, 28.6271060422192, 292.310039388533,
     4 1332.78537748257, 2777.61949509163, 2404.01713225909,
     5 631.657483280800/
      IF(X.EQ.X1)GO TO 40
      EX=EXP(-X)
      X1=X
      IF(X.GT.4.)GO TO 10
      IF(X.GT.1.)GO TO 20
      IF(X.GT.0.)GO TO 30
      EX1=0.
      GO TO 40
   10 EX1=(EX+EX*(E0+(E1+(E2+(E3+(E4+(E5+E6/X)/X)/X)/X)/X)/X)/
     1            (X+ F1+(F2+(F3+(F4+(F5+F6/X)/X)/X)/X)/X))/X
      GO TO 40
   20 EX1=EX*(C6+(C5+(C4+(C3+(C2+(C1+C0*X)*X)*X)*X)*X)*X)/
     1       (D6+(D5+(D4+(D3+(D2+(D1+X)*X)*X)*X)*X)*X)
      GO TO 40
   30 EX1=(A0+(A1+(A2+(A3+(A4+A5*X)*X)*X)*X)*X)/
     1    (B0+(B1+(B2+(B3+(B4+X)*X)*X)*X)*X)-DLOG(X)
   40 EXPI=EX1
      IF(N.EQ.1)RETURN
      N1=N-1
      DO 41 I=1,N1
   41 EXPI=(EX-X*EXPI)/FLOAT(I)
      RETURN
      END
      SUBROUTINE W(A,B,N)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION B(N)
      WRITE(6,100)A,(B(I),I=1,N)
C 100 FORMAT(1H0,A6,0P10E12.4/(7X,10E12.4))
  100 FORMAT(1H0,A6,1P10E12.4/(7X,10E12.4))
      RETURN
      END
      SUBROUTINE JOSH(IFSCAT,IFSURF)
      IMPLICIT REAL*8 (A-H,O-Z)
      parameter (mx=99)
C     IFSCAT=1  SOLVE INTEGRAL EQUATION FOR SOURCE FUNCTION
C     IFSCAT=0  SET SNU=SBAR
C     IFSURF=0  CALCULATE J AND H
C     IFSURF=1  CALCULATE SURFACE FLUX
C     IFSURF=2  CALCULATE SURFACE SPECIFIC INTENSITY
      COMMON /ABTOT/ABTOT(mx),ALPHA(mx)
      DIMENSION    C1(43),C2(43),C3(43),C4(43),C5(43),C6(43),C7(43),
     1             C8(43),C9(43),C10(43),C11(43),C12(43),C13(43),
     2             C14(43),C15(43),C16(43),C17(43),C18(43),C19(43),
     3             C20(43),C21(43),C22(43),C23(43),C24(43),C25(43),
     4             C26(43),C27(43),C28(43),C29(43),C30(43),C31(43),
     5             C32(43),C33(43),C34(43),C35(43),C36(43),C37(43),
     6             C38(43),C39(43),C40(43),C41(43),C42(43),C43(43),
     7             D1(43),D2(43),D3(43),D4(43),D5(43),D6(43),D7(43),
     8             D8(43),D9(43),D10(43),D11(43),D12(43),D13(43),
     9             D14(43),D15(43),D16(43),D17(43),D18(43),D19(43),
     T             D20(43),D21(43),D22(43),D23(43),D24(43),D25(43),
     1             D26(43),D27(43),D28(43),D29(43),D30(43),D31(43),
     2             D32(43),D33(43),D34(43),D35(43),D36(43),D37(43),
     3             D38(43),D39(43),D40(43),D41(43),D42(43),D43(43)
      COMMON /JMATX/CJ(1849)
      COMMON /HMATX/CH(1849)
      EQUIVALENCE (C1 (1),CJ(   1)),(C2 (1),CJ(  44))
      EQUIVALENCE (C3 (1),CJ(  87)),(C4 (1),CJ( 130))
      EQUIVALENCE (C5 (1),CJ( 173)),(C6 (1),CJ( 216))
      EQUIVALENCE (C7 (1),CJ( 259)),(C8 (1),CJ( 302))
      EQUIVALENCE (C9 (1),CJ( 345)),(C10(1),CJ( 388))
      EQUIVALENCE (C11(1),CJ( 431)),(C12(1),CJ( 474))
      EQUIVALENCE (C13(1),CJ( 517)),(C14(1),CJ( 560))
      EQUIVALENCE (C15(1),CJ( 603)),(C16(1),CJ( 646))
      EQUIVALENCE (C17(1),CJ( 689)),(C18(1),CJ( 732))
      EQUIVALENCE (C19(1),CJ( 775)),(C20(1),CJ( 818))
      EQUIVALENCE (C21(1),CJ( 861)),(C22(1),CJ( 904))
      EQUIVALENCE (C23(1),CJ( 947)),(C24(1),CJ( 990))
      EQUIVALENCE (C25(1),CJ(1033)),(C26(1),CJ(1076))
      EQUIVALENCE (C27(1),CJ(1119)),(C28(1),CJ(1162))
      EQUIVALENCE (C29(1),CJ(1205)),(C30(1),CJ(1248))
      EQUIVALENCE (C31(1),CJ(1291)),(C32(1),CJ(1334))
      EQUIVALENCE (C33(1),CJ(1377)),(C34(1),CJ(1420))
      EQUIVALENCE (C35(1),CJ(1463)),(C36(1),CJ(1506))
      EQUIVALENCE (C37(1),CJ(1549)),(C38(1),CJ(1592))
      EQUIVALENCE (C39(1),CJ(1635)),(C40(1),CJ(1678))
      EQUIVALENCE (C41(1),CJ(1721)),(C42(1),CJ(1764))
      EQUIVALENCE (C43(1),CJ(1807))
      EQUIVALENCE (D1 (1),CH(   1)),(D2 (1),CH(  44))
      EQUIVALENCE (D3 (1),CH(  87)),(D4 (1),CH( 130))
      EQUIVALENCE (D5 (1),CH( 173)),(D6 (1),CH( 216))
      EQUIVALENCE (D7 (1),CH( 259)),(D8 (1),CH( 302))
      EQUIVALENCE (D9 (1),CH( 345)),(D10(1),CH( 388))
      EQUIVALENCE (D11(1),CH( 431)),(D12(1),CH( 474))
      EQUIVALENCE (D13(1),CH( 517)),(D14(1),CH( 560))
      EQUIVALENCE (D15(1),CH( 603)),(D16(1),CH( 646))
      EQUIVALENCE (D17(1),CH( 689)),(D18(1),CH( 732))
      EQUIVALENCE (D19(1),CH( 775)),(D20(1),CH( 818))
      EQUIVALENCE (D21(1),CH( 861)),(D22(1),CH( 904))
      EQUIVALENCE (D23(1),CH( 947)),(D24(1),CH( 990))
      EQUIVALENCE (D25(1),CH(1033)),(D26(1),CH(1076))
      EQUIVALENCE (D27(1),CH(1119)),(D28(1),CH(1162))
      EQUIVALENCE (D29(1),CH(1205)),(D30(1),CH(1248))
      EQUIVALENCE (D31(1),CH(1291)),(D32(1),CH(1334))
      EQUIVALENCE (D33(1),CH(1377)),(D34(1),CH(1420))
      EQUIVALENCE (D35(1),CH(1463)),(D36(1),CH(1506))
      EQUIVALENCE (D37(1),CH(1549)),(D38(1),CH(1592))
      EQUIVALENCE (D39(1),CH(1635)),(D40(1),CH(1678))
      EQUIVALENCE (D41(1),CH(1721)),(D42(1),CH(1764))
      EQUIVALENCE (D43(1),CH(1807))
      COMMON /XTAU/XTAU(43),NXTAU
      DIMENSION COEFJ(43,43),COEFH(43,43)
      EQUIVALENCE (COEFJ(1,1),CJ(1)),(COEFH(1,1),CH(1))
      COMMON /MUS/ANGLE(20),SURFI(20),NMU
      COMMON /OPTOT/ACONT(mx),SCONT(mx),ALINE(mx),SLINE(mx),SIGMAC(mx),
     1              SIGMAL(mx)
      COMMON /PZERO/PZERO,PCON,PRADK0,PTURB0,KNU(mx),PRADK(mx),EDENS(mx)
      REAL*8 KNU
      COMMON /RHOX/RHOX(mx),NRHOX
      COMMON /TAUSHJ/TAUNU(mx),SNU(mx),HNU(mx),JNU(mx),JMINS(mx)
      REAL*8 JNU,JMINS
      DIMENSION XS(43),XSBAR(43),XALPHA(43),DIAG(43),XH(43),XJS(43)
      EQUIVALENCE (XSBAR(1),XH(1)),(XALPHA(1),XJS(1))
      DIMENSION A(mx),B(mx),C(mx),SNUBAR(mx)
      EQUIVALENCE (A(1),HNU(1)),(B(1),JNU(1)),(C(1),JMINS(1))
      REAL*8 NEW
      DIMENSION CTWO(mx),B2CT(mx),B2CT1(mx)
      EQUIVALENCE (CTWO(1),C(1)),(B2CT(1),A(1)),(B2CT1(1),B(1))
      DIMENSION CK(43)
      DATA CK/
     1 3.57766096E-06, 7.45694648E-06, 7.60499095E-06, 1.49063478E-05,
     2 2.66928238E-05, 4.56529874E-05, 8.08134890E-05, 1.48363317E-04,
     3 2.66052353E-04, 4.39771295E-04, 8.25088202E-04, 1.29440727E-03,
     4 1.67680858E-03, 2.98973695E-03, 4.68314717E-03, 5.84855252E-03,
     5 7.64854737E-03, 9.63155827E-03, 1.16419575E-02, 1.38551744E-02,
     6 1.54840987E-02, 1.42877985E-02, 1.25930301E-02, 1.17983134E-02,
     7 1.09717195E-02, 8.98320701E-03, 7.59950897E-03, 6.38808041E-03,
     8 4.86854174E-03, 3.91568600E-03, 2.51398841E-03, 2.00142376E-03,
     9 1.70069210E-03, 1.14410931E-03, 6.76215640E-04, 3.92992270E-04,
     T 1.71722329E-04, 3.54991779E-05, 4.25212770E-06,-6.08974379E-08,
     1-2.13778444E-08,-1.01481329E-09,-7.82776605E-11/
      DO 10 J=1,NRHOX
      ABTOT(J)=ACONT(J)+ALINE(J)+SIGMAC(J)+SIGMAL(J)
      ALPHA(J)=(SIGMAC(J)+SIGMAL(J))/ABTOT(J)
   10 SNUBAR(J)=(ACONT(J)*SCONT(J)+ALINE(J)*SLINE(J))/
     1(ACONT(J)+ALINE(J))
C     RHOX0=RHOX(1)
C     RHOX(1)=0.
C     CALL INTEG(RHOX,ABTOT,TAUNU,NRHOX)
C     RHOX(1)=RHOX0
C     TO FIX PROBLEM WITH TEMPERATURE DROP AT FIRST POINT
      ABTOT(1)=ABTOT(2)
      CALL INTEG(RHOX,ABTOT,TAUNU,NRHOX,ABTOT(1)*RHOX(1))
      TAUNU(1)=0.
      IF(IFSCAT.EQ.1)GO TO 30
C
      DO 20 J=1,NRHOX
   20 SNU(J)=SNUBAR(J)
      IF(IFSURF.EQ.2)GO TO 70
      MAXJ=MAP1(TAUNU,SNU,NRHOX,XTAU,XS,NXTAU)
      IF(IFSURF.EQ.1)GO TO 60
      DO 21 J=1,NRHOX
   21 ALPHA(J)=0.
C
   30 MAXJ=MAP1(TAUNU,SNUBAR,NRHOX,XTAU,XSBAR,NXTAU)
      MAXJ=MAP1(TAUNU,ALPHA,NRHOX,XTAU,XALPHA,NXTAU)
      DO 31 L=1,NXTAU
C     IN CASE OF BAD INTERPOLATION
      IF(XALPHA(L).LT.0.)XALPHA(L)=0.
      XS(L)=XSBAR(L)
      DIAG(L)=1.-XALPHA(L)*COEFJ(L,L)
   31 XSBAR(L)=(1.-XALPHA(L))*XSBAR(L)
C     THE LIMIT ON DO 34, THE MAXIMUM NUMBER OF ITERATIONS, IS ARBITRARY
      DO 34 L=1,NXTAU
      IFERR=0
      K=NXTAU+1
      DO 33 KK=1,NXTAU
      K=K-1
      DELXS=C1(K)*XS(1)+C2(K)*XS(2)+C3(K)*XS(3)+C4(K)*XS(4)+C5(K)*XS(5)+
     1C6(K)*XS(6)+C7(K)*XS(7)+C8(K)*XS(8)+C9(K)*XS(9)+C10(K)*XS(10)+
     2C11(K)*XS(11)+C12(K)*XS(12)+C13(K)*XS(13)+C14(K)*XS(14)+
     3C15(K)*XS(15)+C16(K)*XS(16)+C17(K)*XS(17)+C18(K)*XS(18)+
     4C19(K)*XS(19)+C20(K)*XS(20)+C21(K)*XS(21)+C22(K)*XS(22)+
     5C23(K)*XS(23)+C24(K)*XS(24)+C25(K)*XS(25)+C26(K)*XS(26)+
     6C27(K)*XS(27)+C28(K)*XS(28)+C29(K)*XS(29)+C30(K)*XS(30)+
     7C31(K)*XS(31)+C32(K)*XS(32)+C33(K)*XS(33)+C34(K)*XS(34)+
     8C35(K)*XS(35)+C36(K)*XS(36)+C37(K)*XS(37)+C38(K)*XS(38)+
     9C39(K)*XS(39)+C40(K)*XS(40)+C41(K)*XS(41)+C42(K)*XS(42)+
     TC43(K)*XS(43)
C     DELXS=0.
C     DO 32 M=1,NXTAU
C  32 DELXS=DELXS+COEFJ(K,M)*XS(M)
      DELXS=(DELXS*XALPHA(K)+XSBAR(K)-XS(K))/DIAG(K)
      ERROR=ABS(DELXS/XS(K))
      IF(ERROR.GT..00001)IFERR=1
   33 XS(K)=XS(K)+DELXS
   39 IF(IFERR.EQ.0)GO TO 35
   34 CONTINUE
C
   35 IF(IFSURF.EQ.1)GO TO 60
      MDUMMY=MAP1(XTAU,XS,NXTAU,TAUNU,SNU,MAXJ)
      IF(MAXJ.EQ.NRHOX)GO TO 46
      MAXJ1=MAXJ+1
      DO 40 J=MAXJ1,NRHOX
   40 SNU(J)=SNUBAR(J)
      M=MAX0(MAXJ-1,1)
      NM1=NRHOX-M+1
      NMJ=NRHOX-MAXJ+1
C     THE LIMIT ON DO 45 IS ARBITRARY
      DO 45 L=1,NXTAU
      ERROR=0.
      CALL DERIV(TAUNU(M),SNU(M),HNU(M),NM1)
      DO 41 J=M,NRHOX
   41 HNU(J)=HNU(J)/3.
      CALL DERIV(TAUNU(MAXJ),HNU(MAXJ),JMINS(MAXJ),NMJ)
      DO 43 J=MAXJ1,NRHOX
      JNU(J)=JMINS(J)+SNU(J)
      SNEW=(1.-ALPHA(J))*SNUBAR(J)+ALPHA(J)*JNU(J)
      ERROR=ABS(SNEW-SNU(J))/SNEW+ERROR
   43 SNU(J)=SNEW
      IF(ERROR.LT..00001)GO TO 46
   45 CONTINUE
   46 IF(IFSURF.EQ.2)GO TO 70
C
C  50 DO 51 L=1,NXTAU
C     XJS(L)=-XS(L)
C     XH(L)=0.
C     DO 51 M=1,NXTAU
C     XJS(L)=XJS(L)+COEFJ(L,M)*XS(M)
C  51 XH(L)=XH(L)+COEFH(L,M)*XS(M)
   50 DO 51 K=1,NXTAU
      XJ   =C1(K)*XS(1)+C2(K)*XS(2)+C3(K)*XS(3)+C4(K)*XS(4)+C5(K)*XS(5)+
     1C6(K)*XS(6)+C7(K)*XS(7)+C8(K)*XS(8)+C9(K)*XS(9)+C10(K)*XS(10)+
     2C11(K)*XS(11)+C12(K)*XS(12)+C13(K)*XS(13)+C14(K)*XS(14)+
     3C15(K)*XS(15)+C16(K)*XS(16)+C17(K)*XS(17)+C18(K)*XS(18)+
     4C19(K)*XS(19)+C20(K)*XS(20)+C21(K)*XS(21)+C22(K)*XS(22)+
     5C23(K)*XS(23)+C24(K)*XS(24)+C25(K)*XS(25)+C26(K)*XS(26)+
     6C27(K)*XS(27)+C28(K)*XS(28)+C29(K)*XS(29)+C30(K)*XS(30)+
     7C31(K)*XS(31)+C32(K)*XS(32)+C33(K)*XS(33)+C34(K)*XS(34)+
     8C35(K)*XS(35)+C36(K)*XS(36)+C37(K)*XS(37)+C38(K)*XS(38)+
     9C39(K)*XS(39)+C40(K)*XS(40)+C41(K)*XS(41)+C42(K)*XS(42)+
     TC43(K)*XS(43)
      XJS(K)=XJ-XS(K)
      XH(K)=D1(K)*XS(1)+D2(K)*XS(2)+D3(K)*XS(3)+D4(K)*XS(4)+D5(K)*XS(5)+
     1D6(K)*XS(6)+D7(K)*XS(7)+D8(K)*XS(8)+D9(K)*XS(9)+D10(K)*XS(10)+
     2D11(K)*XS(11)+D12(K)*XS(12)+D13(K)*XS(13)+D14(K)*XS(14)+
     3D15(K)*XS(15)+D16(K)*XS(16)+D17(K)*XS(17)+D18(K)*XS(18)+
     4D19(K)*XS(19)+D20(K)*XS(20)+D21(K)*XS(21)+D22(K)*XS(22)+
     5D23(K)*XS(23)+D24(K)*XS(24)+D25(K)*XS(25)+D26(K)*XS(26)+
     6D27(K)*XS(27)+D28(K)*XS(28)+D29(K)*XS(29)+D30(K)*XS(30)+
     7D31(K)*XS(31)+D32(K)*XS(32)+D33(K)*XS(33)+D34(K)*XS(34)+
     8D35(K)*XS(35)+D36(K)*XS(36)+D37(K)*XS(37)+D38(K)*XS(38)+
     9D39(K)*XS(39)+D40(K)*XS(40)+D41(K)*XS(41)+D42(K)*XS(42)+
     TD43(K)*XS(43)
   51 CONTINUE
      MDUMMY=MAP1(XTAU,XJS,NXTAU,TAUNU,JMINS,MAXJ)
      MDUMMY=MAP1(XTAU,XH,NXTAU,TAUNU,HNU,MAXJ)
      KNU(1)=CK(1)*XS(1)+CK(2)*XS(2)+CK(3)*XS(3)+CK(4)*XS(4)+CK(5)*XS(5)
     1+CK(6)*XS(6)+CK(7)*XS(7)+CK(8)*XS(8)+CK(9)*XS(9)+CK(10)*XS(10)+
     2CK(11)*XS(11)+CK(12)*XS(12)+CK(13)*XS(13)+CK(14)*XS(14)+
     3CK(15)*XS(15)+CK(16)*XS(16)+CK(17)*XS(17)+CK(18)*XS(18)+
     4CK(19)*XS(19)+CK(20)*XS(20)+CK(21)*XS(21)+CK(22)*XS(22)+
     5CK(23)*XS(23)+CK(24)*XS(24)+CK(25)*XS(25)+CK(26)*XS(26)+
     6CK(27)*XS(27)+CK(28)*XS(28)+CK(29)*XS(29)+CK(30)*XS(30)+
     7CK(31)*XS(31)+CK(32)*XS(32)+CK(33)*XS(33)+CK(34)*XS(34)+
     8CK(35)*XS(35)+CK(36)*XS(36)+CK(37)*XS(37)+CK(38)*XS(38)+
     9CK(39)*XS(39)+CK(40)*XS(40)+CK(41)*XS(41)+CK(42)*XS(42)+
     TCK(43)*XS(43)
      DO 52 J=1,MAXJ
   52 JNU(J)=JMINS(J)+SNU(J)
      RETURN
C
   60 HNU(1)=0.
      DO 61 M=1,NXTAU
   61 HNU(1)=HNU(1)+COEFH(1,M)*XS(M)
C     WRITE(6,3333) (ABTOT(J),J=1,NRHOX)
C     WRITE(6,3333) (RHOX(J),J=1,NRHOX)
C     WRITE(6,3333) (TAUNU(J),J=1,NRHOX)
C     WRITE(6,3333) (XS(J),J=1,NXTAU)
C     WRITE(6,3334) HNU(1)
C3333 FORMAT(1P11E12.5)
C3334 FORMAT(1H ,3X,E15.7/)
      RETURN
C
   70 CALL PARCOE(SNU,TAUNU,A,B,C,NRHOX)
      DO 71 J=1,NRHOX
      CTWO(J)=C(J)*2.
      B2CT(J)=B(J)+CTWO(J)*TAUNU(J)
   71 B2CT1(J)=B(J)+CTWO(J)*TAUNU(J+1)
      N1=NRHOX-1
      DO 75 MU=1,NMU
      OLD=1.
      SUM=0.
      DO 73 J=1,N1
      TANGLE=TAUNU(J+1)/ANGLE(MU)
      NEW=EXP(-TANGLE)
      D=TANGLE-TAUNU(J)/ANGLE(MU)
      IF(D.LE..03)GO TO 72
      SUM=SUM+OLD*(SNU(J)+(B2CT(J)+CTWO(J)*ANGLE(MU))*ANGLE(MU))-
     1     NEW*(SNU(J+1)+(B2CT1(J)+CTWO(J)*ANGLE(MU))*ANGLE(MU))
      IF(TANGLE.LT.50.)GO TO 73
      SURFI(MU)=SUM
      GO TO 75
   72 DDDDD=1.
      IF(D.GT..001)DDDDD=((((D/9.+1.)*D/8.+1.)*D/7.+1.)*D/6.+1.)*D/5.+1.
      SUM=SUM+NEW*(SNU(J)+(SNU(J)+B2CT(J)*ANGLE(MU)+(SNU(J)+(B2CT(J)+
     1CTWO(J)*ANGLE(MU))*ANGLE(MU))*(DDDDD*D/4.+1.)*D/3.)*D/2.)*D
   73 OLD=NEW
      SURFI(MU)=SUM+OLD*(SNU(NRHOX)+(B2CT(NRHOX)+CTWO(NRHOX)*ANGLE(MU))*
     1ANGLE(MU))
   75 CONTINUE
      RETURN
      END
      BLOCK DATA MJDATA
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON /JMATX/CJ(1849)
      COMMON /XTAU/XTAU(43),NXTAU
      DIMENSION CJ   1(36),CJ   2(36),CJ   3(36),CJ   4(36),CJ   5(36)
      DIMENSION CJ   6(36),CJ   7(36),CJ   8(36),CJ   9(36),CJ  10(36)
      DIMENSION CJ  11(36),CJ  12(36),CJ  13(36),CJ  14(36),CJ  15(36)
      DIMENSION CJ  16(36),CJ  17(36),CJ  18(36),CJ  19(36),CJ  20(36)
      DIMENSION CJ  21(36),CJ  22(36),CJ  23(36),CJ  24(36),CJ  25(36)
      DIMENSION CJ  26(36),CJ  27(36),CJ  28(36),CJ  29(36),CJ  30(36)
      DIMENSION CJ  31(36),CJ  32(36),CJ  33(36),CJ  34(36),CJ  35(36)
      DIMENSION CJ  36(36),CJ  37(36),CJ  38(36),CJ  39(36),CJ  40(36)
      DIMENSION CJ  41(36),CJ  42(36),CJ  43(36),CJ  44(36),CJ  45(36)
      DIMENSION CJ  46(36),CJ  47(36),CJ  48(36),CJ  49(36),CJ  50(36)
      DIMENSION CJ  51(36),CJ  52(13)
      EQUIVALENCE (CJ   1(1),CJ (   1)),(CJ   2(1),CJ (  37))
      EQUIVALENCE (CJ   3(1),CJ (  73)),(CJ   4(1),CJ ( 109))
      EQUIVALENCE (CJ   5(1),CJ ( 145)),(CJ   6(1),CJ ( 181))
      EQUIVALENCE (CJ   7(1),CJ ( 217)),(CJ   8(1),CJ ( 253))
      EQUIVALENCE (CJ   9(1),CJ ( 289)),(CJ  10(1),CJ ( 325))
      EQUIVALENCE (CJ  11(1),CJ ( 361)),(CJ  12(1),CJ ( 397))
      EQUIVALENCE (CJ  13(1),CJ ( 433)),(CJ  14(1),CJ ( 469))
      EQUIVALENCE (CJ  15(1),CJ ( 505)),(CJ  16(1),CJ ( 541))
      EQUIVALENCE (CJ  17(1),CJ ( 577)),(CJ  18(1),CJ ( 613))
      EQUIVALENCE (CJ  19(1),CJ ( 649)),(CJ  20(1),CJ ( 685))
      EQUIVALENCE (CJ  21(1),CJ ( 721)),(CJ  22(1),CJ ( 757))
      EQUIVALENCE (CJ  23(1),CJ ( 793)),(CJ  24(1),CJ ( 829))
      EQUIVALENCE (CJ  25(1),CJ ( 865)),(CJ  26(1),CJ ( 901))
      EQUIVALENCE (CJ  27(1),CJ ( 937)),(CJ  28(1),CJ ( 973))
      EQUIVALENCE (CJ  29(1),CJ (1009)),(CJ  30(1),CJ (1045))
      EQUIVALENCE (CJ  31(1),CJ (1081)),(CJ  32(1),CJ (1117))
      EQUIVALENCE (CJ  33(1),CJ (1153)),(CJ  34(1),CJ (1189))
      EQUIVALENCE (CJ  35(1),CJ (1225)),(CJ  36(1),CJ (1261))
      EQUIVALENCE (CJ  37(1),CJ (1297)),(CJ  38(1),CJ (1333))
      EQUIVALENCE (CJ  39(1),CJ (1369)),(CJ  40(1),CJ (1405))
      EQUIVALENCE (CJ  41(1),CJ (1441)),(CJ  42(1),CJ (1477))
      EQUIVALENCE (CJ  43(1),CJ (1513)),(CJ  44(1),CJ (1549))
      EQUIVALENCE (CJ  45(1),CJ (1585)),(CJ  46(1),CJ (1621))
      EQUIVALENCE (CJ  47(1),CJ (1657)),(CJ  48(1),CJ (1693))
      EQUIVALENCE (CJ  49(1),CJ (1729)),(CJ  50(1),CJ (1765))
      EQUIVALENCE (CJ  51(1),CJ (1801)),(CJ  52(1),CJ (1837))
      DATA CJ   1/
     1 8.14986025E-05, 7.31538254E-05, 6.71178656E-05, 6.24581491E-05,
     2 5.79414138E-05, 5.36599004E-05, 4.95677731E-05, 4.53702132E-05,
     3 4.11409031E-05, 3.70180419E-05, 3.30221502E-05, 2.88995437E-05,
     4 2.55766809E-05, 2.24455861E-05, 1.88519709E-05, 1.58867744E-05,
     5 1.33092440E-05, 1.09509308E-05, 8.86744834E-06, 6.98752785E-06,
     6 5.33944478E-06, 4.00549621E-06, 3.06255733E-06, 2.30471158E-06,
     7 1.70829464E-06, 1.22756917E-06, 8.97423163E-07, 6.17580912E-07,
     8 4.31441568E-07, 2.84814120E-07, 1.90447891E-07, 1.28648434E-07,
     9 7.72171575E-08, 4.14502255E-08, 2.00042982E-08, 8.21662923E-09/
      DATA CJ   2/
     1 2.04916539E-09, 3.36821047E-10, 2.97451696E-11, 1.98489427E-12,
     2 1.37287283E-13, 9.73803273E-15, 7.03780218E-16, 1.50153547E-04,
     3 1.69998410E-04, 1.49551568E-04, 1.33114548E-04, 1.22341492E-04,
     4 1.12691930E-04, 1.03789120E-04, 9.48288272E-05, 8.58965958E-05,
     5 7.72399845E-05, 6.88765300E-05, 6.02632697E-05, 5.33275330E-05,
     6 4.67953579E-05, 3.93007243E-05, 3.31179453E-05, 2.77440975E-05,
     7 2.28276312E-05, 1.84843096E-05, 1.45654595E-05, 1.11299644E-05,
     8 8.34933442E-06, 6.38378621E-06, 4.80407272E-06, 3.56085984E-06,
     9 2.55880582E-06, 1.87063082E-06, 1.28731302E-06, 8.99315117E-07/
      DATA CJ   3/
     1 5.93678149E-07, 3.96977081E-07, 2.68159722E-07, 1.60954311E-07,
     2 8.64003431E-08, 4.16976593E-08, 1.71270216E-08, 4.27134786E-09,
     3 7.02080564E-10, 6.20017576E-11, 4.13737418E-12, 2.86165744E-13,
     4 2.02982455E-14, 1.46698029E-15, 1.38762226E-04, 1.52892603E-04,
     5 1.73973599E-04, 1.48361768E-04, 1.27782783E-04, 1.16648599E-04,
     6 1.06792177E-04, 9.72270010E-05, 8.78857753E-05, 7.89334108E-05,
     7 7.03363020E-05, 6.15124360E-05, 5.44199981E-05, 4.77466096E-05,
     8 4.00947229E-05, 3.37846547E-05, 2.83013360E-05, 2.32853712E-05,
     9 1.88545261E-05, 1.48569320E-05, 1.13525420E-05, 8.51622518E-06/
      DATA CJ   4/
     1 6.51134817E-06, 4.90004469E-06, 3.63198185E-06, 2.60990507E-06,
     2 1.90798268E-06, 1.31301454E-06, 9.17268607E-07, 6.05529102E-07,
     3 4.04901009E-07, 2.73512100E-07, 1.64166733E-07, 8.81246833E-08,
     4 4.25298033E-08, 1.74688037E-08, 4.35658139E-09, 7.16089755E-10,
     5 6.32388810E-11, 4.21992498E-12, 2.91875343E-13, 2.07032318E-14,
     6 1.49624885E-15, 2.56894537E-04, 2.68265016E-04, 2.82680119E-04,
     7 3.20147632E-04, 2.71320447E-04, 2.33081797E-04, 2.11908717E-04,
     8 1.91950967E-04, 1.73009337E-04, 1.55132197E-04, 1.38103891E-04,
     9 1.20705419E-04, 1.06754481E-04, 9.36443364E-05, 7.86242175E-05/
      DATA CJ   5/
     1 6.62442877E-05, 5.54893860E-05, 4.56528336E-05, 3.69646972E-05,
     2 2.91266743E-05, 2.22560211E-05, 1.66953761E-05, 1.27648716E-05,
     3 9.60600474E-06, 7.12006931E-06, 5.11638732E-06, 3.74034592E-06,
     4 2.57398256E-06, 1.79817365E-06, 1.18705058E-06, 7.93747494E-07,
     5 5.36178620E-07, 3.21823317E-07, 1.72754489E-07, 8.33728443E-08,
     6 3.42447430E-08, 8.54035678E-09, 1.40377384E-09, 1.23969092E-10,
     7 8.27244054E-12, 5.72171358E-13, 4.05851067E-14, 2.93313638E-15,
     8 4.28478661E-04, 4.38774832E-04, 4.48007290E-04, 4.74192405E-04,
     9 5.41887599E-04, 4.55714232E-04, 3.88809427E-04, 3.48834558E-04/
      DATA CJ   6/
     1 3.12498628E-04, 2.79274670E-04, 2.48145814E-04, 2.16625539E-04,
     2 1.91470492E-04, 1.67889720E-04, 1.40916781E-04, 1.18707073E-04,
     3 9.94231585E-05, 8.17917639E-05, 6.62222043E-05, 5.21781154E-05,
     4 3.98685750E-05, 2.99067370E-05, 2.28655892E-05, 1.72069282E-05,
     5 1.27538260E-05, 9.16465428E-06, 6.69979937E-06, 4.61055441E-06,
     6 3.22090046E-06, 2.12624430E-06, 1.42175560E-06, 9.60397422E-07,
     7 5.76444952E-07, 3.09434371E-07, 1.49335410E-07, 6.13382136E-08,
     8 1.52972066E-08, 2.51438798E-09, 2.22048435E-10, 1.48172404E-11,
     9 1.02484777E-12, 7.26941783E-14, 5.25369629E-15, 6.81346357E-04/
      DATA CJ   7/
     1 6.90881617E-04, 6.98754282E-04, 7.15098172E-04, 7.61797143E-04,
     2 8.79148724E-04, 7.30251690E-04, 6.11067387E-04, 5.42551009E-04,
     3 4.82001904E-04, 4.26857352E-04, 3.71876580E-04, 3.28350939E-04,
     4 2.87718988E-04, 2.41367155E-04, 2.03264175E-04, 1.70210809E-04,
     5 1.40006824E-04, 1.13344596E-04, 8.93004808E-05, 6.82295010E-05,
     6 5.11791622E-05, 3.91286652E-05, 2.94446879E-05, 2.18241298E-05,
     7 1.56821832E-05, 1.14643071E-05, 7.88923736E-06, 5.51132513E-06,
     8 3.63822025E-06, 2.43275575E-06, 1.64332221E-06, 9.86342258E-07,
     9 5.29464043E-07, 2.55522410E-07, 1.04953205E-07, 2.61742883E-08/
      DATA CJ   8/
     1 4.30222799E-09, 3.79933350E-10, 2.53528033E-11, 1.75354660E-12,
     2 1.24381866E-13, 8.98921998E-15, 1.11484772E-03, 1.12418194E-03,
     3 1.13155813E-03, 1.14602725E-03, 1.17595604E-03, 1.25851232E-03,
     4 1.46433576E-03, 1.19777794E-03, 9.84898020E-04, 8.67486791E-04,
     5 7.63496969E-04, 6.62669551E-04, 5.84007292E-04, 5.11122829E-04,
     6 4.28377739E-04, 3.60559179E-04, 3.01823315E-04, 2.48203963E-04,
     7 2.00902454E-04, 1.58263961E-04, 1.20908862E-04, 9.06877167E-05,
     8 6.93314047E-05, 5.21706171E-05, 3.86672514E-05, 2.77844799E-05,
     9 2.03112075E-05, 1.39770538E-05, 9.76407481E-06, 6.44553426E-06/
      DATA CJ   9/
     1 4.30987268E-06, 2.91128982E-06, 1.74737828E-06, 9.37977549E-07,
     2 4.52670223E-07, 1.85928420E-07, 4.63683585E-08, 7.62144641E-09,
     3 6.73052396E-10, 4.49123318E-11, 3.10638784E-12, 2.20340597E-13,
     4 1.59242422E-14, 1.87645118E-03, 1.88596108E-03, 1.89330275E-03,
     5 1.90726204E-03, 1.93448596E-03, 1.98883780E-03, 2.13292357E-03,
     6 2.50895650E-03, 2.02160072E-03, 1.64022653E-03, 1.42967762E-03,
     7 1.23180309E-03, 1.08166934E-03, 9.44527713E-04, 7.90233024E-04,
     8 6.64466714E-04, 5.55869126E-04, 4.56912546E-04, 3.69718850E-04,
     9 2.91182454E-04, 2.22414806E-04, 1.66800680E-04, 1.27509362E-04/
      DATA CJ  10/
     1 9.59420089E-05, 7.11054588E-05, 5.10907704E-05, 3.73475053E-05,
     2 2.56997018E-05, 1.79528489E-05, 1.18509126E-05, 7.92410065E-06,
     3 5.35260374E-06, 3.21262703E-06, 1.72448625E-06, 8.32230538E-07,
     4 3.41823776E-07, 8.52456611E-08, 1.40114383E-08, 1.23734148E-09,
     5 8.25663209E-11, 5.71071794E-12, 4.05067958E-13, 2.92745938E-14,
     6 3.05596719E-03, 3.06538575E-03, 3.07256282E-03, 3.08598245E-03,
     7 3.11130067E-03, 3.15877521E-03, 3.25098448E-03, 3.51262193E-03,
     8 4.18929514E-03, 3.32802567E-03, 2.66019873E-03, 2.26255825E-03,
     9 1.97241133E-03, 1.71470116E-03, 1.42979273E-03, 1.19998887E-03/
      DATA CJ  11/
     1 1.00267078E-03, 8.23483583E-04, 6.65943148E-04, 5.24251321E-04,
     2 4.00308105E-04, 3.00140478E-04, 2.29403448E-04, 1.72588821E-04,
     3 1.27898063E-04, 9.18898504E-05, 6.71676646E-05, 4.62170248E-05,
     4 3.22840871E-05, 2.13103008E-05, 1.42486670E-05, 9.62450663E-06,
     5 5.77646456E-06, 3.10063265E-06, 1.49631817E-06, 6.14572206E-07,
     6 1.53261121E-07, 2.51902665E-08, 2.22449327E-09, 1.48435657E-10,
     7 1.02664851E-11, 7.28208746E-13, 5.26279611E-14, 4.58905399E-03,
     8 4.59800329E-03, 4.60477562E-03, 4.61732873E-03, 4.64062203E-03,
     9 4.68292875E-03, 4.76051134E-03, 4.92176307E-03, 5.38442458E-03/
      DATA CJ  12/
     1 6.54922376E-03, 5.03719066E-03, 3.84919968E-03, 3.34188459E-03,
     2 2.88688750E-03, 2.39518284E-03, 2.00456361E-03, 1.67194936E-03,
     3 1.37143155E-03, 1.10808371E-03, 8.71743749E-04, 6.65317431E-04,
     4 4.98659080E-04, 3.81044905E-04, 2.86621113E-04, 2.12371138E-04,
     5 1.52561656E-04, 1.11506092E-04, 7.67190760E-05, 5.35872980E-05,
     6 3.53701589E-05, 2.36483834E-05, 1.59731092E-05, 9.58640571E-06,
     7 5.14549598E-06, 2.48305034E-06, 1.01981189E-06, 2.54309643E-07,
     8 4.17973884E-08, 3.69092105E-09, 2.46281967E-10, 1.70337329E-11,
     9 1.20820145E-12, 8.73165412E-14, 7.63344239E-03, 7.64265143E-03/
      DATA CJ  13/
     1 7.64959272E-03, 7.66239614E-03, 7.68593738E-03, 7.72797518E-03,
     2 7.80267307E-03, 7.94918588E-03, 8.25219168E-03, 9.08595967E-03,
     3 1.11718179E-02, 8.50948584E-03, 6.67067668E-03, 5.66624413E-03,
     4 4.63749691E-03, 3.85370081E-03, 3.20032500E-03, 2.61728999E-03,
     5 2.11034644E-03, 1.65770792E-03, 1.26373000E-03, 9.46397409E-04,
     6 7.22788157E-04, 5.43449520E-04, 4.02532513E-04, 2.89087221E-04,
     7 2.11247909E-04, 1.45315957E-04, 1.01486491E-04, 6.69768382E-05,
     8 4.47757942E-05, 3.02408867E-05, 1.81477045E-05, 9.73991532E-06,
     9 4.69979281E-06, 1.93010363E-06, 4.81267394E-07, 7.90933701E-08/
      DATA CJ  14/
     1 6.98388223E-09, 4.65986964E-10, 3.22282472E-11, 2.28589265E-12,
     2 1.65198131E-13, 1.06716479E-02, 1.06801444E-02, 1.06865355E-02,
     3 1.06982944E-02, 1.07198145E-02, 1.07579188E-02, 1.08245983E-02,
     4 1.09515714E-02, 1.11999257E-02, 1.16984658E-02, 1.30537716E-02,
     5 1.64947744E-02, 1.24602153E-02, 9.56746194E-03, 7.64827637E-03,
     6 6.27825452E-03, 5.17676322E-03, 4.21361197E-03, 3.38651398E-03,
     7 2.65388823E-03, 2.01962478E-03, 1.51059058E-03, 1.15272726E-03,
     8 8.66154710E-04, 6.41233882E-04, 4.60319778E-04, 3.36269473E-04,
     9 2.31249862E-04, 1.61465725E-04, 1.06538851E-04, 7.12127109E-05/
      DATA CJ  15/
     1 4.80898278E-05, 2.88550145E-05, 1.54845115E-05, 7.47082608E-06,
     2 3.06775966E-06, 7.64841497E-07, 1.25682795E-07, 1.10965833E-08,
     3 7.40345596E-10, 5.12006967E-11, 3.63144429E-12, 2.62432019E-13,
     4 1.24208536E-02, 1.24277306E-02, 1.24328975E-02, 1.24423905E-02,
     5 1.24597184E-02, 1.24902550E-02, 1.25432456E-02, 1.26425720E-02,
     6 1.28308312E-02, 1.31867664E-02, 1.38836281E-02, 1.61371087E-02,
     7 2.09342998E-02, 1.50640284E-02, 1.04396460E-02, 8.52366488E-03,
     8 6.96923411E-03, 5.63914478E-03, 4.51383247E-03, 3.52682352E-03,
     9 2.67803436E-03, 1.99989867E-03, 1.52453504E-03, 1.14460280E-03/
      DATA CJ  16/
     1 8.46833440E-04, 6.07587365E-04, 4.43675885E-04, 3.05000337E-04,
     2 2.12901324E-04, 1.40441165E-04, 9.38549059E-05, 6.33698772E-05,
     3 3.80168928E-05, 2.03976823E-05, 9.83979455E-06, 4.03995811E-06,
     4 1.00706369E-06, 1.65462426E-07, 1.46069081E-08, 9.74459366E-10,
     5 6.73872941E-11, 4.77927345E-12, 3.45369833E-13, 1.94810935E-02,
     6 1.94886657E-02, 1.94943513E-02, 1.95047890E-02, 1.95238140E-02,
     7 1.95572554E-02, 1.96150267E-02, 1.97224258E-02, 1.99228219E-02,
     8 2.02906364E-02, 2.09790973E-02, 2.24766315E-02, 2.59060675E-02,
     9 3.37894606E-02, 2.36650522E-02, 1.67865205E-02, 1.34852146E-02/
      DATA CJ  17/
     1 1.07554640E-02, 8.52894896E-03, 6.62031125E-03, 5.00327821E-03,
     2 3.72392321E-03, 2.83262704E-03, 2.12313739E-03, 1.56873156E-03,
     3 1.12430016E-03, 8.20332823E-04, 5.63506593E-04, 3.93125304E-04,
     4 2.59191151E-04, 1.73143499E-04, 1.16866620E-04, 7.00863842E-05,
     5 3.75917115E-05, 1.81285895E-05, 7.44097441E-06, 1.85425078E-06,
     6 3.04569192E-07, 2.68803496E-08, 1.79291701E-09, 1.23970942E-10,
     7 8.79152445E-12, 6.35267562E-13, 2.68144794E-02, 2.68220282E-02,
     8 2.68276939E-02, 2.68380900E-02, 2.68570222E-02, 2.68902478E-02,
     9 2.69474868E-02, 2.70533594E-02, 2.72490323E-02, 2.76017887E-02/
      DATA CJ  18/
     1 2.82397420E-02, 2.95368461E-02, 3.16415686E-02, 3.66967999E-02,
     2 4.98810707E-02, 3.43114781E-02, 2.40016204E-02, 1.87161429E-02,
     3 1.45996143E-02, 1.12081149E-02, 8.40567489E-03, 6.22335553E-03,
     4 4.71782027E-03, 3.52695811E-03, 2.60069160E-03, 1.86076446E-03,
     5 1.35601978E-03, 9.30420718E-04, 6.48541490E-04, 4.27250986E-04,
     6 2.85234445E-04, 1.92429775E-04, 1.15342167E-04, 6.18339132E-05,
     7 2.98055973E-05, 1.22285626E-05, 3.04580008E-06, 5.00070384E-07,
     8 4.41179135E-08, 2.94184605E-09, 2.03375111E-10, 1.44205805E-11,
     9 1.04191002E-12, 2.93105845E-02, 2.93166665E-02, 2.93212301E-02/
      DATA CJ  19/
     1 2.93296012E-02, 2.93448369E-02, 2.93715472E-02, 2.94174786E-02,
     2 2.95021568E-02, 2.96577012E-02, 2.99349550E-02, 3.04259264E-02,
     3 3.13820917E-02, 3.28196439E-02, 3.52993354E-02, 4.37293513E-02,
     4 6.16813834E-02, 4.10710605E-02, 2.73272861E-02, 2.08412122E-02,
     5 1.57078159E-02, 1.16349995E-02, 8.54306269E-03, 6.44256291E-03,
     6 4.79727031E-03, 3.52654009E-03, 2.51682379E-03, 1.83075442E-03,
     7 1.25402197E-03, 8.72988704E-04, 5.74439671E-04, 3.83149531E-04,
     8 2.58298944E-04, 1.54704606E-04, 8.28739739E-05, 3.99203092E-05,
     9 1.63679751E-05, 4.07388548E-06, 6.68441342E-07, 5.89393441E-08/
      DATA CJ  20/
     1 3.92856743E-09, 2.71514068E-10, 1.92482164E-11, 1.39050368E-12,
     2 3.38719415E-02, 3.38774427E-02, 3.38815700E-02, 3.38891395E-02,
     3 3.39029120E-02, 3.39270440E-02, 3.39685030E-02, 3.40448073E-02,
     4 3.41845344E-02, 3.44321947E-02, 3.48663543E-02, 3.56957363E-02,
     5 3.69034406E-02, 3.89082216E-02, 4.34786937E-02, 5.48837934E-02,
     6 7.92311401E-02, 5.11201902E-02, 3.29130965E-02, 2.41709942E-02,
     7 1.75449024E-02, 1.27168996E-02, 9.51480609E-03, 7.04353074E-03,
     8 5.15471899E-03, 3.66546818E-03, 2.65931636E-03, 1.81718603E-03,
     9 1.26276077E-03, 8.29549046E-04, 5.52603530E-04, 3.72158022E-04/
      DATA CJ  21/
     1 2.22659715E-04, 1.19153630E-04, 5.73421433E-05, 2.34905250E-05,
     2 5.84084847E-06, 9.57527717E-07, 8.43647141E-08, 5.62015093E-09,
     3 3.88277143E-10, 2.75182611E-11, 1.98752421E-12, 3.78705822E-02,
     4 3.78755493E-02, 3.78792755E-02, 3.78861088E-02, 3.78985392E-02,
     5 3.79203122E-02, 3.79576958E-02, 3.80264251E-02, 3.81520308E-02,
     6 3.83738644E-02, 3.87602803E-02, 3.94896661E-02, 4.05309718E-02,
     7 4.22050142E-02, 4.58079989E-02, 5.18680175E-02, 6.69949177E-02,
     8 9.99650283E-02, 6.22151021E-02, 3.79264661E-02, 2.68360813E-02,
     9 1.90636001E-02, 1.40947336E-02, 1.03444628E-02, 7.52188726E-03/
      DATA CJ  22/
     1 5.32118372E-03, 3.84637814E-03, 2.61953759E-03, 1.81578530E-03,
     2 1.19014956E-03, 7.91436695E-04, 5.32265138E-04, 3.17985329E-04,
     3 1.69927045E-04, 8.16723406E-05, 3.34177509E-05, 8.29812235E-06,
     4 1.35876813E-06, 1.19593740E-07, 7.96107135E-09, 5.49724892E-10,
     5 3.89462240E-11, 2.81213504E-12, 4.07045732E-02, 4.07089796E-02,
     6 4.07122849E-02, 4.07183460E-02, 4.07293704E-02, 4.07486759E-02,
     7 4.07818096E-02, 4.08426810E-02, 4.09537773E-02, 4.11495151E-02,
     8 4.14890357E-02, 4.21248963E-02, 4.30212543E-02, 4.44338295E-02,
     9 4.73542676E-02, 5.19486346E-02, 5.96595030E-02, 8.00440021E-02/
      DATA CJ  23/
     1 1.23805652E-01, 7.36099127E-02, 4.22094370E-02, 2.93020252E-02,
     2 2.12632345E-02, 1.53999160E-02, 1.10899988E-02, 7.78581980E-03,
     3 5.59792888E-03, 3.79408528E-03, 2.62063726E-03, 1.71219569E-03,
     4 1.13580719E-03, 7.62385553E-04, 4.54536615E-04, 2.42425104E-04,
     5 1.16311835E-04, 4.75131868E-05, 1.17765788E-05, 1.92524640E-06,
     6 1.69215319E-07, 1.12528107E-08, 7.76489372E-10, 5.49843371E-11,
     7 3.96867843E-12, 4.32342833E-02, 4.32382374E-02, 4.32412033E-02,
     8 4.32466417E-02, 4.32565325E-02, 4.32738504E-02, 4.33035646E-02,
     9 4.33581273E-02, 4.34576211E-02, 4.36326376E-02, 4.39353696E-02/
      DATA CJ  24/
     1 4.44994366E-02, 4.52881489E-02, 4.65156962E-02, 4.89934064E-02,
     2 5.27270383E-02, 5.86246340E-02, 6.89792766E-02, 9.55178919E-02,
     3 1.53805931E-01, 8.72665990E-02, 4.81287151E-02, 3.42518696E-02,
     4 2.42867642E-02, 1.72256496E-02, 1.19534085E-02, 8.52602534E-03,
     5 5.73789848E-03, 3.94296355E-03, 2.56435298E-03, 1.69519482E-03,
     6 1.13475697E-03, 6.74616532E-04, 3.58827677E-04, 1.71739540E-04,
     7 6.99968308E-05, 1.73056589E-05, 2.82293429E-06, 2.47641764E-07,
     8 1.64454429E-08, 1.13374274E-09, 8.02278537E-11, 5.78776151E-12,
     9 4.32087632E-02, 4.32121598E-02, 4.32147075E-02, 4.32193789E-02/
      DATA CJ  25/
     1 4.32278743E-02, 4.32427472E-02, 4.32682614E-02, 4.33150958E-02,
     2 4.34004438E-02, 4.35504092E-02, 4.38093044E-02, 4.42899816E-02,
     3 4.49583505E-02, 4.59898809E-02, 4.80394281E-02, 5.10451508E-02,
     4 5.55906118E-02, 6.30744680E-02, 7.57836932E-02, 1.10123496E-01,
     5 1.85653774E-01, 1.03646665E-01, 5.94714146E-02, 4.05637117E-02,
     6 2.79429568E-02, 1.89929637E-02, 1.33657202E-02, 8.89196126E-03,
     7 6.06091784E-03, 3.91386910E-03, 2.57362900E-03, 1.71569689E-03,
     8 1.01565207E-03, 5.38061069E-04, 2.56602824E-04, 1.04242060E-04,
     9 2.56787686E-05, 4.17562098E-06, 3.65311742E-07, 2.42123395E-08/
      DATA CJ  26/
     1 1.66699275E-09, 1.17850743E-10, 8.49584676E-12, 3.61991027E-02,
     2 3.62016216E-02, 3.62035109E-02, 3.62069750E-02, 3.62132746E-02,
     3 3.62243025E-02, 3.62432184E-02, 3.62779330E-02, 3.63411687E-02,
     4 3.64521995E-02, 3.66436361E-02, 3.69982490E-02, 3.74895600E-02,
     5 3.82437785E-02, 3.97276968E-02, 4.18684883E-02, 4.50254746E-02,
     6 5.00133841E-02, 5.80103385E-02, 7.21340556E-02, 1.13025502E-01,
     7 1.99418938E-01, 1.09586908E-01, 5.94793914E-02, 3.95984015E-02,
     8 2.61425920E-02, 1.80656790E-02, 1.18401639E-02, 7.98800065E-03,
     9 5.11311185E-03, 3.34058255E-03, 2.21597730E-03, 1.30517128E-03/
      DATA CJ  27/
     1 6.88176910E-04, 3.26823531E-04, 1.32263645E-04, 3.24455102E-05,
     2 5.25702999E-06, 4.58502450E-07, 3.03218082E-08, 2.08452552E-09,
     3 1.47211698E-10, 1.06039398E-11, 2.93072216E-02, 2.93090679E-02,
     4 2.93104528E-02, 2.93129919E-02, 2.93176092E-02, 2.93256917E-02,
     5 2.93395542E-02, 2.93649910E-02, 2.94113137E-02, 2.94926082E-02,
     6 2.96326546E-02, 2.98916735E-02, 3.02496816E-02, 3.07973230E-02,
     7 3.18679302E-02, 3.33963795E-02, 3.56156824E-02, 3.90380654E-02,
     8 4.43148129E-02, 5.31920594E-02, 6.91640591E-02, 1.16575775E-01,
     9 2.09934433E-01, 1.12013093E-01, 5.82642687E-02, 3.70523334E-02/
      DATA CJ  28/
     1 2.49076025E-02, 1.59750451E-02, 1.06254412E-02, 6.72152469E-03,
     2 4.35445309E-03, 2.87016476E-03, 1.67963537E-03, 8.80394242E-04,
     3 4.15953076E-04, 1.67551113E-04, 4.08940875E-05, 6.59741042E-06,
     4 5.73294937E-07, 3.78143135E-08, 2.59506766E-09, 1.83037178E-10,
     5 1.31720886E-11, 2.56383409E-02, 2.56398398E-02, 2.56409641E-02,
     6 2.56430254E-02, 2.56467737E-02, 2.56533350E-02, 2.56645878E-02,
     7 2.56852340E-02, 2.57228259E-02, 2.57887774E-02, 2.59023307E-02,
     8 2.61121441E-02, 2.64017019E-02, 2.68436483E-02, 2.77041846E-02,
     9 2.89248481E-02, 3.06808077E-02, 3.33507344E-02, 3.73782881E-02/
      DATA CJ  29/
     1 4.39205671E-02, 5.52858594E-02, 7.56826005E-02, 1.25832006E-01,
     2 2.30642137E-01, 1.18332498E-01, 5.71643469E-02, 3.76047112E-02,
     3 2.34557191E-02, 1.53226318E-02, 9.55330997E-03, 6.12663729E-03,
     4 4.00811123E-03, 2.32818065E-03, 1.21213576E-03, 5.69369511E-04,
     5 2.28164697E-04, 5.53788075E-05, 8.89242600E-06, 7.69668743E-07,
     6 5.06251462E-08, 3.46775995E-09, 2.44264908E-10, 1.75607129E-11,
     7 2.22761665E-02, 2.22773802E-02, 2.22782905E-02, 2.22799595E-02,
     8 2.22829944E-02, 2.22883068E-02, 2.22974173E-02, 2.23141315E-02,
     9 2.23445596E-02, 2.23979289E-02, 2.24897765E-02, 2.26593445E-02/
      DATA CJ  30/
     1 2.28930634E-02, 2.32491203E-02, 2.39401206E-02, 2.49151104E-02,
     2 2.63070342E-02, 2.83995587E-02, 3.15019911E-02, 3.64043040E-02,
     3 4.45264732E-02, 5.81378958E-02, 7.88629990E-02, 1.36137259E-01,
     4 2.57211631E-01, 1.30192772E-01, 6.63608831E-02, 3.93311909E-02,
     5 2.48502333E-02, 1.51148435E-02, 9.53662310E-03, 6.16693160E-03,
     6 3.54233209E-03, 1.82616568E-03, 8.50690362E-04, 3.38428996E-04,
     7 8.15126391E-05, 1.30057303E-05, 1.11972018E-06, 7.33764515E-08,
     8 5.01384071E-09, 3.52551166E-10, 2.53124541E-11, 1.72345593E-02,
     9 1.72354470E-02, 1.72361127E-02, 1.72373334E-02, 1.72395531E-02/
      DATA CJ  31/
     1 1.72434383E-02, 1.72501011E-02, 1.72623239E-02, 1.72845732E-02,
     2 1.73235899E-02, 1.73907151E-02, 1.75145682E-02, 1.76851231E-02,
     3 1.79446101E-02, 1.84470178E-02, 1.91532719E-02, 2.01562308E-02,
     4 2.16523609E-02, 2.38450945E-02, 2.72488293E-02, 3.27267114E-02,
     5 4.14736368E-02, 5.40800824E-02, 7.55433816E-02, 1.36071502E-01,
     6 2.66937747E-01, 1.30878244E-01, 5.70704857E-02, 3.54810703E-02,
     7 2.10071223E-02, 1.30176391E-02, 8.31203265E-03, 4.71755468E-03,
     8 2.40684877E-03, 1.11154500E-03, 4.38918146E-04, 1.04896063E-04,
     9 1.66302014E-05, 1.42423313E-06, 9.29901017E-08, 6.33873136E-09/
      DATA CJ  32/
     1 4.44949458E-10, 3.19056755E-11, 1.37799601E-02, 1.37806330E-02,
     2 1.37811376E-02, 1.37820629E-02, 1.37837454E-02, 1.37866904E-02,
     3 1.37917405E-02, 1.38010045E-02, 1.38178664E-02, 1.38474308E-02,
     4 1.38982799E-02, 1.39920548E-02, 1.41210902E-02, 1.43171872E-02,
     5 1.46961074E-02, 1.52270987E-02, 1.59778404E-02, 1.70905750E-02,
     6 1.87061758E-02, 2.11789725E-02, 2.50716330E-02, 3.10732443E-02,
     7 3.92866830E-02, 5.24646620E-02, 7.45948113E-02, 1.44921051E-01,
     8 2.88593785E-01, 1.37313825E-01, 6.35764233E-02, 3.58313861E-02,
     9 2.14391887E-02, 1.33813743E-02, 7.44208358E-03, 3.73383866E-03/
      DATA CJ  33/
     1 1.70148693E-03, 6.64396181E-04, 1.56988946E-04, 2.46638190E-05,
     2 2.09672615E-06, 1.36208322E-07, 9.25417471E-09, 6.48092636E-10,
     3 4.63921497E-11, 1.10836014E-02, 1.10841214E-02, 1.10845115E-02,
     4 1.10852267E-02, 1.10865271E-02, 1.10888033E-02, 1.10927065E-02,
     5 1.10998664E-02, 1.11128976E-02, 1.11357432E-02, 1.11750288E-02,
     6 1.12474539E-02, 1.13470595E-02, 1.14983165E-02, 1.17902001E-02,
     7 1.21983629E-02, 1.27737467E-02, 1.36229698E-02, 1.48484789E-02,
     8 1.67074935E-02, 1.95944437E-02, 2.39552086E-02, 2.97559740E-02,
     9 3.86981296E-02, 5.32679383E-02, 8.05305435E-02, 1.50256705E-01/
      DATA CJ  34/
     1 3.10028330E-01, 1.43359269E-01, 5.79514507E-02, 3.41359790E-02,
     2 2.07888262E-02, 1.13072749E-02, 5.57200234E-03, 2.50380051E-03,
     3 9.66527996E-04, 2.25785061E-04, 3.51550992E-05, 2.96723592E-06,
     4 1.91823036E-07, 1.29916830E-08, 9.07829318E-10, 6.48783939E-11,
     5 8.05345169E-03, 8.05381410E-03, 8.05408592E-03, 8.05458428E-03,
     6 8.05549048E-03, 8.05707659E-03, 8.05979643E-03, 8.06478541E-03,
     7 8.07386492E-03, 8.08978091E-03, 8.11714522E-03, 8.16757597E-03,
     8 8.23689741E-03, 8.34208772E-03, 8.54480995E-03, 8.82771009E-03,
     9 9.22537505E-03, 9.80990903E-03, 1.06485399E-02, 1.19099547E-02/
      DATA CJ  35/
     1 1.38442261E-02, 1.67118796E-02, 2.04310483E-02, 2.59634497E-02,
     2 3.44927631E-02, 4.92459652E-02, 7.17143792E-02, 1.53427244E-01,
     3 3.26514616E-01, 1.45742764E-01, 6.13074379E-02, 3.60649980E-02,
     4 1.88174151E-02, 8.98850140E-03, 3.94809638E-03, 1.49719844E-03,
     5 3.43850572E-04, 5.28497905E-05, 4.41591581E-06, 2.83561601E-07,
     6 1.91222769E-08, 1.33221545E-09, 9.49969176E-11, 6.23899214E-03,
     7 6.23926423E-03, 6.23946831E-03, 6.23984247E-03, 6.24052283E-03,
     8 6.24171365E-03, 6.24375562E-03, 6.24750111E-03, 6.25431728E-03,
     9 6.26626487E-03, 6.28680368E-03, 6.32464677E-03, 6.37664705E-03/
      DATA CJ  36/
     1 6.45551338E-03, 6.60736780E-03, 6.81898452E-03, 7.11587158E-03,
     2 7.55107120E-03, 8.17302480E-03, 9.10333057E-03, 1.05183121E-02,
     3 1.25918504E-02, 1.52408962E-02, 1.91039365E-02, 2.48947623E-02,
     4 3.45085256E-02, 4.88880645E-02, 7.83625393E-02, 1.60081234E-01,
     5 3.50633150E-01, 1.58268933E-01, 6.90948156E-02, 3.39747806E-02,
     6 1.55020551E-02, 6.60454805E-03, 2.44930269E-03, 5.51214534E-04,
     7 8.34758490E-05, 6.89702873E-06, 4.39648683E-07, 2.95110464E-08,
     8 2.04941162E-09, 1.45796071E-10, 3.86282087E-03, 3.86298440E-03,
     9 3.86310704E-03, 3.86333191E-03, 3.86374079E-03, 3.86445644E-03/
      DATA CJ  37/
     1 3.86568359E-03, 3.86793446E-03, 3.87203051E-03, 3.87920970E-03,
     2 3.89154986E-03, 3.91428208E-03, 3.94550854E-03, 3.99284634E-03,
     3 4.08391991E-03, 4.21067527E-03, 4.38819654E-03, 4.64778015E-03,
     4 5.01747072E-03, 5.56772337E-03, 6.39868712E-03, 7.60416847E-03,
     5 9.12449772E-03, 1.13047814E-02, 1.44977905E-02, 1.96168808E-02,
     6 2.68935185E-02, 4.08571483E-02, 6.32813848E-02, 1.50625472E-01,
     7 3.39572661E-01, 1.48214255E-01, 4.93249265E-02, 2.20913623E-02,
     8 9.10755191E-03, 3.29653797E-03, 7.26006984E-04, 1.08260881E-04,
     9 8.84251505E-06, 5.59498831E-07, 3.73815783E-08, 2.58770380E-09/
      DATA CJ  38/
     1 1.83661677E-10, 2.98227701E-03, 2.98240025E-03, 2.98249267E-03,
     2 2.98266213E-03, 2.98297027E-03, 2.98350958E-03, 2.98443436E-03,
     3 2.98613057E-03, 2.98921719E-03, 2.99462686E-03, 3.00392462E-03,
     4 3.02104965E-03, 3.04456802E-03, 3.08020825E-03, 3.14873479E-03,
     5 3.24401847E-03, 3.37728863E-03, 3.57180598E-03, 3.84811665E-03,
     6 4.25788866E-03, 4.87350005E-03, 5.76017191E-03, 6.86845602E-03,
     7 8.44008711E-03, 1.07075673E-02, 1.42674113E-02, 1.91878660E-02,
     8 2.82561307E-02, 4.26527329E-02, 7.23734657E-02, 1.66053959E-01,
     9 3.70990169E-01, 1.46316337E-01, 4.02698622E-02, 1.66654154E-02/
      DATA CJ  39/
     1 5.85171602E-03, 1.25355455E-03, 1.83368213E-04, 1.47698909E-05,
     2 9.26359877E-07, 6.15562975E-08, 4.24539926E-09, 3.00506659E-10,
     3 2.45811060E-03, 2.45820983E-03, 2.45828425E-03, 2.45842070E-03,
     4 2.45866882E-03, 2.45910309E-03, 2.45984773E-03, 2.46121352E-03,
     5 2.46369880E-03, 2.46805437E-03, 2.47553979E-03, 2.48932478E-03,
     6 2.50825196E-03, 2.53692541E-03, 2.59202576E-03, 2.66857395E-03,
     7 2.77551117E-03, 2.93133156E-03, 3.15215542E-03, 3.47856747E-03,
     8 3.96667106E-03, 4.66523184E-03, 5.53158490E-03, 6.74834637E-03,
     9 8.48186839E-03, 1.11569348E-02, 1.47721717E-02, 2.12195479E-02/
      DATA CJ  40/
     1 3.09773686E-02, 5.02403557E-02, 8.47913144E-02, 1.81191796E-01,
     2 4.35742447E-01, 1.57375913E-01, 3.77857605E-02, 1.33290042E-02,
     3 2.74149053E-03, 3.89957840E-04, 3.08028604E-05, 1.90892638E-06,
     4 1.25926537E-07, 8.64237466E-09, 6.09587246E-10, 1.59785166E-03,
     5 1.59791453E-03, 1.59796168E-03, 1.59804813E-03, 1.59820532E-03,
     6 1.59848045E-03, 1.59895221E-03, 1.59981747E-03, 1.60139193E-03,
     7 1.60415109E-03, 1.60889254E-03, 1.61762298E-03, 1.62960733E-03,
     8 1.64775671E-03, 1.68261296E-03, 1.73099274E-03, 1.79849426E-03,
     9 1.89667977E-03, 2.03548663E-03, 2.23996953E-03, 2.54428747E-03/
      DATA CJ  41/
     1 2.97700375E-03, 3.50944290E-03, 4.25010023E-03, 5.29241140E-03,
     2 6.87457470E-03, 8.96846856E-03, 1.25938324E-02, 1.78542716E-02,
     3 2.75754555E-02, 4.35335831E-02, 6.96112838E-02, 1.80490484E-01,
     4 4.82704032E-01, 1.61597899E-01, 3.14210153E-02, 6.39612290E-03,
     5 8.71749067E-04, 6.68968138E-05, 4.07529713E-06, 2.66109955E-07,
     6 1.81401024E-08, 1.27335576E-09, 9.13895040E-04, 9.13930152E-04,
     7 9.13956486E-04, 9.14004768E-04, 9.14092560E-04, 9.14246216E-04,
     8 9.14509689E-04, 9.14992926E-04, 9.15872212E-04, 9.17413055E-04,
     9 9.20060708E-04, 9.24935178E-04, 9.31625042E-04, 9.41753339E-04/
      DATA CJ  42/
     1 9.61194906E-04, 9.88157859E-04, 1.02573661E-03, 1.08031414E-03,
     2 1.15730888E-03, 1.27040239E-03, 1.43802604E-03, 1.67507093E-03,
     3 1.96483346E-03, 2.36475676E-03, 2.92202864E-03, 3.75712891E-03,
     4 4.84501549E-03, 6.68905982E-03, 9.29025396E-03, 1.39090077E-02,
     5 2.10834728E-02, 3.24306164E-02, 5.78278590E-02, 1.79391487E-01,
     6 5.25453937E-01, 1.48969451E-01, 7.12696350E-03, 1.60875816E-03,
     7 1.26599544E-04, 7.71608101E-06, 5.02732802E-07, 3.41952527E-08,
     8 2.39594123E-09, 5.13463168E-04, 5.13482434E-04, 5.13496884E-04,
     9 5.13523377E-04, 5.13571550E-04, 5.13655863E-04, 5.13800434E-04/
      DATA CJ  43/
     1 5.14065587E-04, 5.14548042E-04, 5.15393454E-04, 5.16846035E-04,
     2 5.19519981E-04, 5.23189081E-04, 5.28742473E-04, 5.39397236E-04,
     3 5.54162986E-04, 5.74721309E-04, 6.04536894E-04, 6.46516805E-04,
     4 7.08013039E-04, 7.98821169E-04, 9.26601769E-04, 1.08188455E-03,
     5 1.29472397E-03, 1.58878219E-03, 2.02468563E-03, 2.58522337E-03,
     6 3.51958611E-03, 4.80979190E-03, 7.03675174E-03, 1.03698638E-02,
     7 1.54127709E-02, 2.65454282E-02, 5.23789497E-02, 1.85114913E-01,
     8 6.14272689E-01, 1.31788475E-01,-5.07506631E-04, 3.56621382E-04,
     9 2.34332842E-05, 1.54943305E-06, 1.05811807E-07, 7.42101112E-09/
      DATA CJ  44/
     1 2.16926351E-04, 2.16934307E-04, 2.16940274E-04, 2.16951215E-04,
     2 2.16971108E-04, 2.17005925E-04, 2.17065625E-04, 2.17175119E-04,
     3 2.17374342E-04, 2.17723430E-04, 2.18323192E-04, 2.19427122E-04,
     4 2.20941634E-04, 2.23233355E-04, 2.27628323E-04, 2.33714877E-04,
     5 2.42181308E-04, 2.54444296E-04, 2.71679859E-04, 2.96866923E-04,
     6 3.33935009E-04, 3.85865648E-04, 4.48647359E-04, 5.34182709E-04,
     7 6.51494899E-04, 8.23810075E-04, 1.04303235E-03, 1.40355998E-03,
     8 1.89317411E-03, 2.72049733E-03, 3.92601880E-03, 5.69311432E-03,
     9 9.42482602E-03, 1.79699471E-02, 3.85691187E-02, 1.65305886E-01/
      DATA CJ  45/
     1 7.12586173E-01, 1.16125715E-01,-9.27852038E-03,-9.73364283E-05,
     2-2.51140046E-06,-7.08946092E-08,-1.33934783E-09, 4.27934297E-05,
     3 4.27949511E-05, 4.27960923E-05, 4.27981844E-05, 4.28019886E-05,
     4 4.28086468E-05, 4.28200632E-05, 4.28410013E-05, 4.28790970E-05,
     5 4.29458468E-05, 4.30605192E-05, 4.32715551E-05, 4.35610149E-05,
     6 4.39988735E-05, 4.48380984E-05, 4.59993015E-05, 4.76125895E-05,
     7 4.99454029E-05, 5.32166317E-05, 5.79820100E-05, 6.49650582E-05,
     8 7.46927056E-05, 8.63754826E-05, 1.02171264E-04, 1.23636362E-04,
     9 1.54807865E-04, 1.93944281E-04, 2.57259964E-04, 3.41546842E-04/
      DATA CJ  46/
     1 4.80449068E-04, 6.76662483E-04, 9.54036876E-04, 1.51001582E-03,
     2 2.67871203E-03, 5.24401095E-03, 8.97290116E-03, 1.37035572E-01,
     3 7.78656505E-01, 9.70826118E-02,-1.09162957E-02,-1.94896605E-04,
     4-8.21793338E-06,-4.33354674E-07, 4.89268618E-06, 4.89285502E-06,
     5 4.89298166E-06, 4.89321384E-06, 4.89363601E-06, 4.89437490E-06,
     6 4.89564182E-06, 4.89796538E-06, 4.90219285E-06, 4.90959974E-06,
     7 4.92232340E-06, 4.94573611E-06, 4.97784272E-06, 5.02639520E-06,
     8 5.11940569E-06, 5.24799833E-06, 5.42646214E-06, 5.68413513E-06,
     9 6.04472391E-06, 6.56855330E-06, 7.33324810E-06, 8.39324366E-06/
      DATA CJ  47/
     1 9.65903481E-06, 1.13593361E-05, 1.36520370E-05, 1.69502309E-05,
     2 2.10471150E-05, 2.75900014E-05, 3.61682422E-05, 5.00482191E-05,
     3 6.92366305E-05, 9.57300603E-05, 1.47227509E-04, 2.50957171E-04,
     4 4.68850060E-04, 9.60463772E-04,-9.41162570E-04, 1.12442752E-01,
     5 8.27483107E-01, 9.33399010E-02,-9.78021236E-03,-1.66965841E-04,
     6-6.80403754E-06,-9.83932073E-08,-9.83972297E-08,-9.84002466E-08,
     7-9.84057778E-08,-9.84158354E-08,-9.84334386E-08,-9.84636229E-08,
     8-9.85189850E-08,-9.86197236E-08,-9.87962657E-08,-9.90996497E-08,
     9-9.96582912E-08,-1.00425187E-07,-1.01586683E-07,-1.03817643E-07/
      DATA CJ  48/
     1-1.06914718E-07,-1.11236740E-07,-1.17524632E-07,-1.26415013E-07,
     2-1.39510428E-07,-1.58986850E-07,-1.86634126E-07,-2.20547285E-07,
     3-2.67482937E-07,-3.32996473E-07,-4.31152233E-07,-5.58626117E-07,
     4-7.73022042E-07,-1.07106748E-06,-1.58698806E-06,-2.35671087E-06,
     5-3.50854578E-06,-5.99057583E-06,-1.17888809E-05,-2.69569256E-05,
     6-7.80646056E-05,-4.75675364E-04,-9.85302696E-03, 9.52489529E-02,
     7 8.34819192E-01, 9.40538961E-02,-9.75525756E-03,-1.65569752E-04,
     8-2.60590716E-08,-2.60600024E-08,-2.60607006E-08,-2.60619806E-08,
     9-2.60643080E-08,-2.60683814E-08,-2.60753660E-08,-2.60881760E-08/
      DATA CJ  49/
     1-2.61114830E-08,-2.61523210E-08,-2.62224788E-08,-2.63515949E-08,
     2-2.65286963E-08,-2.67966019E-08,-2.73101140E-08,-2.80207022E-08,
     3-2.90080546E-08,-3.04359910E-08,-3.24387637E-08,-3.53571296E-08,
     4-3.96351931E-08,-4.55974177E-08,-5.27615474E-08,-6.24530616E-08,
     5-7.56309112E-08,-9.47808894E-08,-1.18841964E-07,-1.57802846E-07,
     6-2.09723976E-07,-2.95412476E-07,-4.16711397E-07,-5.88720583E-07,
     7-9.35676036E-07,-1.67732628E-06,-3.40469579E-06,-8.36208766E-06,
     8-3.66735772E-05,-2.97280704E-04,-1.09915858E-02, 9.27463390E-02,
     9 8.31874183E-01, 9.39772247E-02,-9.75916655E-03,-1.21433306E-09/
      DATA CJ  50/
     1-1.21437592E-09,-1.21440807E-09,-1.21446701E-09,-1.21457418E-09,
     2-1.21476176E-09,-1.21508339E-09,-1.21567326E-09,-1.21674650E-09,
     3-1.21862695E-09,-1.22185740E-09,-1.22780229E-09,-1.23595589E-09,
     4-1.24828859E-09,-1.27192260E-09,-1.30461649E-09,-1.35002457E-09,
     5-1.41565584E-09,-1.50763296E-09,-1.64151023E-09,-1.83746665E-09,
     6-2.11003211E-09,-2.43680651E-09,-2.87773197E-09,-3.47545902E-09,
     7-4.34090389E-09,-5.42383519E-09,-7.16876756E-09,-9.48085809E-09,
     8-1.32707815E-08,-1.85935498E-08,-2.60775219E-08,-4.10071712E-08,
     9-7.24179015E-08,-1.43956009E-07,-3.42506712E-07,-1.40134936E-06/
      DATA CJ  51/
     1-9.70094682E-06,-1.65409793E-04,-9.75158564E-03, 9.41592324E-02,
     2 8.42018552E-01, 2.00443013E-02,-9.09966467E-11,-9.09998056E-11,
     3-9.10021749E-11,-9.10065186E-11,-9.10144169E-11,-9.10282406E-11,
     4-9.10519432E-11,-9.10954140E-11,-9.11745054E-11,-9.13130813E-11,
     5-9.15511324E-11,-9.19891800E-11,-9.25899129E-11,-9.34984102E-11,
     6-9.52389670E-11,-9.76457687E-11,-1.00986696E-10,-1.05811883E-10,
     7-1.12567016E-10,-1.22385705E-10,-1.36730202E-10,-1.56634264E-10,
     8-1.80431063E-10,-2.12441329E-10,-2.55678370E-10,-3.18012771E-10,
     9-3.95642810E-10,-5.20035550E-10,-6.83820118E-10,-9.50336363E-10/
      DATA CJ  52/
     1-1.32157045E-09,-1.83904531E-09,-2.86022274E-09,-4.97692943E-09,
     2-9.70293516E-09,-2.24631475E-08,-8.71919425E-08,-5.48748367E-07,
     3-7.48344600E-06,-1.80376685E-04,-1.01123390E-02, 7.39345544E-02,
     4 9.89887661E-01/
      DATA XTAU/0.,               .000032,.000056,.0001,.00018,.00032,
     1.00056,.001,.0018,.0032,.0056,.01,.016,.025,.042,.065,
     2.096,.139,.196,.273,.375,.5,.63,.78,.95,1.15,1.35,1.6,1.85,2.15,
     32.45,2.75,3.15,3.65,4.25,5.0,6.2,7.8,10.,12.5,15.,17.5,20./
      DATA NXTAU/43/
      END
      BLOCK DATA MHDATA
      IMPLICIT REAL*8 (A-H,O-Z)
      COMMON /HMATX/CH(1849)
      DIMENSION CH   1(36),CH   2(36),CH   3(36),CH   4(36),CH   5(36)
      DIMENSION CH   6(36),CH   7(36),CH   8(36),CH   9(36),CH  10(36)
      DIMENSION CH  11(36),CH  12(36),CH  13(36),CH  14(36),CH  15(36)
      DIMENSION CH  16(36),CH  17(36),CH  18(36),CH  19(36),CH  20(36)
      DIMENSION CH  21(36),CH  22(36),CH  23(36),CH  24(36),CH  25(36)
      DIMENSION CH  26(36),CH  27(36),CH  28(36),CH  29(36),CH  30(36)
      DIMENSION CH  31(36),CH  32(36),CH  33(36),CH  34(36),CH  35(36)
      DIMENSION CH  36(36),CH  37(36),CH  38(36),CH  39(36),CH  40(36)
      DIMENSION CH  41(36),CH  42(36),CH  43(36),CH  44(36),CH  45(36)
      DIMENSION CH  46(36),CH  47(36),CH  48(36),CH  49(36),CH  50(36)
      DIMENSION CH  51(36),CH  52(13)
      EQUIVALENCE (CH   1(1),CH (   1)),(CH   2(1),CH (  37))
      EQUIVALENCE (CH   3(1),CH (  73)),(CH   4(1),CH ( 109))
      EQUIVALENCE (CH   5(1),CH ( 145)),(CH   6(1),CH ( 181))
      EQUIVALENCE (CH   7(1),CH ( 217)),(CH   8(1),CH ( 253))
      EQUIVALENCE (CH   9(1),CH ( 289)),(CH  10(1),CH ( 325))
      EQUIVALENCE (CH  11(1),CH ( 361)),(CH  12(1),CH ( 397))
      EQUIVALENCE (CH  13(1),CH ( 433)),(CH  14(1),CH ( 469))
      EQUIVALENCE (CH  15(1),CH ( 505)),(CH  16(1),CH ( 541))
      EQUIVALENCE (CH  17(1),CH ( 577)),(CH  18(1),CH ( 613))
      EQUIVALENCE (CH  19(1),CH ( 649)),(CH  20(1),CH ( 685))
      EQUIVALENCE (CH  21(1),CH ( 721)),(CH  22(1),CH ( 757))
      EQUIVALENCE (CH  23(1),CH ( 793)),(CH  24(1),CH ( 829))
      EQUIVALENCE (CH  25(1),CH ( 865)),(CH  26(1),CH ( 901))
      EQUIVALENCE (CH  27(1),CH ( 937)),(CH  28(1),CH ( 973))
      EQUIVALENCE (CH  29(1),CH (1009)),(CH  30(1),CH (1045))
      EQUIVALENCE (CH  31(1),CH (1081)),(CH  32(1),CH (1117))
      EQUIVALENCE (CH  33(1),CH (1153)),(CH  34(1),CH (1189))
      EQUIVALENCE (CH  35(1),CH (1225)),(CH  36(1),CH (1261))
      EQUIVALENCE (CH  37(1),CH (1297)),(CH  38(1),CH (1333))
      EQUIVALENCE (CH  39(1),CH (1369)),(CH  40(1),CH (1405))
      EQUIVALENCE (CH  41(1),CH (1441)),(CH  42(1),CH (1477))
      EQUIVALENCE (CH  43(1),CH (1513)),(CH  44(1),CH (1549))
      EQUIVALENCE (CH  45(1),CH (1585)),(CH  46(1),CH (1621))
      EQUIVALENCE (CH  47(1),CH (1657)),(CH  48(1),CH (1693))
      EQUIVALENCE (CH  49(1),CH (1729)),(CH  50(1),CH (1765))
      EQUIVALENCE (CH  51(1),CH (1801)),(CH  52(1),CH (1837))
      DATA CH   1/
     1 7.15468111E-06,-7.63518254E-06,-7.15194190E-06,-7.14908817E-06,
     2-7.14434126E-06,-7.13655915E-06,-7.12412582E-06,-7.10337944E-06,
     3-7.06894113E-06,-7.01450683E-06,-6.93090638E-06,-6.79555793E-06,
     4-6.63291776E-06,-6.41788366E-06,-6.06957067E-06,-5.67267991E-06,
     5-5.22293773E-06,-4.70482715E-06,-4.14396013E-06,-3.53845938E-06,
     6-2.91564752E-06,-2.33731168E-06,-1.88157141E-06,-1.48246502E-06,
     7-1.14445670E-06,-8.53997483E-07,-6.43477679E-07,-4.56544435E-07,
     8-3.26945808E-07,-2.21153320E-07,-1.50877193E-07,-1.03653072E-07,
     9-6.33945709E-08,-3.46862852E-08,-1.70494808E-08,-7.13023297E-09/
      DATA CH   2/
     1-1.81676142E-09,-3.04652954E-10,-2.74072641E-11,-1.85486483E-12,
     2-1.29572640E-13,-9.25877958E-15,-6.72963730E-16, 1.49104109E-05,
     3-3.90201199E-06,-1.61388810E-05,-1.49037775E-05,-1.48935421E-05,
     4-1.48771099E-05,-1.48514527E-05,-1.48079226E-05,-1.47359130E-05,
     5-1.46223031E-05,-1.44479043E-05,-1.41656379E-05,-1.38265136E-05,
     6-1.33781866E-05,-1.26520376E-05,-1.18246559E-05,-1.08871250E-05,
     7-9.80709529E-06,-8.63795420E-06,-7.37578617E-06,-6.07754325E-06,
     8-4.87201699E-06,-3.92204193E-06,-3.09012066E-06,-2.38555751E-06,
     9-1.78010945E-06,-1.34129184E-06,-9.51639673E-07,-6.81498671E-07/
      DATA CH   3/
     1-4.60980408E-07,-3.14494034E-07,-2.16058241E-07,-1.32141902E-07,
     2-7.23012998E-08,-3.55385179E-08,-1.48624949E-08,-3.78691638E-09,
     3-6.35028248E-10,-5.71285479E-11,-3.86633654E-12,-2.70085094E-13,
     4-1.92992751E-14,-1.40274544E-15, 1.52026574E-05, 1.68173785E-05,
     5 4.09890951E-06,-1.75587254E-05,-1.51942778E-05,-1.51773709E-05,
     6-1.51506530E-05,-1.51059123E-05,-1.50322201E-05,-1.49160857E-05,
     7-1.47379368E-05,-1.44497640E-05,-1.41036562E-05,-1.36461842E-05,
     8-1.29053252E-05,-1.20612605E-05,-1.11048794E-05,-1.00031765E-05,
     9-8.81060628E-06,-7.52317033E-06,-6.19895694E-06,-4.96932846E-06/
      DATA CH   4/
     1-4.00036789E-06,-3.15182512E-06,-2.43318816E-06,-1.81564832E-06,
     2-1.36806808E-06,-9.70635957E-07,-6.95101755E-07,-4.70181345E-07,
     3-3.20770911E-07,-2.20370321E-07,-1.34779083E-07,-7.37441757E-08,
     4-3.62477144E-08,-1.51590763E-08,-3.86248133E-09,-6.47699272E-10,
     5-5.82684230E-11,-3.94347888E-12,-2.75473821E-13,-1.96843285E-14,
     6-1.43073233E-15, 2.97896810E-05, 2.97980436E-05, 3.02862105E-05,
     7 5.50647710E-06,-3.39987917E-05,-2.97607355E-05,-2.97074452E-05,
     8-2.96191403E-05,-2.94741216E-05,-2.92456743E-05,-2.88957424E-05,
     9-2.83301186E-05,-2.76510734E-05,-2.67537628E-05,-2.53008644E-05/
      DATA CH   5/
     1-2.36457701E-05,-2.17705777E-05,-1.96105587E-05,-1.72724667E-05,
     2-1.47484513E-05,-1.21523844E-05,-9.74178213E-06,-7.84222059E-06,
     3-6.17873953E-06,-4.76993351E-06,-3.55932255E-06,-2.68189971E-06,
     4-1.90278810E-06,-1.36264217E-06,-9.21718380E-07,-6.28821467E-07,
     5-4.32001343E-07,-2.64212927E-07,-1.44563571E-07,-7.10577364E-08,
     6-2.97168721E-08,-7.57175055E-09,-1.26970521E-09,-1.14225320E-10,
     7-7.73051375E-12,-5.40018920E-13,-3.85877188E-14,-2.80470236E-15,
     8 5.33166565E-05, 5.33305336E-05, 5.33411719E-05, 5.45903541E-05,
     9 9.45344282E-06,-5.98750876E-05,-5.32380787E-05,-5.30767814E-05/
      DATA CH   6/
     1-5.28138232E-05,-5.24019312E-05,-5.17726512E-05,-5.07570460E-05,
     2-4.95388096E-05,-4.79297869E-05,-4.53254263E-05,-4.23593245E-05,
     3-3.89992680E-05,-3.51292236E-05,-3.09404208E-05,-2.64187551E-05,
     4-2.17681883E-05,-1.74499821E-05,-1.40472898E-05,-1.10675313E-05,
     5-8.54399479E-06,-6.37549656E-06,-4.80383043E-06,-3.40827054E-06,
     6-2.44075547E-06,-1.65097143E-06,-1.12633544E-06,-7.73792885E-07,
     7-4.73252449E-07,-2.58938632E-07,-1.27276602E-07,-5.32279265E-08,
     8-1.35622540E-08,-2.27424725E-09,-2.04595667E-10,-1.38465591E-11,
     9-9.67257493E-13,-6.91165342E-14,-5.02365045E-15, 9.11154271E-05/
      DATA CH   7/
     1 9.11373857E-05, 9.11540613E-05, 9.11851613E-05, 9.35975905E-05,
     2 1.47063981E-05,-1.03462545E-04,-9.08852056E-05,-9.04268240E-05,
     3-8.97143108E-05,-8.86303376E-05,-8.68853571E-05,-8.47952605E-05,
     4-8.20369956E-05,-7.75751291E-05,-7.24955321E-05,-6.67426582E-05,
     5-6.01176981E-05,-5.29478997E-05,-4.52090066E-05,-3.72500018E-05,
     6-2.98601473E-05,-2.40372258E-05,-1.89381774E-05,-1.46199094E-05,
     7-1.09092379E-05,-8.21988044E-06,-5.83189075E-06,-4.17635691E-06,
     8-2.82495145E-06,-1.92724820E-06,-1.32401640E-06,-8.09767079E-07,
     9-4.43060175E-07,-2.17777566E-07,-9.10757716E-08,-2.32056491E-08/
      DATA CH   8/
     1-3.89133110E-09,-3.50070669E-10,-2.36919192E-11,-1.65500706E-12,
     2-1.18260370E-13,-8.59560278E-15, 1.61084638E-04, 1.61120455E-04,
     3 1.61147523E-04, 1.61197627E-04, 1.61290471E-04, 1.65663480E-04,
     4 3.12833419E-05,-1.84767459E-04,-1.60383513E-04,-1.59095624E-04,
     5-1.57151776E-04,-1.54037375E-04,-1.50316852E-04,-1.45414273E-04,
     6-1.37492118E-04,-1.28479528E-04,-1.18276734E-04,-1.06530685E-04,
     7-9.38212441E-05,-8.01050512E-05,-6.60003185E-05,-5.29053047E-05,
     8-4.25875346E-05,-3.35527875E-05,-2.59017163E-05,-1.93273550E-05,
     9-1.45626021E-05,-1.03318579E-05,-7.39883160E-06,-5.00464369E-06/
      DATA CH   9/
     1-3.41426413E-06,-2.34558186E-06,-1.43454739E-06,-7.84901321E-07,
     2-3.85800856E-07,-1.61343209E-07,-4.11091944E-08,-6.89352042E-09,
     3-6.20149585E-10,-4.19700385E-11,-2.93182374E-12,-2.09496329E-13,
     4-1.52269488E-14, 2.95118055E-04, 2.95178254E-04, 2.95223603E-04,
     5 2.95307214E-04, 2.95460869E-04, 2.95735398E-04, 3.02765668E-04,
     6 5.58676946E-05,-3.37573853E-04,-2.93054976E-04,-2.89397455E-04,
     7-2.83590510E-04,-2.76688690E-04,-2.67619892E-04,-2.52994639E-04,
     8-2.36378122E-04,-2.17582125E-04,-1.95954621E-04,-1.72562085E-04,
     9-1.47323476E-04,-1.21375266E-04,-9.72882826E-05,-7.83117813E-05/
      DATA CH  10/
     1-6.16962878E-05,-4.76263106E-05,-3.55369461E-05,-2.67755473E-05,
     2-1.89963282E-05,-1.36034154E-05,-9.20135573E-06,-6.27727001E-06,
     3-4.31241145E-06,-2.63742438E-06,-1.44303115E-06,-7.09283125E-07,
     4-2.96621802E-07,-7.55764702E-08,-1.26731441E-08,-1.14008132E-09,
     5-7.71570818E-11,-5.38979485E-12,-3.85131719E-13,-2.79926878E-14,
     6 5.27450267E-04, 5.27548209E-04, 5.27621866E-04, 5.27757352E-04,
     7 5.28005236E-04, 5.28444092E-04, 5.29212980E-04, 5.42982886E-04,
     8 9.43257262E-05,-5.94289095E-04,-5.21949858E-04,-5.11218869E-04,
     9-4.98593743E-04,-4.82097986E-04,-4.55597512E-04,-4.25563821E-04/
      DATA CH  11/
     1-3.91641331E-04,-3.52647471E-04,-3.10500866E-04,-2.65051281E-04,
     2-2.18341644E-04,-1.74994619E-04,-1.40851146E-04,-1.10959921E-04,
     3-8.56508809E-05,-6.39065263E-05,-4.81490961E-05,-3.41589441E-05,
     4-2.44608124E-05,-1.65448705E-05,-1.12868617E-05,-7.75380763E-06,
     5-4.74205493E-06,-2.59450211E-06,-1.27523489E-06,-5.33293310E-07,
     6-1.35875428E-07,-2.27840386E-08,-2.04962735E-09,-1.38710531E-10,
     7-9.68951630E-12,-6.92367014E-13,-5.03233504E-14, 8.67939527E-04,
     8 8.68086519E-04, 8.68196952E-04, 8.68399838E-04, 8.68770151E-04,
     9 8.69422777E-04, 8.70555854E-04, 8.72685043E-04, 9.00316827E-04/
      DATA CH  12/
     1 1.18726820E-04,-1.05068040E-03,-8.51640282E-04,-8.30180001E-04,
     2-8.02328557E-04,-7.57838031E-04,-7.07603820E-04,-6.50991942E-04,
     3-5.86013815E-04,-5.15855799E-04,-4.40257134E-04,-3.62606802E-04,
     4-2.90576808E-04,-2.33857067E-04,-1.84211669E-04,-1.42183646E-04,
     5-1.06079989E-04,-7.99196360E-05,-5.66953416E-05,-4.05972023E-05,
     6-2.74581721E-05,-1.87312937E-05,-1.28676222E-05,-7.86932554E-06,
     7-4.30539149E-06,-2.11610499E-06,-8.84915842E-07,-2.25456988E-07,
     8-3.78043305E-08,-3.40075163E-09,-2.30144881E-10,-1.60763829E-11,
     9-1.14873131E-12,-8.34926889E-14, 1.61498414E-03, 1.61522856E-03/
      DATA CH  13/
     1 1.61541206E-03, 1.61574893E-03, 1.61636286E-03, 1.61744182E-03,
     2 1.61930543E-03, 1.62277036E-03, 1.62924770E-03, 1.68333458E-03,
     3 3.60899757E-04,-1.82730765E-03,-1.58410667E-03,-1.52899488E-03,
     4-1.44234855E-03,-1.34546950E-03,-1.23689296E-03,-1.11271628E-03,
     5-9.78971597E-04,-8.35109934E-04,-6.87538020E-04,-5.50779439E-04,
     6-4.43161682E-04,-3.49011624E-04,-2.69337615E-04,-2.00915634E-04,
     7-1.51349791E-04,-1.07355641E-04,-7.68658545E-05,-5.19840976E-05,
     8-3.54597507E-05,-2.43579442E-05,-1.48953901E-05,-8.14890300E-06,
     9-4.00495346E-06,-1.67469957E-06,-4.26647390E-07,-7.15352259E-08/
      DATA CH  14/
     1-6.43470743E-09,-4.35448549E-10,-3.04166311E-11,-2.17336083E-12,
     2-1.57962724E-13, 2.50720905E-03, 2.50755068E-03, 2.50780708E-03,
     3 2.50827754E-03, 2.50913426E-03, 2.51063770E-03, 2.51322757E-03,
     4 2.51801809E-03, 2.52687709E-03, 2.54289614E-03, 2.63774332E-03,
     5 1.76260416E-04,-2.78126196E-03,-2.45704320E-03,-2.31262955E-03,
     6-2.15394575E-03,-1.97774832E-03,-1.77739883E-03,-1.56245308E-03,
     7-1.33188374E-03,-1.09584644E-03,-8.77427902E-04,-7.05726344E-04,
     8-5.55621605E-04,-4.28668973E-04,-3.19696027E-04,-2.40783539E-04,
     9-1.70762699E-04,-1.22247776E-04,-8.26646695E-05,-5.63817215E-05/
      DATA CH  15/
     1-3.87261829E-05,-2.36795672E-05,-1.29532571E-05,-6.36557648E-06,
     2-2.66157673E-06,-6.77995222E-07,-1.13667632E-07,-1.02237148E-08,
     3-6.91813611E-10,-4.83219157E-11,-3.45263538E-12,-2.50935807E-13,
     4 3.20994276E-03, 3.21034034E-03, 3.21063867E-03, 3.21118592E-03,
     5 3.21218201E-03, 3.21392850E-03, 3.21693250E-03, 3.22247328E-03,
     6 3.23266196E-03, 3.25087011E-03, 3.28333413E-03, 3.52880121E-03,
     7 2.90599435E-04,-3.99201557E-03,-3.07880403E-03,-2.86239707E-03,
     8-2.62426711E-03,-2.35540482E-03,-2.06836350E-03,-1.76152461E-03,
     9-1.44821000E-03,-1.15882208E-03,-9.31623746E-04,-7.33184814E-04/
      DATA CH  16/
     1-5.65473991E-04,-4.21599458E-04,-3.17461291E-04,-2.25092147E-04,
     2-1.61113538E-04,-1.08927603E-04,-7.42843836E-05,-5.10170507E-05,
     3-3.11911486E-05,-1.70601847E-05,-8.38286988E-06,-3.50466057E-06,
     4-8.92642574E-07,-1.49636185E-07,-1.34574290E-08,-9.10558142E-10,
     5-6.35972818E-11,-4.54388504E-12,-3.30236900E-13, 5.61912502E-03,
     6 5.61974854E-03, 5.62021633E-03, 5.62107432E-03, 5.62263546E-03,
     7 5.62537113E-03, 5.63007179E-03, 5.63872596E-03, 5.65458361E-03,
     8 5.68273038E-03, 5.73223829E-03, 5.82772200E-03, 6.17039808E-03,
     9 1.43639190E-03,-6.68103918E-03,-5.37711410E-03,-4.91201049E-03/
      DATA CH  17/
     1-4.39582996E-03,-3.85110758E-03,-3.27335460E-03,-2.68668446E-03,
     2-2.14696473E-03,-1.72437761E-03,-1.35598680E-03,-1.04510471E-03,
     3-7.78728323E-04,-5.86104634E-04,-4.15382293E-04,-2.97210854E-04,
     4-2.00873337E-04,-1.36950183E-04,-9.40333957E-05,-5.74765590E-05,
     5-3.14294076E-05,-1.54399049E-05,-6.45358275E-06,-1.64330990E-06,
     6-2.75407226E-07,-2.47632234E-08,-1.67526173E-09,-1.16994342E-10,
     7-8.35829727E-12,-6.07419294E-13, 8.60872637E-03, 8.60958456E-03,
     8 8.61022836E-03, 8.61140900E-03, 8.61355681E-03, 8.61731911E-03,
     9 8.62377964E-03, 8.63565978E-03, 8.65738046E-03, 8.69577446E-03/
      DATA CH  18/
     1 8.76277550E-03, 8.88981793E-03, 9.07314195E-03, 9.60580772E-03,
     2 5.68967448E-04,-1.02680807E-02,-8.28490183E-03,-7.37632354E-03,
     3-6.43680809E-03,-5.45363991E-03,-4.46443150E-03,-3.56017279E-03,
     4-2.85517842E-03,-2.24242398E-03,-1.72651510E-03,-1.28528029E-03,
     5-9.66674652E-04,-6.84627687E-04,-4.89594200E-04,-3.30726916E-04,
     6-2.25387410E-04,-1.54703712E-04,-9.45251600E-05,-5.16691993E-05,
     7-2.53739882E-05,-1.06022757E-05,-2.69865726E-06,-4.52114678E-07,
     8-4.06387087E-08,-2.74859164E-09,-1.91919631E-10,-1.37094058E-11,
     9-9.96203776E-13, 1.04706488E-02, 1.04715868E-02, 1.04722905E-02/
      DATA CH  19/
     1 1.04735808E-02, 1.04759277E-02, 1.04800379E-02, 1.04870926E-02,
     2 1.05000549E-02, 1.05237187E-02, 1.05654328E-02, 1.06378618E-02,
     3 1.07738115E-02, 1.09663337E-02, 1.12726017E-02, 1.26399636E-02,
     4 1.00257118E-03,-1.32448573E-02,-1.02003884E-02,-8.84301595E-03,
     5-7.45329555E-03,-6.07603132E-03,-4.82977801E-03,-3.86459789E-03,
     6-3.02952045E-03,-2.32888278E-03,-1.73132600E-03,-1.30078168E-03,
     7-9.20311543E-04,-6.57610360E-04,-4.43884672E-04,-3.02318135E-04,
     8-2.07403662E-04,-1.26655650E-04,-6.91945397E-05,-3.39630183E-05,
     9-1.41841204E-05,-3.60829257E-06,-6.04192720E-07,-5.42826409E-08/
      DATA CH  20/
     1-3.67009568E-09,-2.56200381E-10,-1.82978663E-11,-1.32944308E-12,
     2 1.33110352E-02, 1.33121192E-02, 1.33129323E-02, 1.33144233E-02,
     3 1.33171350E-02, 1.33218831E-02, 1.33300305E-02, 1.33449935E-02,
     4 1.33722851E-02, 1.34203163E-02, 1.35034721E-02, 1.36586923E-02,
     5 1.38764431E-02, 1.42174069E-02, 1.49161828E-02, 1.68840513E-02,
     6 1.68049676E-03,-1.75585958E-02,-1.31968210E-02,-1.10288702E-02,
     7-8.93226417E-03,-7.06568073E-03,-5.63477235E-03,-4.40515439E-03,
     8-3.37877289E-03,-2.50692076E-03,-1.88069912E-03,-1.32869378E-03,
     9-9.48354161E-04,-6.39452497E-04,-4.35142460E-04,-2.98317864E-04/
      DATA CH  21/
     1-1.82035567E-04,-9.93745215E-05,-4.87418148E-05,-2.03423910E-05,
     2-5.17079894E-06,-8.65204519E-07,-7.76821776E-08,-5.24960379E-09,
     3-3.66338380E-10,-2.61574502E-11,-1.90012484E-12, 1.62635669E-02,
     4 1.62647788E-02, 1.62656879E-02, 1.62673547E-02, 1.62703861E-02,
     5 1.62756934E-02, 1.62847988E-02, 1.63015153E-02, 1.63319866E-02,
     6 1.63855544E-02, 1.64781138E-02, 1.66502535E-02, 1.68902874E-02,
     7 1.72624926E-02, 1.80097009E-02, 1.91301740E-02, 2.20507234E-02,
     8 1.60598467E-03,-2.29301685E-02,-1.64041170E-02,-1.31520191E-02,
     9-1.03269818E-02,-8.19508155E-03,-6.38158993E-03,-4.87910449E-03/
      DATA CH  22/
     1-3.61017455E-03,-2.70275023E-03,-1.90566618E-03,-1.35806528E-03,
     2-9.14371740E-04,-6.21497638E-04,-4.25669633E-04,-2.59477519E-04,
     3-1.41505510E-04,-6.93399826E-05,-2.89124421E-05,-7.34137704E-06,
     4-1.22720877E-06,-1.10088386E-07,-7.43470144E-09,-5.18589035E-10,
     5-3.70162362E-11,-2.68824340E-12, 1.90288838E-02, 1.90301864E-02,
     6 1.90311635E-02, 1.90329549E-02, 1.90362129E-02, 1.90419163E-02,
     7 1.90517000E-02, 1.90696574E-02, 1.91023759E-02, 1.91598480E-02,
     8 1.92590133E-02, 1.94429574E-02, 1.96983785E-02, 2.00918628E-02,
     9 2.08715613E-02, 2.20119512E-02, 2.37371486E-02, 2.83114149E-02/
      DATA CH  23/
     1 2.46456465E-03,-2.93002107E-02,-1.96758212E-02,-1.52741478E-02,
     2-1.20287271E-02,-9.31144019E-03,-7.08564280E-03,-5.22193919E-03,
     3-3.89775767E-03,-2.74046750E-03,-1.94871813E-03,-1.30935747E-03,
     4-8.88519151E-04,-6.07746487E-04,-3.69934554E-04,-2.01457063E-04,
     5-9.85867634E-05,-4.10554077E-05,-1.04094561E-05,-1.73777685E-06,
     6-1.55703706E-07,-1.05059482E-08,-7.32366100E-10,-5.22518089E-11,
     7-3.79339169E-12, 2.18877223E-02, 2.18891059E-02, 2.18901436E-02,
     8 2.18920464E-02, 2.18955065E-02, 2.19015636E-02, 2.19119529E-02,
     9 2.19310185E-02, 2.19657448E-02, 2.20267078E-02, 2.21317887E-02/
      DATA CH  24/
     1 2.23263409E-02, 2.25956922E-02, 2.30087684E-02, 2.38202866E-02,
     2 2.49891583E-02, 2.67122164E-02, 2.94459970E-02, 3.60952709E-02,
     3 2.92743075E-03,-3.73647840E-02,-2.38681375E-02,-1.85748279E-02,
     4-1.42447859E-02,-1.07616185E-02,-7.88376564E-03,-5.85888497E-03,
     5-4.10243568E-03,-2.90808105E-03,-1.94826632E-03,-1.31904346E-03,
     6-9.00545180E-04,-5.47062546E-04,-2.97330725E-04,-1.45238774E-04,
     7-6.03779764E-05,-1.52779792E-05,-2.54593371E-06,-2.27744155E-07,
     8-1.53482999E-08,-1.06903513E-09,-7.62254979E-11,-5.53125955E-12,
     9 2.36015431E-02, 2.36029258E-02, 2.36039630E-02, 2.36058645E-02/
      DATA CH  25/
     1 2.36093224E-02, 2.36153754E-02, 2.36257567E-02, 2.36448050E-02,
     2 2.36794912E-02, 2.37403567E-02, 2.38451879E-02, 2.40390035E-02,
     3 2.43067409E-02, 2.47159813E-02, 2.55150365E-02, 2.66539649E-02,
     4 2.83052241E-02, 3.08509749E-02, 3.47923899E-02, 4.46119530E-02,
     5 3.20503910E-03,-4.47187614E-02,-2.99247790E-02,-2.25420281E-02,
     6-1.68110438E-02,-1.21916112E-02,-8.99598614E-03,-6.25826949E-03,
     7-4.41481615E-03,-2.94457279E-03,-1.98669550E-03,-1.35260584E-03,
     8-8.19247514E-04,-4.43981117E-04,-2.16298007E-04,-8.96923905E-05,
     9-2.26304235E-05,-3.76143506E-06,-3.35701359E-07,-2.25853298E-08/
      DATA CH  26/
     1-1.57126337E-09,-1.11939888E-10,-8.11753486E-12, 2.10819534E-02,
     2 2.10831118E-02, 2.10839807E-02, 2.10855737E-02, 2.10884705E-02,
     3 2.10935411E-02, 2.11022372E-02, 2.11181919E-02, 2.11472395E-02,
     4 2.11981948E-02, 2.12859096E-02, 2.14479200E-02, 2.16713789E-02,
     5 2.20121631E-02, 2.26748079E-02, 2.36128573E-02, 2.49588564E-02,
     6 2.69994181E-02, 3.00695593E-02, 3.50546660E-02, 4.82036877E-02,
     7-7.97111783E-04,-4.87438566E-02,-3.09328678E-02,-2.26544845E-02,
     8-1.62047269E-02,-1.18463299E-02,-8.17351975E-03,-5.73132332E-03,
     9-3.80196984E-03,-2.55452966E-03,-1.73345966E-03,-1.04625341E-03/
      DATA CH  27/
     1-5.65090551E-04,-2.74450106E-04,-1.13476006E-04,-2.85368603E-05,
     2-4.72921747E-06,-4.20972316E-07,-2.82677419E-08,-1.96399356E-09,
     3-1.39783925E-10,-1.01292468E-11, 1.80345087E-02, 1.80354466E-02,
     4 1.80361500E-02, 1.80374397E-02, 1.80397849E-02, 1.80438900E-02,
     5 1.80509298E-02, 1.80638448E-02, 1.80873553E-02, 1.81285880E-02,
     6 1.81995382E-02, 1.83304906E-02, 1.85109119E-02, 1.87856137E-02,
     7 1.93181999E-02, 2.00685569E-02, 2.11377479E-02, 2.27412677E-02,
     8 2.51123942E-02, 2.88515368E-02, 3.50495187E-02, 5.16632021E-02,
     9 3.00500586E-03,-5.10502016E-02,-3.11834652E-02,-2.18472301E-02/
      DATA CH  28/
     1-1.57558003E-02,-1.07467788E-02,-7.47494351E-03,-4.92345064E-03,
     2-3.29037961E-03,-2.22343494E-03,-1.33610350E-03,-7.18622045E-04,
     3-3.47694325E-04,-1.43252461E-04,-3.58817234E-05,-5.92553698E-06,
     4-5.25827462E-07,-3.52284403E-08,-2.44380886E-09,-1.73737228E-10,
     5-1.25787831E-11, 1.64786075E-02, 1.64794279E-02, 1.64800433E-02,
     6 1.64811715E-02, 1.64832231E-02, 1.64868141E-02, 1.64929723E-02,
     7 1.65042692E-02, 1.65248325E-02, 1.65608906E-02, 1.66229198E-02,
     8 1.67373508E-02, 1.68948904E-02, 1.71344875E-02, 1.75980955E-02,
     9 1.82492013E-02, 1.91727468E-02, 2.05483911E-02, 2.25612944E-02/
      DATA CH  29/
     1 2.56821454E-02, 3.07104584E-02, 3.88090757E-02, 5.60828824E-02,
     2 1.38016993E-03,-5.70339351E-02,-3.20806211E-02,-2.27479574E-02,
     3-1.52901387E-02,-1.05291477E-02,-6.87599889E-03,-4.56641458E-03,
     4-3.07072472E-03,-1.83601908E-03,-9.82842417E-04,-4.73524685E-04,
     5-1.94334826E-04,-4.84650274E-05,-7.97307566E-06,-7.05164855E-07,
     6-4.71286473E-08,-3.26392278E-09,-2.31762737E-10,-1.67645871E-11,
     7 1.49382707E-02, 1.49389835E-02, 1.49395182E-02, 1.49404985E-02,
     8 1.49422810E-02, 1.49454010E-02, 1.49507513E-02, 1.49605658E-02,
     9 1.49784293E-02, 1.50097490E-02, 1.50636142E-02, 1.51629417E-02/
      DATA CH  30/
     1 1.52995974E-02, 1.55072323E-02, 1.59083061E-02, 1.64700506E-02,
     2 1.72637549E-02, 1.84392393E-02, 2.01445276E-02, 2.27531418E-02,
     3 2.68624659E-02, 3.32277631E-02, 4.20505558E-02, 6.32993021E-02,
     4 4.77638112E-03,-6.19856622E-02,-3.71436880E-02,-2.42903955E-02,
     5-1.64402688E-02,-1.05882308E-02,-6.96335960E-03,-4.64839913E-03,
     6-2.75889880E-03,-1.46685643E-03,-7.02504829E-04,-2.86746026E-04,
     7-7.10852755E-05,-1.16341887E-05,-1.02437882E-06,-6.82424944E-08,
     8-4.71587304E-09,-3.34334041E-10,-2.41552083E-11, 1.19676523E-02,
     9 1.19682039E-02, 1.19686175E-02, 1.19693759E-02, 1.19707550E-02/
      DATA CH  31/
     1 1.19731688E-02, 1.19773080E-02, 1.19849008E-02, 1.19987195E-02,
     2 1.20229452E-02, 1.20646023E-02, 1.21413936E-02, 1.22469917E-02,
     3 1.24073222E-02, 1.27166280E-02, 1.31489715E-02, 1.37581127E-02,
     4 1.46565416E-02, 1.59520156E-02, 1.79155963E-02, 2.09638003E-02,
     5 2.55738576E-02, 3.17370854E-02, 4.13539855E-02, 6.47330583E-02,
     6-3.13002439E-03,-6.64300268E-02,-3.38972397E-02,-2.25383908E-02,
     7-1.42927434E-02,-9.29930308E-03,-6.15889710E-03,-3.62688409E-03,
     8-1.91468013E-03,-9.11336795E-04,-3.69930636E-04,-9.11557818E-05,
     9-1.48423565E-05,-1.30108568E-06,-8.64017699E-08,-5.95801290E-09/
      DATA CH  32/
     1-4.21745668E-10,-3.04351150E-11, 9.90213654E-03, 9.90257751E-03,
     2 9.90290825E-03, 9.90351464E-03, 9.90461728E-03, 9.90654721E-03,
     3 9.90985662E-03, 9.91592702E-03, 9.92697457E-03, 9.94634027E-03,
     4 9.97963508E-03, 1.00409936E-02, 1.01253323E-02, 1.02533023E-02,
     5 1.04998993E-02, 1.08439750E-02, 1.13275447E-02, 1.20382071E-02,
     6 1.30576130E-02, 1.45908932E-02, 1.69430759E-02, 2.04359677E-02,
     7 2.49835860E-02, 3.18044908E-02, 4.24883980E-02, 7.17810122E-02,
     8 8.67332704E-03,-6.89895852E-02,-3.75877207E-02,-2.31267135E-02,
     9-1.47569239E-02,-9.64269831E-03,-5.60654549E-03,-2.92702753E-03/
      DATA CH  33/
     1-1.38022587E-03,-5.55694562E-04,-1.35743764E-04,-2.19418569E-05,
     2-1.91162598E-06,-1.26393983E-07,-8.69039953E-09,-6.13877527E-10,
     3-4.42306311E-11, 8.17766125E-03, 8.17801593E-03, 8.17828196E-03,
     4 8.17876969E-03, 8.17965656E-03, 8.18120883E-03, 8.18387062E-03,
     5 8.18875298E-03, 8.19763809E-03, 8.21321213E-03, 8.23998502E-03,
     6 8.28931430E-03, 8.35709735E-03, 8.45989986E-03, 8.65784069E-03,
     7 8.93367940E-03, 9.32067034E-03, 9.88797957E-03, 1.06988496E-02,
     8 1.19121548E-02, 1.37590627E-02, 1.64702835E-02, 1.99453256E-02,
     9 2.50435890E-02, 3.27774721E-02, 4.59347375E-02, 7.42013248E-02/
      DATA CH  34/
     1-3.84440691E-03,-7.61316789E-02,-3.61005009E-02,-2.25876634E-02,
     2-1.45415779E-02,-8.33864216E-03,-4.30235527E-03,-2.00920297E-03,
     3-8.02224334E-04,-1.94269373E-04,-3.11778855E-05,-2.70011013E-06,
     4-1.77780823E-07,-1.21896014E-08,-8.59347250E-10,-6.18247844E-11,
     5 6.11252521E-03, 6.11278293E-03, 6.11297622E-03, 6.11333061E-03,
     6 6.11397502E-03, 6.11510290E-03, 6.11703692E-03, 6.12058433E-03,
     7 6.12703979E-03, 6.13835434E-03, 6.15780263E-03, 6.19362889E-03,
     8 6.24284199E-03, 6.31744633E-03, 6.46097742E-03, 6.66074206E-03,
     9 6.94051524E-03, 7.34963242E-03, 7.93233789E-03, 8.79983611E-03/
      DATA CH  35/
     1 1.01105399E-02, 1.20139653E-02, 1.44190263E-02, 1.78794221E-02,
     2 2.29776191E-02, 3.12457639E-02, 4.32092822E-02, 8.03682628E-02,
     3 7.96504037E-03,-7.77435659E-02,-3.82082769E-02,-2.39372959E-02,
     4-1.33928966E-02,-6.77602270E-03,-3.11640595E-03,-1.22867876E-03,
     5-2.93764570E-04,-4.66654415E-05,-4.00773967E-06,-2.62358411E-07,
     6-1.79205213E-08,-1.25997124E-09,-9.04651546E-11, 4.84035718E-03,
     7 4.84055683E-03, 4.84070657E-03, 4.84098112E-03, 4.84148033E-03,
     8 4.84235409E-03, 4.84385235E-03, 4.84660042E-03, 4.85160115E-03,
     9 4.86036555E-03, 4.87542922E-03, 4.90317432E-03, 4.94127798E-03/
      DATA CH  36/
     1 4.99902191E-03, 5.11005101E-03, 5.26444026E-03, 5.48039520E-03,
     2 5.79563422E-03, 6.24351713E-03, 6.90795579E-03, 7.90675700E-03,
     3 9.34685632E-03, 1.11498855E-02, 1.37134602E-02, 1.74284831E-02,
     4 2.33075143E-02, 3.15464164E-02, 4.71303961E-02, 8.31860584E-02,
     5-1.39809080E-03,-8.27387920E-02,-4.26914313E-02,-2.30114305E-02,
     6-1.13291684E-02,-5.10872289E-03,-1.98326793E-03,-4.67128039E-04,
     7-7.33488891E-05,-6.24146834E-06,-4.06032922E-07,-2.76215859E-08,
     8-1.93648608E-09,-1.38742936E-10, 3.06078216E-03, 3.06090577E-03,
     9 3.06099849E-03, 3.06116847E-03, 3.06147755E-03, 3.06201853E-03/
      DATA CH  37/
     1 3.06294614E-03, 3.06464754E-03, 3.06774352E-03, 3.07316939E-03,
     2 3.08249429E-03, 3.09966707E-03, 3.12324631E-03, 3.15896846E-03,
     3 3.22761787E-03, 3.32299780E-03, 3.45626012E-03, 3.65047653E-03,
     4 3.92579238E-03, 4.33292826E-03, 4.94215751E-03, 5.81499105E-03,
     5 6.89908541E-03, 8.42487188E-03, 1.06056083E-02, 1.39880458E-02,
     6 1.85952310E-02, 2.69222098E-02, 3.97570231E-02, 8.17551485E-02,
     7-2.09131453E-03,-8.11066235E-02,-3.25775813E-02,-1.56223141E-02,
     8-6.89366661E-03,-2.63175306E-03,-6.10107245E-04,-9.46532067E-05,
     9-7.97870666E-06,-5.15774840E-07,-3.49442591E-08,-2.44287458E-09/
      DATA CH  38/
     1-1.74654400E-10, 2.40512571E-03, 2.40522114E-03, 2.40529272E-03,
     2 2.40542396E-03, 2.40566258E-03, 2.40608023E-03, 2.40679639E-03,
     3 2.40810991E-03, 2.41050005E-03, 2.41468874E-03, 2.42188700E-03,
     4 2.43514190E-03, 2.45333866E-03, 2.48089982E-03, 2.53384359E-03,
     5 2.60735450E-03, 2.70997012E-03, 2.85933438E-03, 3.07069863E-03,
     6 3.38249757E-03, 3.84744668E-03, 4.51040248E-03, 5.32899596E-03,
     7 6.47276667E-03, 8.09200038E-03, 1.05707708E-02, 1.38891885E-02,
     8 1.97365176E-02, 2.84560234E-02, 4.53047976E-02, 8.93548007E-02,
     9 1.14633644E-02,-8.50321604E-02,-2.84309792E-02,-1.22811274E-02/
      DATA CH  39/
     1-4.58861788E-03,-1.04252349E-03,-1.59353873E-04,-1.32809492E-05,
     2-8.52138923E-07,-5.74588777E-08,-4.00355036E-09,-2.85539274E-10,
     3 2.01712685E-03, 2.01720552E-03, 2.01726451E-03, 2.01737268E-03,
     4 2.01756936E-03, 2.01791361E-03, 2.01850388E-03, 2.01958652E-03,
     5 2.02155648E-03, 2.02500871E-03, 2.03094102E-03, 2.04186369E-03,
     6 2.05685634E-03, 2.07955939E-03, 2.12315372E-03, 2.18364614E-03,
     7 2.26801810E-03, 2.39068326E-03, 2.56398272E-03, 2.81904874E-03,
     8 3.19818241E-03, 3.73643021E-03, 4.39752935E-03, 5.31530603E-03,
     9 6.60386497E-03, 8.55456517E-03, 1.11290500E-02, 1.55742879E-02/
      DATA CH  40/
     1 2.20122110E-02, 3.39250844E-02, 5.36878777E-02, 9.95979074E-02,
     2 7.38783044E-03,-9.50072179E-02,-2.79356771E-02,-1.01851683E-02,
     3-2.24587849E-03,-3.36029960E-04,-2.75671564E-05,-1.75095562E-06,
     4-1.17317849E-07,-8.13872981E-09,-5.78618369E-10, 1.33691378E-03,
     5 1.33696491E-03, 1.33700326E-03, 1.33707358E-03, 1.33720143E-03,
     6 1.33742520E-03, 1.33780889E-03, 1.33851262E-03, 1.33979310E-03,
     7 1.34203698E-03, 1.34589263E-03, 1.35299095E-03, 1.36273259E-03,
     8 1.37748057E-03, 1.40578764E-03, 1.44504138E-03, 1.49974151E-03,
     9 1.57916833E-03, 1.69118670E-03, 1.85566113E-03, 2.09931507E-03/
      DATA CH  41/
     1 2.44365704E-03, 2.86428333E-03, 3.44438938E-03, 4.25209311E-03,
     2 5.46149607E-03, 7.03592367E-03, 9.70370806E-03, 1.34682349E-02,
     3 2.01665716E-02, 3.06303250E-02, 4.73318755E-02, 1.06574541E-01,
     4 6.58083280E-03,-9.85451697E-02,-2.41064074E-02,-5.12218188E-03,
     5-7.41842410E-04,-5.94664130E-05,-3.72309705E-06,-2.47259455E-07,
     6-1.70506064E-08,-1.20694890E-09, 7.78854591E-04, 7.78883836E-04,
     7 7.78905770E-04, 7.78945986E-04, 7.79019109E-04, 7.79147093E-04,
     8 7.79366544E-04, 7.79769034E-04, 7.80501380E-04, 7.81784680E-04,
     9 7.83989647E-04, 7.88048628E-04, 7.93618284E-04, 8.02048402E-04/
      DATA CH  42/
     1 8.18222883E-04, 8.40638968E-04, 8.71850601E-04, 9.17120249E-04,
     2 9.80866557E-04, 1.07426366E-03, 1.21221123E-03, 1.40639039E-03,
     3 1.64246567E-03, 1.96622437E-03, 2.41386451E-03, 3.07813259E-03,
     4 3.93352139E-03, 5.36225587E-03, 7.34083699E-03, 1.07710625E-02,
     5 1.59396774E-02, 2.38349433E-02, 4.14797560E-02, 1.10667846E-01,
     6 6.69476806E-03,-1.00490686E-01,-8.34055502E-03,-1.38819796E-03,
     7-1.12607643E-04,-7.04375324E-06,-4.66733399E-07,-3.21186259E-08,
     8-2.26965265E-09, 4.45876399E-04, 4.45892830E-04, 4.45905154E-04,
     9 4.45927749E-04, 4.45968832E-04, 4.46040738E-04, 4.46164033E-04/
      DATA CH  43/
     1 4.46390164E-04, 4.46801609E-04, 4.47522568E-04, 4.48761254E-04,
     2 4.51041255E-04, 4.54169369E-04, 4.58903016E-04, 4.67981895E-04,
     3 4.80557056E-04, 4.98052784E-04, 5.23401307E-04, 5.59042637E-04,
     4 6.11155327E-04, 6.87908451E-04, 7.95544891E-04, 9.25829005E-04,
     5 1.10358370E-03, 1.34780443E-03, 1.70733573E-03, 2.16596771E-03,
     6 2.92284891E-03, 3.95529451E-03, 5.71016659E-03, 8.28724061E-03,
     7 1.21018809E-02, 2.02805452E-02, 3.94082016E-02, 1.19326015E-01,
     8 2.58470846E-02,-9.46027264E-02,-2.39823456E-03,-3.28979558E-04,
     9-2.15337590E-05,-1.44104765E-06,-9.94313398E-08,-7.02990926E-09/
      DATA CH  44/
     1 1.91892428E-04, 1.91899370E-04, 1.91904577E-04, 1.91914122E-04,
     2 1.91931479E-04, 1.91961858E-04, 1.92013946E-04, 1.92109479E-04,
     3 1.92283299E-04, 1.92587867E-04, 1.93111123E-04, 1.94074172E-04,
     4 1.95395272E-04, 1.97394042E-04, 2.01226243E-04, 2.06531377E-04,
     5 2.13906976E-04, 2.24582219E-04, 2.39571298E-04, 2.61445769E-04,
     6 2.93578931E-04, 3.38486848E-04, 3.92625716E-04, 4.66147726E-04,
     7 5.66593618E-04, 7.13435719E-04, 8.99238192E-04, 1.20277877E-03,
     8 1.61173826E-03, 2.29607918E-03, 3.28165543E-03, 4.70753692E-03,
     9 7.66612215E-03, 1.42774187E-02, 3.06073228E-02, 1.11348077E-01/
      DATA CH  45/
     1 9.05174743E-03,-9.10890130E-02, 4.23839019E-03, 6.52943626E-05,
     2 1.76371806E-06, 4.67683038E-08, 4.29648844E-10, 3.88348135E-05,
     3 3.88361829E-05, 3.88372100E-05, 3.88390931E-05, 3.88425171E-05,
     4 3.88485098E-05, 3.88587853E-05, 3.88776307E-05, 3.89119188E-05,
     5 3.89719962E-05, 3.90752038E-05, 3.92651340E-05, 3.95256307E-05,
     6 3.99196469E-05, 4.06747385E-05, 4.17193111E-05, 4.31701504E-05,
     7 4.52672436E-05, 4.82063665E-05, 5.24848668E-05, 5.87483530E-05,
     8 6.74626885E-05, 7.79135491E-05, 9.20210692E-05, 1.11156157E-04,
     9 1.38882621E-04, 1.73609351E-04, 2.29633624E-04, 3.03982032E-04/
      DATA CH  46/
     1 4.26086041E-04, 5.97959532E-04, 8.40167451E-04, 1.32446578E-03,
     2 2.34418068E-03, 4.64229330E-03, 1.03060732E-02, 1.02579871E-01,
     3 1.40535965E-02,-8.03045607E-02, 5.76840587E-03, 1.50710934E-04,
     4 6.92153933E-06, 3.81045304E-07, 4.55312566E-06, 4.55328223E-06,
     5 4.55339966E-06, 4.55361495E-06, 4.55400643E-06, 4.55469159E-06,
     6 4.55586639E-06, 4.55802098E-06, 4.56194105E-06, 4.56880930E-06,
     7 4.58060760E-06, 4.60231729E-06, 4.63208792E-06, 4.67710664E-06,
     8 4.76334352E-06, 4.88256254E-06, 5.04800120E-06, 5.28683607E-06,
     9 5.62100286E-06, 6.10633382E-06, 6.81460776E-06, 7.79601868E-06/
      DATA CH  47/
     1 8.96748562E-06, 1.05404093E-05, 1.26603932E-05, 1.57087088E-05,
     2 1.94936487E-05, 2.55363991E-05, 3.34578555E-05, 4.62779780E-05,
     3 6.40158596E-05, 8.85481005E-05, 1.36412175E-04, 2.33722148E-04,
     4 4.43310225E-04, 9.62549398E-04, 2.23092560E-03, 8.73151804E-02,
     5 2.71444166E-03,-7.68157795E-02, 5.10252445E-03, 1.27671125E-04,
     6 5.67396829E-06,-7.73402679E-08,-7.73434165E-08,-7.73457781E-08,
     7-7.73501078E-08,-7.73579807E-08,-7.73717602E-08,-7.73953878E-08,
     8-7.74387240E-08,-7.75175795E-08,-7.76557706E-08,-7.78932455E-08,
     9-7.83305118E-08,-7.89307593E-08,-7.98398026E-08,-8.15856703E-08/
      DATA CH  48/
     1-8.40089168E-08,-8.73898190E-08,-9.23069411E-08,-9.92561203E-08,
     2-1.09485909E-07,-1.24687480E-07,-1.46242275E-07,-1.72647247E-07,
     3-2.09135396E-07,-2.59971094E-07,-3.35959627E-07,-4.34381901E-07,
     4-5.99372871E-07,-8.27837373E-07,-1.22141783E-06,-1.80526801E-06,
     5-2.67343677E-06,-4.52838449E-06,-8.80740898E-06,-1.97946979E-05,
     6-5.57319213E-05,-3.16220538E-04,-4.67708855E-03, 7.98809888E-02,
     7-1.74424993E-03,-7.73015278E-02, 5.08110768E-03, 1.26415472E-04,
     8-2.35229915E-08,-2.35238254E-08,-2.35244508E-08,-2.35255975E-08,
     9-2.35276826E-08,-2.35313319E-08,-2.35375891E-08,-2.35490651E-08/
      DATA CH  49/
     1-2.35699450E-08,-2.36065296E-08,-2.36693794E-08,-2.37850421E-08,
     2-2.39436824E-08,-2.41836442E-08,-2.46435373E-08,-2.52798064E-08,
     3-2.61636631E-08,-2.74414620E-08,-2.92327810E-08,-3.18412956E-08,
     4-3.56617144E-08,-4.09799727E-08,-4.73618779E-08,-5.59823597E-08,
     5-6.76834284E-08,-8.46519064E-08,-1.05922602E-07,-1.40270863E-07,
     6-1.85900967E-07,-2.60930271E-07,-3.66694583E-07,-5.16006631E-07,
     7-8.15470672E-07,-1.45050597E-06,-2.91340829E-06,-7.04558759E-06,
     8-2.99192566E-05,-2.26323937E-04,-5.82515447E-03, 7.79801956E-02,
     9 2.64981937E-05,-7.72380706E-02, 5.08455687E-03,-1.10721562E-09/
      DATA CH  50/
     1-1.10725448E-09,-1.10728363E-09,-1.10733706E-09,-1.10743423E-09,
     2-1.10760428E-09,-1.10789586E-09,-1.10843063E-09,-1.10940360E-09,
     3-1.11110836E-09,-1.11403694E-09,-1.11942618E-09,-1.12681742E-09,
     4-1.13799643E-09,-1.15941759E-09,-1.18904619E-09,-1.23018909E-09,
     5-1.28963998E-09,-1.37292604E-09,-1.49409450E-09,-1.67133328E-09,
     6-1.91765674E-09,-2.21268824E-09,-2.61035604E-09,-3.14876883E-09,
     7-3.92717721E-09,-4.89960462E-09,-6.46347526E-09,-8.53112373E-09,
     8-1.19118032E-08,-1.66462726E-08,-2.32831944E-08,-3.64734820E-08,
     9-6.40818411E-08,-1.26528298E-07,-2.98194168E-07,-1.19785294E-06/
      DATA CH  51/
     1-8.01992633E-06,-1.26283859E-04,-5.07820452E-03, 7.73783206E-02,
     2 5.35582696E-03,-1.43906176E-01,-8.42356555E-11,-8.42385674E-11,
     3-8.42407515E-11,-8.42447557E-11,-8.42520365E-11,-8.42647795E-11,
     4-8.42866291E-11,-8.43267015E-11,-8.43996095E-11,-8.45273508E-11,
     5-8.47467877E-11,-8.51505756E-11,-8.57043109E-11,-8.65417017E-11,
     6-8.81459237E-11,-9.03639825E-11,-9.34424940E-11,-9.78878527E-11,
     7-1.04109656E-10,-1.13150043E-10,-1.26351379E-10,-1.44658354E-10,
     8-1.66530972E-10,-1.95930758E-10,-2.35606951E-10,-2.92748415E-10,
     9-3.63830105E-10,-4.77578458E-10,-6.27122117E-10,-8.70043981E-10/
      DATA CH  52/
     1-1.20775676E-09,-1.67755564E-09,-2.60232678E-09,-4.51267404E-09,
     2-8.75886974E-09,-2.01539927E-08,-7.73451278E-08,-4.77509588E-07,
     3-6.26368061E-06,-1.38811220E-04,-5.35582696E-03, 6.66666667E-02,
     4 1.38689160E-01/
      END
      subroutine fileopen
c
c     version for sequential files
c
c     This is a subprogram which opens as many files (with prescribed
c     unit number and filename) as one may wish.
c     !!! Note that SEQUENTIAL FILES are implicitly !!!
c     !!! assumed in this program !!!
c     The necessary file-data should be prepared in advance
c     in a text file, e.g., the one named 'fileopen.dat'.
c     In the first column, write any one of the following flags
c     specifying the data-form of the file (blank or any other
c     character is not allowed):
c     F or f  -----> FORMATTED
c     U or u  -----> UNFORMATTED
c     B or b  -----> BINARY
c     The parameter nunit0, assumed to be within 2<=|nunit0|<=99,
c     must be written in columns 2-4 with the format (i3).
c     If nunit0 is positive, the access mode is 'SEQUENTIAL'.
c     Meanwhile, negative nunit0 implies the access mode of 'APPEND'.
c     The name of the file (fname) may be written whereever you wish
c     if it is placed within columns 5-64.
c     (i.e.,head-blanks and tail-blanks are neglected).
c     Note, however, that blanks should not be inserted within fname.
c     When all of the fname-field is kept blank, a scratch file
c     will be assigned.
c
      implicit real*8 (a-h,o-z)
      character*60 fname
      character*12 fform
      character*1 flag
      character*60 fnobspec
      common/obspass/fnobspec
      write(*,*) '<<<<<<<<<<<< files used for this job >>>>>>>>>>>>'
    1 read(1,'(a1,i3,a60)',err=998,end=999) flag,nunit0,fname
      nunit=iabs(nunit0)
c     save the file name of observed spectrum to fnobspec
      if(nunit.eq.9) fnobspec=fname
c
      if(flag.eq.'F'.or.flag.eq.'f') then
      fform='formatted'
      go to 8
      end if
      if(flag.eq.'U'.or.flag.eq.'u') then
      fform='unformatted'
      go to 8
      end if
      if(flag.eq.'B'.or.flag.eq.'b') then
      fform='binary'
      go to 8
      end if
      write(*,*) 'I do not understand the flag --> ',flag
      stop
    8 continue
      do 10 i=1,60
      if(fname(i:i).ne.' ') go to 20
   10 continue
      open(unit=nunit,form=fform,status='scratch')
      write(*,'('' flag='',a1,2x,''nunit0='',i3,2x,''(scratch file)'')'
     %) flag,nunit0
      go to 30
   20 continue
      if(nunit.eq.9) then
        call checkfit(fnobspec,ifbl,norder)
        if(ifbl.ne.0) then
                fname=fnobspec(1:iabs(ifbl)-1)
        else
                fname=fnobspec
        end if
      end if
      if(nunit0.gt.0) then
      open(unit=nunit,form=fform,file=fname,access='SEQUENTIAL')
      else
      open(unit=nunit,form=fform,file=fname,access='APPEND')
      end if
      is=i
      do 110 i=60,1,-1
      if(fname(i:i).ne.' ') go to 120
  110 continue
  120 ie=i
      write(*,'('' flag='',a1,2x,''nunit0='',i3,2x,''fname='',(a))')
     % flag,nunit0,fname(is:ie)
   30 continue
      go to 1
  998 write(*,*) '!!! read error in subroutine fileopen !!!'
      stop
  999 write(*,*)
      return
      end
